/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.Set;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.annotation.TableType;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.catalog.TableSourceConverter;
import org.apache.flink.table.sources.CsvTableSource;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@TableType(value="csv")
@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u001b\t92i\u001d<UC\ndWmU8ve\u000e,7i\u001c8wKJ$XM\u001d\u0006\u0003\u0007\u0011\tqa]8ve\u000e,7O\u0003\u0002\u0006\r\u0005)A/\u00192mK*\u0011q\u0001C\u0001\u0006M2Lgn\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0004+aQR\"\u0001\f\u000b\u0005]!\u0011aB2bi\u0006dwnZ\u0005\u00033Y\u0011A\u0003V1cY\u0016\u001cv.\u001e:dK\u000e{gN^3si\u0016\u0014\bCA\u000e\u001d\u001b\u0005\u0011\u0011BA\u000f\u0003\u00059\u00195O\u001e+bE2,7k\\;sG\u0016DQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005m\u0001\u0001bB\u0012\u0001\u0005\u0004%I\u0001J\u0001\te\u0016\fX/\u001b:fIV\tQ\u0005E\u0002'W5j\u0011a\n\u0006\u0003Q%\nA!\u001e;jY*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\r\u0019V\r\u001e\t\u0003]Er!aD\u0018\n\u0005A\u0002\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001\r\t\t\rU\u0002\u0001\u0015!\u0003&\u0003%\u0011X-];je\u0016$\u0007\u0005C\u00038\u0001\u0011\u0005C%\u0001\nsKF,\u0018N]3e!J|\u0007/\u001a:uS\u0016\u001c\b\"B\u001d\u0001\t\u0003R\u0014\u0001\u00074s_6,\u0005\u0010^3s]\u0006d7)\u0019;bY><G+\u00192mKR\u0011!d\u000f\u0005\u0006ya\u0002\r!P\u0001\u0015Kb$XM\u001d8bY\u000e\u000bG/\u00197pOR\u000b'\r\\3\u0011\u0005Uq\u0014BA \u0017\u0005Q)\u0005\u0010^3s]\u0006d7)\u0019;bY><G+\u00192mK\"\"\u0001!Q$I!\t\u0011U)D\u0001D\u0015\t!E!\u0001\u0006b]:|G/\u0019;j_:L!AR\"\u0003\u0013Q\u000b'\r\\3UsB,\u0017!\u0002<bYV,\u0017%A%\u0002\u0007\r\u001ch\u000f")
public class CsvTableSourceConverter
implements TableSourceConverter<CsvTableSource> {
    private final Set<String> required = ImmutableSet.of("path", "fieldDelim", "rowDelim");

    private Set<String> required() {
        return this.required;
    }

    @Override
    public Set<String> requiredProperties() {
        return this.required();
    }

    @Override
    public CsvTableSource fromExternalCatalogTable(ExternalCatalogTable externalCatalogTable) {
        Map params = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(externalCatalogTable.properties()).asScala();
        CsvTableSource.Builder csvTableSourceBuilder = new CsvTableSource.Builder();
        params.get((Object)"path").foreach((Function1)new Serializable(this, csvTableSourceBuilder){
            public static final long serialVersionUID = 0L;
            private final CsvTableSource.Builder csvTableSourceBuilder$1;

            public final CsvTableSource.Builder apply(String path) {
                return this.csvTableSourceBuilder$1.path(path);
            }
            {
                this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
            }
        });
        params.get((Object)"fieldDelim").foreach((Function1)new Serializable(this, csvTableSourceBuilder){
            public static final long serialVersionUID = 0L;
            private final CsvTableSource.Builder csvTableSourceBuilder$1;

            public final CsvTableSource.Builder apply(String delim) {
                return this.csvTableSourceBuilder$1.fieldDelimiter(delim);
            }
            {
                this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
            }
        });
        params.get((Object)"rowDelim").foreach((Function1)new Serializable(this, csvTableSourceBuilder){
            public static final long serialVersionUID = 0L;
            private final CsvTableSource.Builder csvTableSourceBuilder$1;

            public final CsvTableSource.Builder apply(String delim) {
                return this.csvTableSourceBuilder$1.lineDelimiter(delim);
            }
            {
                this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
            }
        });
        params.get((Object)"quoteCharacter").foreach((Function1)new Serializable(this, csvTableSourceBuilder){
            public static final long serialVersionUID = 0L;
            private final CsvTableSource.Builder csvTableSourceBuilder$1;

            public final CsvTableSource.Builder apply(String quoteStr) {
                if (quoteStr.length() != 1) {
                    throw new IllegalArgumentException("the value of param must only contain one character!");
                }
                return this.csvTableSourceBuilder$1.quoteCharacter(Predef$.MODULE$.char2Character(quoteStr.charAt(0)));
            }
            {
                this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
            }
        });
        params.get((Object)"ignoreFirstLine").foreach((Function1)new Serializable(this, csvTableSourceBuilder){
            public static final long serialVersionUID = 0L;
            private final CsvTableSource.Builder csvTableSourceBuilder$1;

            public final Object apply(String ignoreFirstLineStr) {
                return new StringOps(Predef$.MODULE$.augmentString(ignoreFirstLineStr)).toBoolean() ? this.csvTableSourceBuilder$1.ignoreFirstLine() : BoxedUnit.UNIT;
            }
            {
                this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
            }
        });
        params.get((Object)"ignoreComments").foreach((Function1)new Serializable(this, csvTableSourceBuilder){
            public static final long serialVersionUID = 0L;
            private final CsvTableSource.Builder csvTableSourceBuilder$1;

            public final CsvTableSource.Builder apply(String prefix) {
                return this.csvTableSourceBuilder$1.commentPrefix(prefix);
            }
            {
                this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
            }
        });
        params.get((Object)"lenient").foreach((Function1)new Serializable(this, csvTableSourceBuilder){
            public static final long serialVersionUID = 0L;
            private final CsvTableSource.Builder csvTableSourceBuilder$1;

            public final Object apply(String lenientStr) {
                return new StringOps(Predef$.MODULE$.augmentString(lenientStr)).toBoolean() ? this.csvTableSourceBuilder$1.ignoreParseErrors() : BoxedUnit.UNIT;
            }
            {
                this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])externalCatalogTable.schema().getColumnNames()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])externalCatalogTable.schema().getTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
            public static final long serialVersionUID = 0L;
            private final CsvTableSource.Builder csvTableSourceBuilder$1;

            public final CsvTableSource.Builder apply(Tuple2<String, TypeInformation<?>> field) {
                return this.csvTableSourceBuilder$1.field((String)field._1(), (TypeInformation)field._2());
            }
            {
                this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
            }
        });
        return csvTableSourceBuilder.build();
    }
}

