/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001=\u0011aCU8x)&lWMQ8v]\u0012,GMU8xg>3XM\u001d\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0007\t\u0005#I!B#D\u0001\u0003\u0013\t\u0019\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000bQL\b/Z:\n\u0005e1\"\u0001B\"S_^\u00042a\u0007\u0010!\u001b\u0005a\"BA\u000f\u0007\u0003\u001d\u0019w\u000eZ3hK:L!a\b\u000f\u0003\u0011\r{W\u000e]5mKJ\u0004\"!E\u0011\n\u0005\t\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005yq-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u0002\u001cM%\u0011q\u0005\b\u0002\u001e\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\rVt7\r^5p]\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u000bbO\u001e\u0014XmZ1uS>t7\u000b^1uKRK\b/\u001a\t\u0003WIj\u0011\u0001\f\u0006\u0003[9\n\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0005=\u0002\u0014\u0001\u00026bm\u0006T!!\r\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u00024Y\tY!k\\<UsB,\u0017J\u001c4p\u0011!)\u0004A!A!\u0002\u00131\u0014\u0001D5oaV$(k\\<UsB,\u0007CA\u000b8\u0013\tAdC\u0001\u0007D%><H+\u001f9f\u0013:4w\u000e\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0003=\u0001(/Z2fI&twm\u00144gg\u0016$\bC\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$\u0001\u0002'p]\u001eD\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\fcV,'/_\"p]\u001aLw\r\u0005\u0002E\r6\tQI\u0003\u00022\r%\u0011q)\u0012\u0002\u0012'R\u0014X-Y7Rk\u0016\u0014\u0018pQ8oM&<\u0007\"B%\u0001\t\u0003Q\u0015A\u0002\u001fj]&$h\b\u0006\u0004L\u00196su\n\u0015\t\u0003#\u0001AQ\u0001\n%A\u0002\u0015BQ!\u000b%A\u0002)BQ!\u000e%A\u0002YBQA\u000f%A\u0002mBQA\u0011%A\u0002\rC\u0011B\u0015\u0001A\u0002\u0003\u0007I\u0011B*\u0002\r=,H\u000f];u+\u0005!\u0002\"C+\u0001\u0001\u0004\u0005\r\u0011\"\u0003W\u0003)yW\u000f\u001e9vi~#S-\u001d\u000b\u0003/j\u0003\"\u0001\u0010-\n\u0005ek$\u0001B+oSRDqa\u0017+\u0002\u0002\u0003\u0007A#A\u0002yIEBa!\u0018\u0001!B\u0013!\u0012aB8viB,H\u000f\t\u0005\n?\u0002\u0001\r\u00111A\u0005\n\u0001\fQ\u0003\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$X-F\u0001b!\r\u0011wmO\u0007\u0002G*\u0011A-Z\u0001\u0006gR\fG/\u001a\u0006\u0003MB\naaY8n[>t\u0017B\u00015d\u0005)1\u0016\r\\;f'R\fG/\u001a\u0005\nU\u0002\u0001\r\u00111A\u0005\n-\f\u0011\u0004\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$Xm\u0018\u0013fcR\u0011q\u000b\u001c\u0005\b7&\f\t\u00111\u0001b\u0011\u0019q\u0007\u0001)Q\u0005C\u00061B.Y:u)JLwmZ3sS:<Gk]*uCR,\u0007\u0005C\u0005q\u0001\u0001\u0007\t\u0019!C\u0005A\u0006qA-\u0019;b\u0007>,h\u000e^*uCR,\u0007\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0003t\u0003I!\u0017\r^1D_VtGo\u0015;bi\u0016|F%Z9\u0015\u0005]#\bbB.r\u0003\u0003\u0005\r!\u0019\u0005\u0007m\u0002\u0001\u000b\u0015B1\u0002\u001f\u0011\fG/Y\"pk:$8\u000b^1uK\u0002B\u0011\u0002\u001f\u0001A\u0002\u0003\u0007I\u0011B=\u0002!\u0005\u001c7-^7vY\u0006$xN]*uCR,W#\u0001>\u0011\u0007\t<7\u0010\u0005\u0002}}6\tQP\u0003\u0002\u0018\u0011%\u0011q0 \u0002\u0004%><\bbCA\u0002\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000b\tA#Y2dk6,H.\u0019;peN#\u0018\r^3`I\u0015\fHcA,\u0002\b!A1,!\u0001\u0002\u0002\u0003\u0007!\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0015\u0002>\u0002#\u0005\u001c7-^7vY\u0006$xN]*uCR,\u0007\u0005C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\n\u0005E\u0011!\u00033bi\u0006\u001cF/\u0019;f+\t\t\u0019\u0002\u0005\u0004c\u0003+Y\u0014\u0011D\u0005\u0004\u0003/\u0019'\u0001C'baN#\u0018\r^3\u0011\u000b\u0005m\u00111E>\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tA!\u001e;jY*\tq&\u0003\u0003\u0002&\u0005u!\u0001\u0002'jgRD1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\u0005iA-\u0019;b'R\fG/Z0%KF$2aVA\u0017\u0011%Y\u0016qEA\u0001\u0002\u0004\t\u0019\u0002\u0003\u0005\u00022\u0001\u0001\u000b\u0015BA\n\u0003)!\u0017\r^1Ti\u0006$X\r\t\u0005\n\u0003k\u0001!\u0019!C\u0001\u0003o\t1\u0001T(H+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\ty\u0004D\u0001\u0006g24GG[\u0005\u0005\u0003\u0007\niD\u0001\u0004M_\u001e<WM\u001d\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002:\u0005!AjT$!\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%I!!\u0014\u0002\u0011\u0019,hn\u0019;j_:,\u0012\u0001\t\u0005\f\u0003#\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019&\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002X\u0003+B\u0001bWA(\u0003\u0003\u0005\r\u0001\t\u0005\b\u00033\u0002\u0001\u0015)\u0003!\u0003%1WO\\2uS>t\u0007\u0005C\u0004\u0002^\u0001!\t%a\u0018\u0002\t=\u0004XM\u001c\u000b\u0004/\u0006\u0005\u0004\u0002CA2\u00037\u0002\r!!\u001a\u0002\r\r|gNZ5h!\u0011\t9'!\u001c\u000e\u0005\u0005%$bAA6\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\u001c\u0002j\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!a\u001d\u0001\t\u0003\n)(\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000f]\u000b9(a\u001f\u0002\u0018\"9\u0011\u0011PA9\u0001\u0004!\u0012AB5oaV$8\t\u0003\u0005\u0002~\u0005E\u0004\u0019AA@\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0003\u000b\u0019\n\u0005\u0004\u0002\u0004\u0006=E\u0003F\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006Ia-\u001e8di&|gn\u001d\u0006\u0004c\u0005-%bAAG\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003#\u000b)IA\bQe>\u001cWm]:Gk:\u001cG/[8o\u0013\u0011\t)*a$\u0003\u000f\r{g\u000e^3yi\"A\u0011\u0011TA9\u0001\u0004\tY*A\u0002pkR\u0004R!!(\u0002\"Ri!!a(\u000b\u0007\u0005}\u0001\"\u0003\u0003\u0002$\u0006}%!C\"pY2,7\r^8s\u0011\u001d\t9\u000b\u0001C!\u0003S\u000bqa\u001c8US6,'\u000fF\u0004X\u0003W\u000by+a.\t\u000f\u00055\u0016Q\u0015a\u0001w\u0005IA/[7fgR\fW\u000e\u001d\u0005\t\u0003{\n)\u000b1\u0001\u00022B!\u0011\u0011QAZ\u0013\u0011\t),a$\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011\u0011TAS\u0001\u0004\tY\n")
public class RowTimeBoundedRowsOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Object> dataCountState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Object> dataCountState() {
        return this.dataCountState;
    }

    private void dataCountState_$eq(ValueState<Object> x$1) {
        this.dataCountState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor dataCountStateDescriptor = new ValueStateDescriptor("dataCountState", Long.TYPE);
        this.dataCountState_$eq((ValueState<Object>)this.getRuntimeContext().getState(dataCountStateDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        Long triggeringTs = ctx.timestamp();
        long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
        if (Predef$.MODULE$.Long2long(triggeringTs) > lastTriggeringTs) {
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(triggeringTs)));
            if (data == null) {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(triggeringTs)), data2);
                ctx.timerService().registerEventTimeTimer(Predef$.MODULE$.Long2long(triggeringTs));
            } else {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(triggeringTs)), (Object)data);
            }
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.dataCountState(), this.lastTriggeringTsState()}));
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            long dataCount = BoxesRunTime.unboxToLong((Object)this.dataCountState().value());
            List retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                Row input = (Row)inputs.get(i);
                if (accumulators == null) {
                    accumulators = this.function().createAccumulators();
                }
                Row retractRow = null;
                if (dataCount >= this.precedingOffset) {
                    if (retractList == null) {
                        retractTs = Long.MAX_VALUE;
                        Iterator dataTimestampIt = this.dataState().keys().iterator();
                        while (dataTimestampIt.hasNext()) {
                            long dataTs = BoxesRunTime.unboxToLong(dataTimestampIt.next());
                            if (dataTs >= retractTs) continue;
                            retractTs = dataTs;
                        }
                        retractList = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)retractTs));
                    }
                    retractRow = (Row)retractList.get(retractCnt);
                    if (retractList.size() == ++retractCnt) {
                        this.dataState().remove((Object)BoxesRunTime.boxToLong((long)retractTs));
                        retractList = null;
                        retractCnt = 0;
                    }
                } else {
                    ++dataCount;
                }
                this.function().setForwardedFields(input, this.output().row());
                if (retractRow != null) {
                    this.function().retract(accumulators, retractRow);
                }
                this.function().accumulate(accumulators, input);
                this.function().setAggregationResults(accumulators, this.output().row());
                out.collect((Object)this.output());
            }
            if (this.dataState().contains((Object)BoxesRunTime.boxToLong((long)retractTs)) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)retractTs), (Object)retractList);
            }
            this.dataCountState().update((Object)BoxesRunTime.boxToLong((long)dataCount));
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public RowTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        super(queryConfig);
        Compiler$class.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

