/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.Iterator;
import org.apache.flink.api.common.functions.CombineFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001=\u0011A\u0006R1uCN+Go\u00157jI\u0016$\u0016.\\3XS:$wn^!hOJ+G-^2f\u000fJ|W\u000f\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u0011$WA!\u0011\u0003\u0007\u000e\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003%1WO\\2uS>t7O\u0003\u0002\u0016-\u000511m\\7n_:T!a\u0006\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001a%\t9\"+[2i\u000fJ|W\u000f\u001d*fIV\u001cWMR;oGRLwN\u001c\t\u00037yi\u0011\u0001\b\u0006\u0003;!\tQ\u0001^=qKNL!a\b\u000f\u0003\u0007I{w\u000f\u0005\u0003\u0012CiQ\u0012B\u0001\u0012\u0013\u0005=\u0019u.\u001c2j]\u00164UO\\2uS>t\u0007c\u0001\u0013*55\tQE\u0003\u0002'O\u0005IA/\u001f9fkRLGn\u001d\u0006\u0003QY\tAA[1wC&\u0011!&\n\u0002\u0014%\u0016\u001cX\u000f\u001c;UsB,\u0017+^3ss\u0006\u0014G.\u001a\t\u0004Y=\nT\"A\u0017\u000b\u000592\u0011aB2pI\u0016<WM\\\u0005\u0003a5\u0012\u0001bQ8na&dWM\u001d\t\u0003eMj\u0011AA\u0005\u0003i\t\u0011QcR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7\u000f\u0003\u00057\u0001\t\u0015\r\u0011\"\u00038\u0003=9WM\\!hOJ,w-\u0019;j_:\u001cX#\u0001\u001d\u0011\u00051J\u0014B\u0001\u001e.\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002!\u001d,g.Q4he\u0016<\u0017\r^5p]N\u0004\u0003\u0002\u0003 \u0001\u0005\u000b\u0007I\u0011B \u0002--,\u0017p]!oI\u0006;wM]3hCR,7/\u0011:jif,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0004\u0013:$\b\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\u0002/-,\u0017p]!oI\u0006;wM]3hCR,7/\u0011:jif\u0004\u0003\u0002C%\u0001\u0005\u000b\u0007I\u0011\u0002&\u0002\u0015]Lg\u000eZ8x'&TX-F\u0001L!\t\tE*\u0003\u0002N\u0005\n!Aj\u001c8h\u0011!y\u0005A!A!\u0002\u0013Y\u0015aC<j]\u0012|woU5{K\u0002B\u0001\"\u0015\u0001\u0003\u0006\u0004%IAS\u0001\fo&tGm\\<TY&$W\r\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003L\u000319\u0018N\u001c3poNc\u0017\u000eZ3!\u0011!)\u0006A!b\u0001\n\u00131\u0016A\u0003:fiV\u0014h\u000eV=qKV\tq\u000bE\u0002Y7ji\u0011!\u0017\u0006\u00035R\t\u0001\u0002^=qK&tgm\\\u0005\u00039f\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t=\u0002\u0011\t\u0011)A\u0005/\u0006Y!/\u001a;ve:$\u0016\u0010]3!Q\ti\u0006\r\u0005\u0002BC&\u0011!M\u0011\u0002\niJ\fgn]5f]RDQ\u0001\u001a\u0001\u0005\u0002\u0015\fa\u0001P5oSRtDC\u00024hQ&T7\u000e\u0005\u00023\u0001!)ag\u0019a\u0001q!)ah\u0019a\u0001\u0001\")\u0011j\u0019a\u0001\u0017\")\u0011k\u0019a\u0001\u0017\")Qk\u0019a\u0001/\"9Q\u000e\u0001b\u0001\n\u0013y\u0014\u0001\u0004;j[\u00164\u0015.\u001a7e!>\u001c\bBB8\u0001A\u0003%\u0001)A\u0007uS6,g)[3mIB{7\u000f\t\u0005\bc\u0002\u0011\r\u0011\"\u0003@\u0003iIg\u000e^3s[\u0016$\u0017.\u0019;f/&tGm\\<Ti\u0006\u0014H\u000fU8t\u0011\u0019\u0019\b\u0001)A\u0005\u0001\u0006Y\u0012N\u001c;fe6,G-[1uK^Kg\u000eZ8x'R\f'\u000f\u001e)pg\u0002B\u0011\"\u001e\u0001A\u0002\u0003\u0007I\u0011\u0003<\u0002\u001f%tG/\u001a:nK\u0012L\u0017\r^3S_^,\u0012A\u0007\u0005\nq\u0002\u0001\r\u00111A\u0005\u0012e\f1#\u001b8uKJlW\rZ5bi\u0016\u0014vn^0%KF$\"A_?\u0011\u0005\u0005[\u0018B\u0001?C\u0005\u0011)f.\u001b;\t\u000fy<\u0018\u0011!a\u00015\u0005\u0019\u0001\u0010J\u0019\t\u000f\u0005\u0005\u0001\u0001)Q\u00055\u0005\u0001\u0012N\u001c;fe6,G-[1uKJ{w\u000f\t\u0005\u000b\u0003\u000b\u0001\u0001\u0019!a\u0001\n\u00131\u0018\u0001D1dGVlW\u000f\\1u_J\u001c\bbCA\u0005\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017\t\u0001#Y2dk6,H.\u0019;peN|F%Z9\u0015\u0007i\fi\u0001\u0003\u0005\u007f\u0003\u000f\t\t\u00111\u0001\u001b\u0011\u001d\t\t\u0002\u0001Q!\ni\tQ\"Y2dk6,H.\u0019;peN\u0004\u0003\"CA\u000b\u0001\t\u0007I\u0011AA\f\u0003\raujR\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?a\u0011!B:mMRR\u0017\u0002BA\u0012\u0003;\u0011a\u0001T8hO\u0016\u0014\b\u0002CA\u0014\u0001\u0001\u0006I!!\u0007\u0002\t1{u\t\t\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti#\u0001\u0005gk:\u001cG/[8o+\u0005\t\u0004bCA\u0019\u0001\u0001\u0007\t\u0019!C\u0005\u0003g\tABZ;oGRLwN\\0%KF$2A_A\u001b\u0011!q\u0018qFA\u0001\u0002\u0004\t\u0004bBA\u001d\u0001\u0001\u0006K!M\u0001\nMVt7\r^5p]\u0002Bq!!\u0010\u0001\t\u0003\ny$\u0001\u0003pa\u0016tGc\u0001>\u0002B!A\u00111IA\u001e\u0001\u0004\t)%\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111\n\u0005\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\ty%!\u0013\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\t\u0019\u0006\u0001C!\u0003+\naA]3ek\u000e,G#\u0002>\u0002X\u0005%\u0004\u0002CA-\u0003#\u0002\r!a\u0017\u0002\u000fI,7m\u001c:egB)\u0011QLA355\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0003mC:<'\"\u0001\u0015\n\t\u0005\u001d\u0014q\f\u0002\t\u0013R,'/\u00192mK\"A\u00111NA)\u0001\u0004\ti'A\u0002pkR\u0004R!a\u001c\u0002vii!!!\u001d\u000b\u0007\u0005M\u0004\"\u0001\u0003vi&d\u0017\u0002BA<\u0003c\u0012\u0011bQ8mY\u0016\u001cGo\u001c:\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~\u000591m\\7cS:,Gc\u0001\u000e\u0002\u0000!A\u0011\u0011LA=\u0001\u0004\tY\u0006C\u0004\u0002\u0004\u0002!\t%!\"\u0002\u001f\u001d,G\u000f\u0015:pIV\u001cW\r\u001a+za\u0016$\u0012a\u0016")
public class DataSetSlideTimeWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements CombineFunction<Row, Row>,
ResultTypeQueryable<Row>,
Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final int keysAndAggregatesArity;
    private final long windowSize;
    private final long windowSlide;
    private final transient TypeInformation<Row> returnType;
    private final int timeFieldPos;
    private final int intermediateWindowStartPos;
    private Row intermediateRow;
    private Row accumulators;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private int keysAndAggregatesArity() {
        return this.keysAndAggregatesArity;
    }

    private long windowSize() {
        return this.windowSize;
    }

    private long windowSlide() {
        return this.windowSlide;
    }

    private TypeInformation<Row> returnType() {
        return this.returnType;
    }

    private int timeFieldPos() {
        return this.timeFieldPos;
    }

    private int intermediateWindowStartPos() {
        return this.intermediateWindowStartPos;
    }

    public Row intermediateRow() {
        return this.intermediateRow;
    }

    public void intermediateRow_$eq(Row x$1) {
        this.intermediateRow = x$1;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getClass().getClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.accumulators_$eq(this.function().createAccumulators());
        this.intermediateRow_$eq(this.function().createOutputRow());
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        this.function().resetAccumulator(this.accumulators());
        Iterator<Row> iterator = records.iterator();
        Row record = null;
        while (iterator.hasNext()) {
            record = iterator.next();
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
        }
        long windowStart = BoxesRunTime.unboxToLong((Object)record.getField(this.timeFieldPos()));
        long start = TimeWindow.getWindowStartWithOffset((long)windowStart, (long)0L, (long)this.windowSlide());
        if (start > windowStart - this.windowSize()) {
            this.function().setAggregationResults(this.accumulators(), this.intermediateRow());
            this.function().setForwardedFields(record, this.intermediateRow());
            while (start > windowStart - this.windowSize()) {
                this.intermediateRow().setField(this.intermediateWindowStartPos(), (Object)BoxesRunTime.boxToLong((long)start));
                out.collect((Object)this.intermediateRow());
                start -= this.windowSlide();
            }
        }
    }

    public Row combine(Iterable<Row> records) {
        this.function().resetAccumulator(this.accumulators());
        Iterator<Row> iterator = records.iterator();
        Row record = null;
        while (iterator.hasNext()) {
            record = iterator.next();
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
        }
        this.function().setAggregationResults(this.accumulators(), this.intermediateRow());
        this.function().setForwardedFields(record, this.intermediateRow());
        this.intermediateRow().setField(this.timeFieldPos(), record.getField(this.timeFieldPos()));
        return this.intermediateRow();
    }

    public TypeInformation<Row> getProducedType() {
        return this.returnType();
    }

    public DataSetSlideTimeWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, int keysAndAggregatesArity, long windowSize, long windowSlide, TypeInformation<Row> returnType) {
        this.genAggregations = genAggregations;
        this.keysAndAggregatesArity = keysAndAggregatesArity;
        this.windowSize = windowSize;
        this.windowSlide = windowSlide;
        this.returnType = returnType;
        Compiler$class.$init$(this);
        this.timeFieldPos = returnType.getArity() - 1;
        this.intermediateWindowStartPos = keysAndAggregatesArity;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

