/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.RowTimeWindowPropertyCollector;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001=\u0011!\u0006R1uCN+GoU3tg&|gnV5oI><\u0018iZ4SK\u0012,8-Z$s_V\u0004h)\u001e8di&|gN\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001\u0002\u0005\u0005\u0003\u00121iQR\"\u0001\n\u000b\u0005M!\u0012!\u00034v]\u000e$\u0018n\u001c8t\u0015\t)b#\u0001\u0004d_6lwN\u001c\u0006\u0003/!\t1!\u00199j\u0013\tI\"CA\fSS\u000eDwI]8vaJ+G-^2f\rVt7\r^5p]B\u00111DH\u0007\u00029)\u0011Q\u0004C\u0001\u0006if\u0004Xm]\u0005\u0003?q\u00111AU8x!\r\tCEJ\u0007\u0002E)\u00111EB\u0001\bG>$WmZ3o\u0013\t)#E\u0001\u0005D_6\u0004\u0018\u000e\\3s!\t9\u0003&D\u0001\u0003\u0013\tI#AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\t\u0011-\u0002!\u0011!Q\u0001\n1\nqbZ3o\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003C5J!A\f\u0012\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0017W\u0016L8/\u00118e\u0003\u001e<'/Z4bi\u0016\u001c\u0018I]5usB\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t\u0019\u0011J\u001c;\t\u0011a\u0002!\u0011!Q\u0001\ne\naCZ5oC2\u0014vn^,j]\u0012|wo\u0015;beR\u0004vn\u001d\t\u0004ei\n\u0014BA\u001e4\u0005\u0019y\u0005\u000f^5p]\"AQ\b\u0001B\u0001B\u0003%\u0011(\u0001\u000bgS:\fGNU8x/&tGm\\<F]\u0012\u0004vn\u001d\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u0006\u0019q-\u00199\u0011\u0005I\n\u0015B\u0001\"4\u0005\u0011auN\\4\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015\u000bq\"[:J]B,HoQ8nE&tW\r\u001a\t\u0003e\u0019K!aR\u001a\u0003\u000f\t{w\u000e\\3b]\")\u0011\n\u0001C\u0001\u0015\u00061A(\u001b8jiz\"ra\u0013'N\u001d>\u0003\u0016\u000b\u0005\u0002(\u0001!)1\u0006\u0013a\u0001Y!)\u0001\u0007\u0013a\u0001c!)\u0001\b\u0013a\u0001s!)Q\b\u0013a\u0001s!)q\b\u0013a\u0001\u0001\")A\t\u0013a\u0001\u000b\"I1\u000b\u0001a\u0001\u0002\u0004%I\u0001V\u0001\nG>dG.Z2u_J,\u0012!\u0016\t\u0003OYK!a\u0016\u0002\u0003=I{w\u000fV5nK^Kg\u000eZ8x!J|\u0007/\u001a:us\u000e{G\u000e\\3di>\u0014\b\"C-\u0001\u0001\u0004\u0005\r\u0011\"\u0003[\u00035\u0019w\u000e\u001c7fGR|'o\u0018\u0013fcR\u00111L\u0018\t\u0003eqK!!X\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b?b\u000b\t\u00111\u0001V\u0003\rAH%\r\u0005\u0007C\u0002\u0001\u000b\u0015B+\u0002\u0015\r|G\u000e\\3di>\u0014\b\u0005C\u0004d\u0001\t\u0007I\u0011\u00023\u0002;%tG/\u001a:nK\u0012L\u0017\r^3S_^<\u0016N\u001c3poN#\u0018M\u001d;Q_N,\u0012!\r\u0005\u0007M\u0002\u0001\u000b\u0011B\u0019\u0002=%tG/\u001a:nK\u0012L\u0017\r^3S_^<\u0016N\u001c3poN#\u0018M\u001d;Q_N\u0004\u0003b\u00025\u0001\u0005\u0004%I\u0001Z\u0001\u001cS:$XM]7fI&\fG/\u001a*po^Kg\u000eZ8x\u000b:$\u0007k\\:\t\r)\u0004\u0001\u0015!\u00032\u0003qIg\u000e^3s[\u0016$\u0017.\u0019;f%><x+\u001b8e_^,e\u000e\u001a)pg\u0002B\u0011\u0002\u001c\u0001A\u0002\u0003\u0007I\u0011B7\u0002\r=,H\u000f];u+\u0005Q\u0002\"C8\u0001\u0001\u0004\u0005\r\u0011\"\u0003q\u0003)yW\u000f\u001e9vi~#S-\u001d\u000b\u00037FDqa\u00188\u0002\u0002\u0003\u0007!\u0004\u0003\u0004t\u0001\u0001\u0006KAG\u0001\b_V$\b/\u001e;!\u0011%)\b\u00011AA\u0002\u0013%Q.\u0001\u0007bG\u000e,X.\u001e7bi>\u00148\u000fC\u0005x\u0001\u0001\u0007\t\u0019!C\u0005q\u0006\u0001\u0012mY2v[Vd\u0017\r^8sg~#S-\u001d\u000b\u00037fDqa\u0018<\u0002\u0002\u0003\u0007!\u0004\u0003\u0004|\u0001\u0001\u0006KAG\u0001\u000eC\u000e\u001cW/\\;mCR|'o\u001d\u0011\t\u000fu\u0004!\u0019!C\u0001}\u0006\u0019AjT$\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000ba\u0011!B:mMRR\u0017\u0002BA\u0005\u0003\u0007\u0011a\u0001T8hO\u0016\u0014\bbBA\u0007\u0001\u0001\u0006Ia`\u0001\u0005\u0019>;\u0005\u0005C\u0006\u0002\u0012\u0001\u0001\r\u00111A\u0005\n\u0005M\u0011\u0001\u00034v]\u000e$\u0018n\u001c8\u0016\u0003\u0019B1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a\u0005aa-\u001e8di&|gn\u0018\u0013fcR\u00191,a\u0007\t\u0011}\u000b)\"!AA\u0002\u0019Bq!a\b\u0001A\u0003&a%A\u0005gk:\u001cG/[8oA!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0012\u0001B8qK:$2aWA\u0014\u0011!\tI#!\tA\u0002\u0005-\u0012AB2p]\u001aLw\r\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005U\u0012q\u0006\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<\u00051!/\u001a3vG\u0016$RaWA\u001f\u0003#B\u0001\"a\u0010\u00028\u0001\u0007\u0011\u0011I\u0001\be\u0016\u001cwN\u001d3t!\u0015\t\u0019%!\u0014\u001b\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00027b]\u001eT!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)E\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011!\t\u0019&a\u000eA\u0002\u0005U\u0013aA8viB)\u0011qKA/55\u0011\u0011\u0011\f\u0006\u0004\u00037B\u0011\u0001B;uS2LA!a\u0018\u0002Z\tI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0003G\u0002A\u0011AA3\u0003Q!w.\u0012<bYV\fG/Z!oI\u000e{G\u000e\\3diR91,a\u001a\u0002j\u00055\u0004\u0002CA*\u0003C\u0002\r!!\u0016\t\u000f\u0005-\u0014\u0011\ra\u0001\u0001\u0006Yq/\u001b8e_^\u001cF/\u0019:u\u0011\u001d\ty'!\u0019A\u0002\u0001\u000b\u0011b^5oI><XI\u001c3")
public class DataSetSessionWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements Compiler<GeneratedAggregations> {
    private final GeneratedAggregationsFunction genAggregations;
    private final Option<Object> finalRowWindowStartPos;
    private final Option<Object> finalRowWindowEndPos;
    private final long gap;
    private final boolean isInputCombined;
    private RowTimeWindowPropertyCollector collector;
    private final int intermediateRowWindowStartPos;
    private final int intermediateRowWindowEndPos;
    private Row output;
    private Row accumulators;
    private final Logger LOG;
    private GeneratedAggregations function;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private RowTimeWindowPropertyCollector collector() {
        return this.collector;
    }

    private void collector_$eq(RowTimeWindowPropertyCollector x$1) {
        this.collector = x$1;
    }

    private int intermediateRowWindowStartPos() {
        return this.intermediateRowWindowStartPos;
    }

    private int intermediateRowWindowEndPos() {
        return this.intermediateRowWindowEndPos;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    public Logger LOG() {
        return this.LOG;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getClass().getClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(this.function().createOutputRow());
        this.accumulators_$eq(this.function().createAccumulators());
        this.collector_$eq(new RowTimeWindowPropertyCollector(this.finalRowWindowStartPos, this.finalRowWindowEndPos));
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        Long windowStart = null;
        Long windowEnd = null;
        Long currentRowTime = null;
        this.function().resetAccumulator(this.accumulators());
        for (Row record : records) {
            currentRowTime = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.intermediateRowWindowStartPos())));
            if (windowEnd == null || windowEnd != null && Predef$.MODULE$.Long2long(currentRowTime) > Predef$.MODULE$.Long2long(windowEnd)) {
                if (windowEnd == null) {
                    this.function().setForwardedFields(record, this.output());
                } else {
                    this.doEvaluateAndCollect(out, Predef$.MODULE$.Long2long(windowStart), Predef$.MODULE$.Long2long(windowEnd));
                    this.function().resetAccumulator(this.accumulators());
                }
                windowStart = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.intermediateRowWindowStartPos())));
            }
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
            windowEnd = this.isInputCombined ? Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.intermediateRowWindowEndPos()))) : Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(currentRowTime) + this.gap);
        }
        this.doEvaluateAndCollect(out, Predef$.MODULE$.Long2long(windowStart), Predef$.MODULE$.Long2long(windowEnd));
    }

    public void doEvaluateAndCollect(Collector<Row> out, long windowStart, long windowEnd) {
        this.function().setAggregationResults(this.accumulators(), this.output());
        if (this.finalRowWindowStartPos.isDefined() || this.finalRowWindowEndPos.isDefined()) {
            this.collector().wrappedCollector_$eq(out);
            this.collector().windowStart_$eq(windowStart);
            this.collector().windowEnd_$eq(windowEnd);
            this.collector().collect(this.output());
        } else {
            out.collect((Object)this.output());
        }
    }

    public DataSetSessionWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, int keysAndAggregatesArity, Option<Object> finalRowWindowStartPos, Option<Object> finalRowWindowEndPos, long gap, boolean isInputCombined) {
        this.genAggregations = genAggregations;
        this.finalRowWindowStartPos = finalRowWindowStartPos;
        this.finalRowWindowEndPos = finalRowWindowEndPos;
        this.gap = gap;
        this.isInputCombined = isInputCombined;
        Compiler$class.$init$(this);
        this.intermediateRowWindowStartPos = keysAndAggregatesArity;
        this.intermediateRowWindowEndPos = keysAndAggregatesArity + 1;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

