/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.AmbiguousTableSourceConverterException;
import org.apache.flink.table.api.NoMatchedTableSourceConverterException;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.catalog.ExternalTableSourceUtil$;
import org.apache.flink.table.catalog.TableSourceConverter;
import org.apache.flink.table.plan.schema.StreamTableSourceTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.plan.stats.FlinkStatistic$;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.MultiMap;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;

public final class ExternalTableSourceUtil$ {
    public static final ExternalTableSourceUtil$ MODULE$;
    private final String tableSourceConverterConfigFileName;
    private final Logger org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG;
    private final HashMap<String, scala.collection.mutable.Set<Class<? extends TableSourceConverter<?>>>> tableTypeToTableSourceConvertersClazz;

    static {
        new ExternalTableSourceUtil$();
    }

    private String tableSourceConverterConfigFileName() {
        return this.tableSourceConverterConfigFileName;
    }

    public Logger org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG() {
        return this.org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG;
    }

    private HashMap<String, scala.collection.mutable.Set<Class<? extends TableSourceConverter<?>>>> tableTypeToTableSourceConvertersClazz() {
        return this.tableTypeToTableSourceConvertersClazz;
    }

    @VisibleForTesting
    public HashMap<String, scala.collection.mutable.Set<Class<? extends TableSourceConverter<?>>>> injectTableSourceConverter(String tableType, Class<? extends TableSourceConverter<?>> converterClazz) {
        return (HashMap)((MultiMap)this.tableTypeToTableSourceConvertersClazz()).addBinding((Object)tableType, converterClazz);
    }

    /*
     * WARNING - void declaration
     */
    public TableSourceTable<?> fromExternalCatalogTable(ExternalCatalogTable externalCatalogTable) {
        String tableType = externalCatalogTable.tableType();
        Set<String> propertyKeys = externalCatalogTable.properties().keySet();
        Option option = this.tableTypeToTableSourceConvertersClazz().get((Object)tableType);
        if (option instanceof Some) {
            TableSourceTable tableSourceTable;
            Some some = (Some)option;
            scala.collection.mutable.Set converterClasses = (scala.collection.mutable.Set)some.x();
            scala.collection.mutable.Set matchedConverters = (scala.collection.mutable.Set)converterClasses.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TableSourceConverter<?> apply(Class<? extends TableSourceConverter<?>> x$1) {
                    return (TableSourceConverter)InstantiationUtil.instantiate(x$1);
                }
            }, Set$.MODULE$.canBuildFrom());
            if (matchedConverters.isEmpty()) {
                this.org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find any TableSourceConverter binded to table type [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Register TableSourceConverter via externalCatalogTable.properties file."})).s((Seq)Nil$.MODULE$)).toString());
                throw new NoMatchedTableSourceConverterException(tableType);
            }
            scala.collection.mutable.Set filteredMatchedConverters = (scala.collection.mutable.Set)matchedConverters.filter((Function1)new Serializable(propertyKeys){
                public static final long serialVersionUID = 0L;
                private final Set propertyKeys$1;

                public final boolean apply(TableSourceConverter<?> converter) {
                    return this.propertyKeys$1.containsAll(converter.requiredProperties());
                }
                {
                    this.propertyKeys$1 = propertyKeys$1;
                }
            });
            if (filteredMatchedConverters.isEmpty()) {
                this.org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find any matched TableSourceConverter for type [", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"because the required properties does not match."})).s((Seq)Nil$.MODULE$)).toString());
                throw new NoMatchedTableSourceConverterException(tableType);
            }
            if (filteredMatchedConverters.size() > 1) {
                this.org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finds more than one matched TableSourceConverter for type [", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"they are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filteredMatchedConverters.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(TableSourceConverter<?> x$2) {
                        return x$2.getClass().getName();
                    }
                }, Set$.MODULE$.canBuildFrom())}))).toString());
                throw new AmbiguousTableSourceConverterException(tableType);
            }
            Object convertedTableSource = ((TableSourceConverter)filteredMatchedConverters.head()).fromExternalCatalogTable(externalCatalogTable);
            FlinkStatistic flinkStatistic = externalCatalogTable.stats() == null ? FlinkStatistic$.MODULE$.UNKNOWN() : FlinkStatistic$.MODULE$.of(externalCatalogTable.stats());
            Object t = convertedTableSource;
            if (t instanceof StreamTableSource) {
                StreamTableSource streamTableSource = (StreamTableSource)t;
                tableSourceTable = new StreamTableSourceTable(streamTableSource, flinkStatistic);
            } else {
                tableSourceTable = new TableSourceTable(convertedTableSource, flinkStatistic);
            }
            TableSourceTable tableSourceTable2 = tableSourceTable;
            return tableSourceTable2;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            void var2_2;
            this.org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find any TableSourceConverter binded to table type [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Register TableSourceConverter via externalCatalogTable.properties file."})).s((Seq)Nil$.MODULE$)).toString());
            throw new NoMatchedTableSourceConverterException((String)var2_2);
        }
        throw new MatchError((Object)option);
    }

    private scala.collection.immutable.Set<String> parseScanPackagesFromConfigFile(URL url) {
        scala.collection.immutable.Set set;
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(url);
            config.setListDelimiter(',');
            set = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])config.getStringArray("scan.packages")).filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$3) {
                    return x$3.isEmpty();
                }
            })).toSet();
        }
        catch (ConversionException conversionException) {
            this.org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error happened while parsing 'scan.packages' field of properties file [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The value is not a String or List of Strings."})).s((Seq)Nil$.MODULE$)).toString(), (Throwable)conversionException);
            set = Predef$.MODULE$.Set().empty();
        }
        catch (ConfigurationException configurationException) {
            this.org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error happened while loading the properties file [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})), (Throwable)configurationException);
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private ExternalTableSourceUtil$() {
        void var1_1;
        MODULE$ = this;
        this.tableSourceConverterConfigFileName = "tableSourceConverter.properties";
        this.org$apache$flink$table$catalog$ExternalTableSourceUtil$$LOG = LoggerFactory.getLogger(this.getClass());
        anon.1 registeredConverters = new anon.1();
        Enumeration<URL> resourceUrls = this.getClass().getClassLoader().getResources(this.tableSourceConverterConfigFileName());
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            scala.collection.immutable.Set<String> scanPackages = this.parseScanPackagesFromConfigFile(url);
            scanPackages.foreach((Function1)new anonfun.1(registeredConverters));
        }
        this.tableTypeToTableSourceConvertersClazz = var1_1;
    }
}

