/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.calcite.util.NameSet;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableSortedMap;

public class NameMap<V> {
    private final NavigableMap<String, V> map;

    private NameMap(NavigableMap<String, V> map2) {
        this.map = map2;
        assert (this.map.comparator() == NameSet.COMPARATOR);
    }

    public NameMap() {
        this(new TreeMap(NameSet.COMPARATOR));
    }

    public static <V> NameMap immutableCopyOf(Map<String, V> names) {
        return new NameMap<V>(ImmutableSortedMap.copyOf(names, NameSet.COMPARATOR));
    }

    public void put(String name, V v) {
        this.map.put(name, v);
    }

    public NavigableMap<String, V> range(String name, boolean caseSensitive) {
        if (caseSensitive) {
            if (this.map.containsKey(name)) {
                return ImmutableSortedMap.of(name, this.map.get(name));
            }
            return ImmutableSortedMap.of();
        }
        return this.map.subMap(name.toUpperCase(Locale.ROOT), true, name.toLowerCase(Locale.ROOT), true);
    }

    public boolean containsKey(String name, boolean caseSensitive) {
        return !this.range(name, caseSensitive).isEmpty();
    }

    public NavigableMap<String, V> map() {
        return this.map;
    }
}

