/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlMatchRecognize
extends SqlCall {
    public static final int OPERAND_TABLE_REF = 0;
    public static final int OPERAND_PATTERN = 1;
    public static final int OPERAND_STRICT_START = 2;
    public static final int OPERAND_STRICT_END = 3;
    public static final int OPERAND_PATTERN_DEFINES = 4;
    private SqlNode tableRef;
    private SqlNode pattern;
    private SqlLiteral strictStart;
    private SqlLiteral strictEnd;
    private SqlNodeList patternDefList;

    public SqlMatchRecognize(SqlParserPos pos, SqlNode tableRef, SqlNode pattern, SqlLiteral strictStart, SqlLiteral strictEnd, SqlNodeList patternDefList) {
        super(pos);
        this.tableRef = tableRef;
        this.pattern = pattern;
        this.strictStart = strictStart;
        this.strictEnd = strictEnd;
        this.patternDefList = patternDefList;
        assert (tableRef != null);
        assert (pattern != null);
        assert (patternDefList != null && patternDefList.size() > 0);
    }

    @Override
    public SqlOperator getOperator() {
        return SqlMatchRecognizeOperator.INSTANCE;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.MATCH_RECOGNIZE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableRef, this.pattern, this.strictStart, this.strictEnd, this.patternDefList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.getOperator().unparse(writer, this, 0, 0);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateMatchRecognize(this);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.tableRef = operand;
                break;
            }
            case 1: {
                this.pattern = operand;
                break;
            }
            case 2: {
                this.strictStart = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.strictEnd = (SqlLiteral)operand;
                break;
            }
            case 4: {
                this.patternDefList = (SqlNodeList)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getTableRef() {
        return this.tableRef;
    }

    public SqlNode getPattern() {
        return this.pattern;
    }

    public SqlLiteral getStrictStart() {
        return this.strictStart;
    }

    public SqlLiteral getStrictEnd() {
        return this.strictEnd;
    }

    public SqlNodeList getPatternDefList() {
        return this.patternDefList;
    }

    public static class SqlMatchRecognizeOperator
    extends SqlOperator {
        public static final SqlMatchRecognizeOperator INSTANCE = new SqlMatchRecognizeOperator();

        private SqlMatchRecognizeOperator() {
            super("MATCH_RECOGNIZE", SqlKind.MATCH_RECOGNIZE, 2, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            assert (operands.length == 5);
            return new SqlMatchRecognize(pos, operands[0], operands[1], (SqlLiteral)operands[2], (SqlLiteral)operands[3], (SqlNodeList)operands[4]);
        }

        @Override
        public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
            if (onlyExpressions) {
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    SqlNode operand = operands.get(i);
                    if (operand == null) continue;
                    argHandler.visitChild(visitor, call, i, operand);
                }
            } else {
                super.acceptCall(visitor, call, onlyExpressions, argHandler);
            }
        }

        @Override
        public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
            validator.validateMatchRecognize(call);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlMatchRecognize pattern = (SqlMatchRecognize)call;
            pattern.tableRef.unparse(writer, 0, 0);
            SqlWriter.Frame mrFrame = writer.startFunCall("MATCH_RECOGNIZE");
            writer.newlineAndIndent();
            writer.sep("PATTERN");
            SqlWriter.Frame patternFrame = writer.startList("(", ")");
            if (pattern.strictStart.booleanValue()) {
                writer.sep("^");
            }
            pattern.pattern.unparse(writer, 0, 0);
            if (pattern.strictEnd.booleanValue()) {
                writer.sep("$");
            }
            writer.endList(patternFrame);
            writer.newlineAndIndent();
            writer.sep("DEFINE");
            SqlWriter.Frame patternDefFrame = writer.startList("", "");
            SqlNodeList newDefineList = new SqlNodeList(SqlParserPos.ZERO);
            for (SqlNode node : pattern.getPatternDefList()) {
                SqlCall call2 = (SqlCall)node;
                newDefineList.add(call2.getOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{call2.operand(1), call2.operand(0)}));
            }
            newDefineList.unparse(writer, 0, 0);
            writer.endList(patternDefFrame);
            writer.endList(mrFrame);
        }
    }
}

