/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableMap;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableMultimap;
import org.apache.flink.shaded.calcite.com.google.common.collect.Multimap;

public class ReflectiveSchema
extends AbstractSchema {
    private final Class clazz;
    private Object target;

    public ReflectiveSchema(Object target) {
        this.clazz = target.getClass();
        this.target = target;
    }

    public String toString() {
        return "ReflectiveSchema(target=" + this.target + ")";
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder<String, Table> builder = ImmutableMap.builder();
        for (Field field : this.clazz.getFields()) {
            String fieldName = field.getName();
            Table table = this.fieldRelation(field);
            if (table == null) continue;
            builder.put(fieldName, table);
        }
        return builder.build();
    }

    @Override
    protected Multimap<String, Function> getFunctionMultimap() {
        ImmutableMultimap.Builder<String, MethodTableMacro> builder = ImmutableMultimap.builder();
        for (Method method : this.clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class || methodName.equals("toString") || !TranslatableTable.class.isAssignableFrom(method.getReturnType())) continue;
            MethodTableMacro tableMacro = new MethodTableMacro(this, method);
            builder.put(methodName, tableMacro);
        }
        return builder.build();
    }

    Expression getTargetExpression(SchemaPlus parentSchema, String name) {
        return Types.castIfNecessary(this.target.getClass(), Expressions.call(Schemas.unwrap(this.getExpression(parentSchema, name), ReflectiveSchema.class), BuiltInMethod.REFLECTIVE_SCHEMA_GET_TARGET.method, new Expression[0]));
    }

    private <T> Table fieldRelation(Field field) {
        Object o;
        Type elementType = ReflectiveSchema.getElementType(field.getType());
        if (elementType == null) {
            return null;
        }
        try {
            o = field.get(this.target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while accessing field " + field, e);
        }
        Enumerable enumerable = ReflectiveSchema.toEnumerable(o);
        return new FieldTable(field, elementType, enumerable);
    }

    private static Type getElementType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return Object.class;
        }
        return null;
    }

    private static Enumerable toEnumerable(Object o) {
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                return Linq4j.asEnumerable((Object[])o);
            }
            return Linq4j.asEnumerable(Primitive.asList(o));
        }
        if (o instanceof Iterable) {
            return Linq4j.asEnumerable((Iterable)o);
        }
        throw new RuntimeException("Cannot convert " + o.getClass() + " into a Enumerable");
    }

    private static class FieldSelector
    implements Function1<Object, Object[]> {
        private final Field[] fields;

        FieldSelector(Class elementType) {
            this.fields = elementType.getFields();
        }

        @Override
        public Object[] apply(Object o) {
            try {
                Object[] objects = new Object[this.fields.length];
                for (int i = 0; i < this.fields.length; ++i) {
                    objects[i] = this.fields[i].get(o);
                }
                return objects;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FieldTable<T>
    extends ReflectiveTable {
        private final Field field;

        FieldTable(Field field, Type elementType, Enumerable<T> enumerable) {
            super(elementType, enumerable);
            this.field = field;
        }

        public String toString() {
            return "Relation {field=" + this.field.getName() + "}";
        }

        @Override
        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            return Expressions.field(schema.unwrap(ReflectiveSchema.class).getTargetExpression(schema.getParentSchema(), schema.getName()), this.field);
        }
    }

    private static class MethodTableMacro
    extends ReflectiveFunctionBase
    implements TableMacro {
        private final ReflectiveSchema schema;

        MethodTableMacro(ReflectiveSchema schema, Method method) {
            super(method);
            this.schema = schema;
            assert (TranslatableTable.class.isAssignableFrom(method.getReturnType())) : "Method should return TranslatableTable so the macro can be expanded";
        }

        public String toString() {
            return "Member {method=" + this.method + "}";
        }

        @Override
        public TranslatableTable apply(List<Object> arguments) {
            try {
                Object o = this.method.invoke(this.schema.getTarget(), arguments.toArray());
                return (TranslatableTable)o;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory
    implements SchemaFactory {
        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            Object target;
            Class<?> clazz;
            Object className = operand.get("class");
            if (className != null) {
                try {
                    clazz = Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class " + className, e);
                }
            } else {
                throw new RuntimeException("Operand 'class' is required");
            }
            Object methodName = operand.get("staticMethod");
            if (methodName != null) {
                try {
                    Method method = clazz.getMethod((String)methodName, new Class[0]);
                    target = method.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invoking method " + methodName, e);
                }
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                target = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating class " + className, e);
            }
            return new ReflectiveSchema(target);
        }
    }

    private static class ReflectiveTable
    extends AbstractQueryableTable
    implements Table,
    ScannableTable {
        private final Type elementType;
        private final Enumerable enumerable;

        ReflectiveTable(Type elementType, Enumerable enumerable) {
            super(elementType);
            this.elementType = elementType;
            this.enumerable = enumerable;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ((JavaTypeFactory)typeFactory).createType(this.elementType);
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public Enumerable<Object[]> scan(DataContext root) {
            if (this.elementType == Object[].class) {
                return this.enumerable;
            }
            return this.enumerable.select(new FieldSelector((Class)this.elementType));
        }

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

                @Override
                public Enumerator<T> enumerator() {
                    return ReflectiveTable.this.enumerable.enumerator();
                }
            };
        }
    }
}

