/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.flink.shaded.calcite.com.google.common.base.Supplier;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class EnumerableTableScan
extends TableScan
implements EnumerableRel {
    private final Class elementType;

    public EnumerableTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Class elementType) {
        super(cluster, traitSet, table);
        assert (this.getConvention() instanceof EnumerableConvention);
        this.elementType = elementType;
    }

    public static EnumerableTableScan create(RelOptCluster cluster, RelOptTable relOptTable) {
        final Table table = relOptTable.unwrap(Table.class);
        Class elementType = EnumerableTableScan.deduceElementType(table);
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                if (table != null) {
                    return table.getStatistic().getCollations();
                }
                return ImmutableList.of();
            }
        });
        return new EnumerableTableScan(cluster, traitSet, relOptTable, elementType);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EnumerableTableScan && this.table.equals(((EnumerableTableScan)obj).table);
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public static boolean canHandle(Table table) {
        return table instanceof QueryableTable || table instanceof ScannableTable;
    }

    public static Class deduceElementType(Table table) {
        if (table instanceof QueryableTable) {
            QueryableTable queryableTable = (QueryableTable)table;
            Type type = queryableTable.getElementType();
            if (type instanceof Class) {
                return (Class)type;
            }
            return Object[].class;
        }
        if (table instanceof ScannableTable || table instanceof FilterableTable || table instanceof ProjectableFilterableTable || table instanceof StreamableTable) {
            return Object[].class;
        }
        return Object.class;
    }

    public static JavaRowFormat deduceFormat(RelOptTable table) {
        Class elementType = EnumerableTableScan.deduceElementType(table.unwrap(Table.class));
        return elementType == Object[].class ? JavaRowFormat.ARRAY : JavaRowFormat.CUSTOM;
    }

    private Expression getExpression(PhysType physType) {
        Expression expression2 = this.table.getExpression(Queryable.class);
        Expression expression22 = this.toEnumerable(expression2);
        assert (Types.isAssignableFrom(Enumerable.class, expression22.getType()));
        return this.toRows(physType, expression22);
    }

    private Expression toEnumerable(Expression expression2) {
        Type type = expression2.getType();
        if (Types.isArray(type)) {
            if (Types.toClass(type).getComponentType().isPrimitive()) {
                expression2 = Expressions.call(BuiltInMethod.AS_LIST.method, expression2);
            }
            return Expressions.call(BuiltInMethod.AS_ENUMERABLE.method, expression2);
        }
        if (Types.isAssignableFrom(Iterable.class, type) && !Types.isAssignableFrom(Enumerable.class, type)) {
            return Expressions.call(BuiltInMethod.AS_ENUMERABLE2.method, expression2);
        }
        if (Types.isAssignableFrom(Queryable.class, type)) {
            return Expressions.call(expression2, BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, new Expression[0]);
        }
        return expression2;
    }

    private Expression toRows(PhysType physType, Expression expression2) {
        if (physType.getFormat() == JavaRowFormat.SCALAR && Object[].class.isAssignableFrom(this.elementType) && this.getRowType().getFieldCount() == 1 && (this.table.unwrap(ScannableTable.class) != null || this.table.unwrap(FilterableTable.class) != null || this.table.unwrap(ProjectableFilterableTable.class) != null)) {
            return Expressions.call(BuiltInMethod.SLICE0.method, expression2);
        }
        JavaRowFormat oldFormat = this.format();
        if (physType.getFormat() == oldFormat && !this.hasCollectionField(this.rowType)) {
            return expression2;
        }
        ParameterExpression row_ = Expressions.parameter(this.elementType, "row");
        int fieldCount = this.table.getRowType().getFieldCount();
        ArrayList<Expression> expressionList2 = new ArrayList<Expression>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            expressionList2.add(this.fieldExpression(row_, i, physType, oldFormat));
        }
        return Expressions.call(expression2, BuiltInMethod.SELECT.method, Expressions.lambda(Function1.class, physType.record(expressionList2), row_));
    }

    private Expression fieldExpression(ParameterExpression row_, int i, PhysType physType, JavaRowFormat format) {
        Expression e = format.field(row_, i, null, physType.getJavaFieldType(i));
        RelDataType relFieldType = physType.getRowType().getFieldList().get(i).getType();
        switch (relFieldType.getSqlTypeName()) {
            case ARRAY: 
            case MULTISET: {
                JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
                PhysType elementPhysType = PhysTypeImpl.of(typeFactory, relFieldType.getComponentType(), JavaRowFormat.CUSTOM);
                MethodCallExpression e2 = Expressions.call(BuiltInMethod.AS_ENUMERABLE2.method, e);
                RelDataType dummyType = this.rowType;
                Expression e3 = elementPhysType.convertTo(e2, PhysTypeImpl.of(typeFactory, dummyType, JavaRowFormat.LIST));
                return Expressions.call(e3, BuiltInMethod.ENUMERABLE_TO_LIST.method, new Expression[0]);
            }
        }
        return e;
    }

    private JavaRowFormat format() {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldCount == 0) {
            return JavaRowFormat.LIST;
        }
        if (Object[].class.isAssignableFrom(this.elementType)) {
            return fieldCount == 1 ? JavaRowFormat.SCALAR : JavaRowFormat.ARRAY;
        }
        if (Row.class.isAssignableFrom(this.elementType)) {
            return JavaRowFormat.ROW;
        }
        if (fieldCount == 1 && (Object.class == this.elementType || Primitive.is(this.elementType) || Number.class.isAssignableFrom(this.elementType))) {
            return JavaRowFormat.SCALAR;
        }
        return JavaRowFormat.CUSTOM;
    }

    private boolean hasCollectionField(RelDataType rowType) {
        for (RelDataTypeField field : rowType.getFieldList()) {
            switch (field.getType().getSqlTypeName()) {
                case ARRAY: 
                case MULTISET: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableTableScan(this.getCluster(), traitSet, this.table, this.elementType);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), this.format());
        Expression expression2 = this.getExpression(physType);
        return implementor.result(physType, Blocks.toBlock(expression2));
    }
}

