/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class LinkedListSerializer<T>
extends TypeSerializer<LinkedList<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> elementSerializer;

    public LinkedListSerializer(TypeSerializer<T> elementSerializer) {
        this.elementSerializer = (TypeSerializer)Preconditions.checkNotNull(elementSerializer);
    }

    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<LinkedList<T>> duplicate() {
        TypeSerializer duplicateElement = this.elementSerializer.duplicate();
        return duplicateElement == this.elementSerializer ? this : new LinkedListSerializer<T>(duplicateElement);
    }

    public LinkedList<T> createInstance() {
        return new LinkedList();
    }

    public LinkedList<T> copy(LinkedList<T> from) {
        LinkedList<Object> newList = new LinkedList<Object>();
        for (Object element : from) {
            newList.add(this.elementSerializer.copy(element));
        }
        return newList;
    }

    public LinkedList<T> copy(LinkedList<T> from, LinkedList<T> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(LinkedList<T> list, DataOutputView target) throws IOException {
        target.writeInt(list.size());
        for (Object element : list) {
            this.elementSerializer.serialize(element, target);
        }
    }

    public LinkedList<T> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i < size; ++i) {
            list.add(this.elementSerializer.deserialize(source));
        }
        return list;
    }

    public LinkedList<T> deserialize(LinkedList<T> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int num = source.readInt();
        target.writeInt(num);
        for (int i = 0; i < num; ++i) {
            this.elementSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.elementSerializer.equals(((LinkedListSerializer)((Object)obj)).elementSerializer);
    }

    public int hashCode() {
        return this.elementSerializer.hashCode();
    }

    public TypeSerializerSnapshot<LinkedList<T>> snapshotConfiguration() {
        return new LinkedListSerializerSnapshot(this);
    }

    public static class LinkedListSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<LinkedList<T>, LinkedListSerializer<T>> {
        private static final int CURRENT_VERSION = 1;

        public LinkedListSerializerSnapshot() {
            super(LinkedListSerializer.class);
        }

        public LinkedListSerializerSnapshot(LinkedListSerializer<T> listSerializer) {
            super(listSerializer);
        }

        public int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected LinkedListSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> elementSerializer = nestedSerializers[0];
            return new LinkedListSerializer(elementSerializer);
        }

        protected TypeSerializer<?>[] getNestedSerializers(LinkedListSerializer<T> outerSerializer) {
            return new TypeSerializer[]{outerSerializer.getElementSerializer()};
        }
    }
}

