/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.connectors.DynamicSinkUtils;
import org.apache.flink.table.planner.delegation.ExecutorBase;
import org.apache.flink.table.planner.delegation.ParserFactory;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalLegacySink$;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraphGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.reuse.SubplanReuser$;
import org.apache.flink.table.planner.plan.utils.SameRelObjectShuttle;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.table.planner.sinks.TableSinkUtils$;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u001db!B\u0001\u0003\u0003\u0003y!a\u0003)mC:tWM\u001d\"bg\u0016T!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eYR\"\u0001\u000e\u000b\u0005\r1\u0011B\u0001\u000f\u001b\u0005\u001d\u0001F.\u00198oKJD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\tKb,7-\u001e;peB\u0011\u0011\u0004I\u0005\u0003Ci\u0011\u0001\"\u0012=fGV$xN\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u000511m\u001c8gS\u001e\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002*M\tYA+\u00192mK\u000e{gNZ5h\u0011!Y\u0003A!b\u0001\n\u0003a\u0013a\u00044v]\u000e$\u0018n\u001c8DCR\fGn\\4\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R!\u0001\r\u0004\u0002\u000f\r\fG/\u00197pO&\u0011!g\f\u0002\u0010\rVt7\r^5p]\u000e\u000bG/\u00197pO\"AA\u0007\u0001B\u0001B\u0003%Q&\u0001\tgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8hA!Aa\u0007\u0001BC\u0002\u0013\u0005q'\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0016\u0003a\u0002\"AL\u001d\n\u0005iz#AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0005\ty\u0001\u0011\t\u0011)A\u0005q\u0005y1-\u0019;bY><W*\u00198bO\u0016\u0014\b\u0005\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0003=I7o\u0015;sK\u0006l\u0017N\\4N_\u0012,\u0007C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%a\u0002\"p_2,\u0017M\u001c\u0005\u0006\r\u0002!\taR\u0001\u0007y%t\u0017\u000e\u001e \u0015\r!S5\nT'O!\tI\u0005!D\u0001\u0003\u0011\u0015qR\t1\u0001 \u0011\u0015\u0019S\t1\u0001%\u0011\u0015YS\t1\u0001.\u0011\u00151T\t1\u00019\u0011\u0015qT\t1\u0001@\u0011%\u0001\u0006\u00011AA\u0002\u0013%\u0011+\u0001\u0004qCJ\u001cXM]\u000b\u0002%B\u0011\u0011dU\u0005\u0003)j\u0011a\u0001U1sg\u0016\u0014\b\"\u0003,\u0001\u0001\u0004\u0005\r\u0011\"\u0003X\u0003)\u0001\u0018M]:fe~#S-\u001d\u000b\u00031n\u0003\"\u0001Q-\n\u0005i\u000b%\u0001B+oSRDq\u0001X+\u0002\u0002\u0003\u0007!+A\u0002yIEBaA\u0018\u0001!B\u0013\u0011\u0016a\u00029beN,'\u000f\t\u0005\bA\u0002\u0001\r\u0011\"\u0003b\u00039\u0019WO\u001d:f]R$\u0015.\u00197fGR,\u0012A\u0019\t\u0003K\rL!\u0001\u001a\u0014\u0003\u0015M\u000bH\u000eR5bY\u0016\u001cG\u000fC\u0004g\u0001\u0001\u0007I\u0011B4\u0002%\r,(O]3oi\u0012K\u0017\r\\3di~#S-\u001d\u000b\u00031\"Dq\u0001X3\u0002\u0002\u0003\u0007!\r\u0003\u0004k\u0001\u0001\u0006KAY\u0001\u0010GV\u0014(/\u001a8u\t&\fG.Z2uA!AA\u000e\u0001b\u0001\n\u0003AQ.\u0001\bqY\u0006tg.\u001a:D_:$X\r\u001f;\u0016\u00039\u0004\"!S8\n\u0005A\u0014!A\u0004)mC:tWM]\"p]R,\u0007\u0010\u001e\u0005\u0007e\u0002\u0001\u000b\u0011\u00028\u0002\u001fAd\u0017M\u001c8fe\u000e{g\u000e^3yi\u0002B#!\u001d;\u0011\u0005UDX\"\u0001<\u000b\u0005]D\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011P\u001e\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0007bB>\u0001\u0005\u0004%I\u0001`\u0001\u001dgFdW\t\u001f9s)>\u0014V\r_\"p]Z,'\u000f^3s\r\u0006\u001cGo\u001c:z+\u0005i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u0011\tqaY1mG&$X-C\u0002\u0002\u0006}\u0014AdU9m\u000bb\u0004(\u000fV8SKb\u001cuN\u001c<feR,'OR1di>\u0014\u0018\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011B?\u0002;M\fH.\u0012=qeR{'+\u001a=D_:4XM\u001d;fe\u001a\u000b7\r^8ss\u0002B\u0001\"!\u0004\u0001\t\u0003A\u0011qB\u0001\u000eO\u0016$(+\u001a7Ck&dG-\u001a:\u0016\u0005\u0005E\u0001c\u0001@\u0002\u0014%\u0019\u0011QC@\u0003\u001f\u0019c\u0017N\\6SK2\u0014U/\u001b7eKJD\u0001\"!\u0007\u0001\t\u0003A\u00111D\u0001\u0013GJ,\u0017\r^3GY&t7\u000e\u00157b]:,'/\u0006\u0002\u0002\u001eA\u0019a0a\b\n\u0007\u0005\u0005rP\u0001\tGY&t7\u000e\u00157b]:,'/S7qY\"\u001a\u0011q\u0003;\t\u0011\u0005\u001d\u0002\u0001\"\u0001\t\u0003S\tabZ3u)f\u0004XMR1di>\u0014\u00180\u0006\u0002\u0002,A\u0019a0!\f\n\u0007\u0005=rP\u0001\tGY&t7\u000eV=qK\u001a\u000b7\r^8ss\"9\u00111\u0007\u0001\u0007\u0012\u0005U\u0012\u0001D4fiR\u0013\u0018-\u001b;EK\u001a\u001cXCAA\u001c!\u0015\u0001\u0015\u0011HA\u001f\u0013\r\tY$\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0005\u0003\u007f\t\t\u0006\u0005\u0004\u0002B\u0005%\u0013QJ\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005!\u0001\u000f\\1o\u0015\r\t\tAC\u0005\u0005\u0003\u0017\n\u0019EA\u0006SK2$&/Y5u\t\u00164\u0007\u0003BA(\u0003#b\u0001\u0001\u0002\u0007\u0002T\u0005E\u0012\u0011!A\u0001\u0006\u0003\t)FA\u0002`IE\nB!a\u0016\u0002^A\u0019\u0001)!\u0017\n\u0007\u0005m\u0013IA\u0004O_RD\u0017N\\4\u0011\t\u0005\u0005\u0013qL\u0005\u0005\u0003C\n\u0019E\u0001\u0005SK2$&/Y5u\u0011\u001d\t)\u0007\u0001D\t\u0003O\nAbZ3u\u001fB$\u0018.\\5{KJ,\"!!\u001b\u0011\t\u0005-\u00141O\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005Aq\u000e\u001d;j[&TXMC\u0002\u0002F\u0011IA!!\u001e\u0002n\tIq\n\u001d;j[&TXM\u001d\u0005\b\u0003s\u0002A\u0011AA>\u000399W\r\u001e+bE2,7i\u001c8gS\u001e,\u0012\u0001\n\u0005\b\u0003\u007f\u0002A\u0011AAA\u0003=9W\r\u001e$mS:\\7i\u001c8uKb$XCAAB!\rq\u0018QQ\u0005\u0004\u0003\u000f{(\u0001\u0004$mS:\\7i\u001c8uKb$\b\u0002CAF\u0001\u0011\u0005\u0001\"!$\u0002\u0015\u001d,G/\u0012=fG\u0016sg/\u0006\u0002\u0002\u0010B!\u0011\u0011SAO\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015aC3om&\u0014xN\\7f]RT1aJAM\u0015\r\tY\nC\u0001\ngR\u0014X-Y7j]\u001eLA!a(\u0002\u0014\nQ2\u000b\u001e:fC6,\u00050Z2vi&|g.\u00128wSJ|g.\\3oi\"1\u00111\u0015\u0001\u0005\u0002E\u000bqb\u0019:fCR,g*Z<QCJ\u001cXM\u001d\u0005\b\u0003O\u0003A\u0011IAU\u0003%9W\r\u001e)beN,'\u000fF\u0001S\u0011\u001d\ti\u000b\u0001C!\u0003_\u000b\u0011\u0002\u001e:b]Nd\u0017\r^3\u0015\t\u0005E\u00161\u001c\t\u0007\u0003g\u000bI,!0\u000e\u0005\u0005U&bAA\\)\u0005!Q\u000f^5m\u0013\u0011\tY,!.\u0003\t1K7\u000f\u001e\u0019\u0005\u0003\u007f\u000by\r\u0005\u0004\u0002B\u0006%\u0017QZ\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006\u0019A-Y4\u000b\u0005\u001dB\u0011\u0002BAf\u0003\u0007\u0014a\u0002\u0016:b]N4wN]7bi&|g\u000e\u0005\u0003\u0002P\u0005=G\u0001DAi\u0003W\u000b\t\u0011!A\u0003\u0002\u0005M'aA0%eE!\u0011qKAk!\r\u0001\u0015q[\u0005\u0004\u00033\f%aA!os\"A\u0011Q\\AV\u0001\u0004\ty.\u0001\tn_\u0012Lg-_(qKJ\fG/[8ogB1\u00111WA]\u0003C\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003O4\u0011AC8qKJ\fG/[8og&!\u00111^As\u0005=iu\u000eZ5gs>\u0003XM]1uS>t\u0007\u0002CAx\u0001\u0011\u0005\u0001\"!=\u0002\u001dQ\u0014\u0018M\\:mCR,Gk\u001c*fYR!\u00111_A\u0000!\u0011\t)0a?\u000e\u0005\u0005](\u0002BA}\u0003\u000f\n1A]3m\u0013\u0011\ti0a>\u0003\u000fI+GNT8eK\"A!\u0011AAw\u0001\u0004\t\t/A\bn_\u0012Lg-_(qKJ\fG/[8oQ\r\ti\u000f\u001e\u0005\t\u0003_\u0002A\u0011\u0001\u0005\u0003\bQ!!\u0011\u0002B\u0011!\u0019\u0011YAa\u0007\u0002t:!!Q\u0002B\f\u001d\u0011\u0011yA!\u0006\u000e\u0005\tE!b\u0001B\n\u001d\u00051AH]8pizJ\u0011AQ\u0005\u0004\u00053\t\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005;\u0011yBA\u0002TKFT1A!\u0007B\u0011!\u0011\u0019C!\u0002A\u0002\t%\u0011\u0001\u0003:fY:{G-Z:)\u0007\t\u0015A\u000f\u0003\u0005\u0002p\u0001!\t\u0001\u0003B\u0015)\u0011\t\u0019Pa\u000b\t\u0011\t5\"q\u0005a\u0001\u0003g\fqA]3m\u001d>$W\rK\u0002\u0003(QD\u0001Ba\r\u0001\t\u0003A!QG\u0001\u0019iJ\fgn\u001d7bi\u0016$v.\u0012=fG:{G-Z$sCBDG\u0003\u0002B\u001c\u0005\u000f\u0002BA!\u000f\u0003D5\u0011!1\b\u0006\u0005\u0005{\u0011y$\u0001\u0003fq\u0016\u001c'\u0002\u0002B!\u0003c\nQA\\8eKNLAA!\u0012\u0003<\tiQ\t_3d\u001d>$Wm\u0012:ba\"D\u0001B!\u0013\u00032\u0001\u0007!\u0011B\u0001\u0012_B$\u0018.\\5{K\u0012\u0014V\r\u001c(pI\u0016\u001c\bf\u0001B\u0019i\"9!q\n\u0001\u0007\u0012\tE\u0013AG4fi\u0016CXm\u0019(pI\u0016<%/\u00199i!J|7-Z:t_J\u001cXC\u0001B*!\u0019\u0011YAa\u0007\u0003VA!!q\u000bB/\u001b\t\u0011IF\u0003\u0003\u0003\\\tm\u0012!\u00039s_\u000e,7o]8s\u0013\u0011\u0011yF!\u0017\u0003-\u0015CXm\u0019(pI\u0016<%/\u00199i!J|7-Z:t_JDqAa\u0019\u0001\r#\u0011)'A\bue\u0006t7\u000f\\1uKR{\u0007\u000b\\1o)\u0011\u00119Ga\u001d\u0011\r\u0005M\u0016\u0011\u0018B5a\u0011\u0011YGa\u001c\u0011\r\u0005\u0005\u0017\u0011\u001aB7!\u0011\tyEa\u001c\u0005\u0019\tE$\u0011MA\u0001\u0002\u0003\u0015\t!a5\u0003\u0007}#C\u0007\u0003\u0005\u0003v\t\u0005\u0004\u0019\u0001B\u001c\u0003%)\u00070Z2He\u0006\u0004\b\u000eC\u0004\u0003z\u0001!IAa\u001f\u0002\u0019\u001d,G\u000fV1cY\u0016\u001c\u0016N\\6\u0015\r\tu$q\u0012BM!\u0015\u0001%q\u0010BB\u0013\r\u0011\t)\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\u0001\u0013)I!#\u0002V&\u0019!qQ!\u0003\rQ+\b\u000f\\33!\rq#1R\u0005\u0004\u0005\u001b{#\u0001\u0006*fg>dg/\u001a3DCR\fGn\\4UC\ndW\r\u0003\u0005\u0003\u0012\n]\u0004\u0019\u0001BJ\u0003Ay'M[3di&#WM\u001c;jM&,'\u000fE\u0002/\u0005+K1Aa&0\u0005Ay%M[3di&#WM\u001c;jM&,'\u000f\u0003\u0005\u0003\u001c\n]\u0004\u0019\u0001BO\u00039!\u0017P\\1nS\u000e|\u0005\u000f^5p]N\u0004\u0002Ba(\u00038\nu&Q\u0018\b\u0005\u0005C\u0013)L\u0004\u0003\u0003$\nMf\u0002\u0002BS\u0005csAAa*\u00030:!!\u0011\u0016BW\u001d\u0011\u0011yAa+\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!C\u0002\u0003\u001a\u0011IAA!/\u0003<\n!!*T1q\u0015\r\u0011I\u0002\u0002\t\u0005\u0005\u007f\u0013)MD\u0002A\u0005\u0003L1Aa1B\u0003\u0019\u0001&/\u001a3fM&!!q\u0019Be\u0005\u0019\u0019FO]5oO*\u0019!1Y!\t\u000f\t5\u0007\u0001\"\u0003\u0003P\u0006A\u0012n\u001d'fO\u0006\u001c\u0017pQ8o]\u0016\u001cGo\u001c:PaRLwN\\:\u0015\u000f}\u0012\tNa5\u0003^\"A!\u0011\u0013Bf\u0001\u0004\u0011\u0019\n\u0003\u0005\u0003V\n-\u0007\u0019\u0001Bl\u00031\u0019\u0017\r^1m_\u001e$\u0016M\u00197f!\rq#\u0011\\\u0005\u0004\u00057|#\u0001D\"bi\u0006dwn\u001a+bE2,\u0007b\u0002Bp\u0005\u0017\u0004\raP\u0001\fSN$V-\u001c9pe\u0006\u0014\u0018\u0010C\u0004\u0003d\u0002!\tE!:\u0002\u0017\u001d,GOS:p]Bc\u0017M\u001c\u000b\u0005\u0005{\u00139\u000f\u0003\u0005\u0002^\n\u0005\b\u0019AAp\u0011\u001d\u0011Y\u000f\u0001C!\u0005[\f\u0011\u0003\u001e:b]Nd\u0017\r^3Kg>t\u0007\u000b\\1o)\u0011\u0011yOa?\u0011\r\u0005M\u0016\u0011\u0018Bya\u0011\u0011\u0019Pa>\u0011\r\u0005\u0005\u0017\u0011\u001aB{!\u0011\tyEa>\u0005\u0019\te(\u0011^A\u0001\u0002\u0003\u0015\t!a5\u0003\u0007}#S\u0007\u0003\u0005\u0003~\n%\b\u0019\u0001B_\u0003!Q7o\u001c8QY\u0006t\u0007bBB\u0001\u0001\u0011E11A\u0001\u0013GJ,\u0017\r^3TKJ$WmQ8oi\u0016DH/\u0006\u0002\u0004\u0006A!1qAB\u0007\u001b\t\u0019IA\u0003\u0003\u0004\f\tm\u0012!B:fe\u0012,\u0017\u0002BB\b\u0007\u0013\u0011AbU3sI\u0016\u001cuN\u001c;fqRDqaa\u0005\u0001\t\u0013\u0019)\"\u0001\bhKR\u001cE.Y:t\u0019>\fG-\u001a:\u0016\u0005\r]\u0001cA\t\u0004\u001a%\u001911\u0004\n\u0003\u0017\rc\u0017m]:M_\u0006$WM\u001d\u0005\b\u0007?\u0001A\u0011CB\u0011\u0003\u00012\u0018\r\\5eCR,\u0017I\u001c3Pm\u0016\u0014(/\u001b3f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0003aCqa!\n\u0001\t#\u0019\t#A\u000fdY\u0016\fg.\u001e9J]R,'O\\1m\u0007>tg-[4ve\u0006$\u0018n\u001c8t\u0001")
public abstract class PlannerBase
implements Planner {
    private final Executor executor;
    private final TableConfig config;
    private final FunctionCatalog functionCatalog;
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;
    private Parser parser;
    private SqlDialect currentDialect;
    @VisibleForTesting
    private final PlannerContext plannerContext;
    private final SqlExprToRexConverterFactory sqlExprToRexConverterFactory;

    public FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    private Parser parser() {
        return this.parser;
    }

    private void parser_$eq(Parser x$1) {
        this.parser = x$1;
    }

    private SqlDialect currentDialect() {
        return this.currentDialect;
    }

    private void currentDialect_$eq(SqlDialect x$1) {
        this.currentDialect = x$1;
    }

    public PlannerContext plannerContext() {
        return this.plannerContext;
    }

    private SqlExprToRexConverterFactory sqlExprToRexConverterFactory() {
        return this.sqlExprToRexConverterFactory;
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createRelBuilder(currentCatalogName, currentDatabase);
    }

    @VisibleForTesting
    public FlinkPlannerImpl createFlinkPlanner() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.plannerContext().getTypeFactory();
    }

    public abstract RelTraitDef<? extends RelTrait>[] getTraitDefs();

    public abstract Optimizer getOptimizer();

    public TableConfig getTableConfig() {
        return this.config;
    }

    public FlinkContext getFlinkContext() {
        return this.plannerContext().getFlinkContext();
    }

    public StreamExecutionEnvironment getExecEnv() {
        return ((ExecutorBase)this.executor).getExecutionEnvironment();
    }

    public Parser createNewParser() {
        scala.collection.immutable.Map parserProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TableConfigOptions.TABLE_SQL_DIALECT.key()), (Object)this.getTableConfig().getSqlDialect().name().toLowerCase())}));
        return ((ParserFactory)ComponentFactoryService.find(ParserFactory.class, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)parserProps))).create(this.catalogManager(), this.plannerContext());
    }

    public Parser getParser() {
        block3: {
            block2: {
                if (this.parser() == null) break block2;
                SqlDialect sqlDialect = this.getTableConfig().getSqlDialect();
                SqlDialect sqlDialect2 = this.currentDialect();
                if (!(sqlDialect == null ? sqlDialect2 != null : !sqlDialect.equals(sqlDialect2))) break block3;
            }
            this.parser_$eq(this.createNewParser());
            this.currentDialect_$eq(this.getTableConfig().getSqlDialect());
        }
        return this.parser();
    }

    public List<Transformation<?>> translate(List<ModifyOperation> modifyOperations) {
        this.validateAndOverrideConfiguration();
        if (modifyOperations.isEmpty()) {
            return JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.empty());
        }
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(modifyOperations).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerBase $outer;

            public final RelNode apply(ModifyOperation modifyOperation) {
                return this.$outer.translateToRel(modifyOperation);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        return transformations;
    }

    @VisibleForTesting
    public RelNode translateToRel(ModifyOperation modifyOperation) {
        block10: {
            OutputConversionModifyOperation.UpdateMode updateMode;
            block14: {
                Tuple2.mcZZ.sp sp2;
                block15: {
                    RelNode relNode;
                    block5: {
                        Tuple2.mcZZ.sp sp3;
                        Tuple2.mcZZ.sp sp4;
                        RelNode input;
                        OutputConversionModifyOperation outputConversionModifyOperation;
                        DataTypeFactory dataTypeFactory;
                        block12: {
                            block13: {
                                block11: {
                                    ModifyOperation modifyOperation2;
                                    block9: {
                                        block7: {
                                            Option option;
                                            CatalogSinkModifyOperation catalogSinkModifyOperation;
                                            block8: {
                                                RelNode sinkRel;
                                                RelNode relNode2;
                                                java.util.Map dynamicOptions;
                                                block6: {
                                                    block4: {
                                                        dataTypeFactory = this.catalogManager().getDataTypeFactory();
                                                        modifyOperation2 = modifyOperation;
                                                        if (!(modifyOperation2 instanceof UnregisteredSinkModifyOperation)) break block4;
                                                        UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation2;
                                                        RelNode input2 = this.getRelBuilder().queryOperation(unregisteredSinkModifyOperation.getChild()).build();
                                                        TableSchema sinkSchema = unregisteredSinkModifyOperation.getSink().getTableSchema();
                                                        RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input2, this.catalogManager().getSchemaResolver().resolve(sinkSchema.toSchema()), null, dataTypeFactory, this.getTypeFactory());
                                                        relNode = LogicalLegacySink$.MODULE$.create(query, unregisteredSinkModifyOperation.getSink(), "UnregisteredSink", (CatalogTable)ConnectorCatalogTable.sink((TableSink)unregisteredSinkModifyOperation.getSink(), (!this.isStreamingMode ? 1 : 0) != 0), LogicalLegacySink$.MODULE$.create$default$5());
                                                        break block5;
                                                    }
                                                    if (!(modifyOperation2 instanceof CollectModifyOperation)) break block6;
                                                    CollectModifyOperation collectModifyOperation = (CollectModifyOperation)modifyOperation2;
                                                    RelNode input3 = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
                                                    relNode = DynamicSinkUtils.convertCollectToRel(this.getRelBuilder(), input3, collectModifyOperation);
                                                    break block5;
                                                }
                                                if (!(modifyOperation2 instanceof CatalogSinkModifyOperation)) break block7;
                                                catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
                                                RelNode input4 = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
                                                ObjectIdentifier identifier = catalogSinkModifyOperation.getTableIdentifier();
                                                option = this.getTableSink(identifier, dynamicOptions = catalogSinkModifyOperation.getDynamicOptions()).map((Function1)new Serializable(this, dataTypeFactory, input4, identifier, dynamicOptions, catalogSinkModifyOperation){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ PlannerBase $outer;
                                                    private final DataTypeFactory dataTypeFactory$1;
                                                    private final RelNode input$1;
                                                    private final ObjectIdentifier identifier$1;
                                                    private final java.util.Map dynamicOptions$1;
                                                    private final CatalogSinkModifyOperation x4$1;

                                                    public final RelNode apply(Tuple2<ResolvedCatalogTable, Object> x0$1) {
                                                        Tuple2<ResolvedCatalogTable, Object> tuple2;
                                                        block4: {
                                                            RelNode relNode;
                                                            block3: {
                                                                block2: {
                                                                    tuple2 = x0$1;
                                                                    if (tuple2 == null) break block2;
                                                                    ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                                                                    Object sink = tuple2._2();
                                                                    if (!(sink instanceof TableSink)) break block2;
                                                                    TableSink tableSink = (TableSink)sink;
                                                                    RowType queryLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(this.input$1.getRowType());
                                                                    TableSinkUtils$.MODULE$.validateLogicalPhysicalTypesCompatible((CatalogTable)table, tableSink, queryLogicalType);
                                                                    TableSinkUtils$.MODULE$.validateTableSink(this.x4$1, this.identifier$1, tableSink, (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(table.getPartitionKeys()));
                                                                    RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(this.input$1, table.getResolvedSchema(), this.x4$1.getTableIdentifier(), this.dataTypeFactory$1, this.$outer.getTypeFactory());
                                                                    ArrayList<RelHint> hints = new ArrayList<RelHint>();
                                                                    Object object = this.dynamicOptions$1.isEmpty() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)hints.add(RelHint.builder("OPTIONS").hintOptions(this.dynamicOptions$1).build()));
                                                                    relNode = LogicalLegacySink$.MODULE$.create(query, hints, tableSink, this.identifier$1.toString(), (CatalogTable)table, (scala.collection.immutable.Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap(this.x4$1.getStaticPartitions()).toMap(Predef$.MODULE$.$conforms()));
                                                                    break block3;
                                                                }
                                                                if (tuple2 == null) break block4;
                                                                ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                                                                Object sink = tuple2._2();
                                                                if (!(sink instanceof DynamicTableSink)) break block4;
                                                                DynamicTableSink dynamicTableSink = (DynamicTableSink)sink;
                                                                relNode = DynamicSinkUtils.convertSinkToRel(this.$outer.getRelBuilder(), this.input$1, this.x4$1, dynamicTableSink, table);
                                                            }
                                                            return relNode;
                                                        }
                                                        throw new MatchError(tuple2);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        this.dataTypeFactory$1 = dataTypeFactory$1;
                                                        this.input$1 = input$1;
                                                        this.identifier$1 = identifier$1;
                                                        this.dynamicOptions$1 = dynamicOptions$1;
                                                        this.x4$1 = x4$1;
                                                    }
                                                });
                                                if (!(option instanceof Some)) break block8;
                                                Some some = (Some)option;
                                                relNode = relNode2 = (sinkRel = (RelNode)some.x());
                                                break block5;
                                            }
                                            if (None$.MODULE$.equals(option)) {
                                                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sink ", " does not exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalogSinkModifyOperation.getTableIdentifier()})));
                                            }
                                            throw new MatchError((Object)option);
                                        }
                                        if (!(modifyOperation2 instanceof ExternalModifyOperation)) break block9;
                                        ExternalModifyOperation externalModifyOperation = (ExternalModifyOperation)modifyOperation2;
                                        RelNode input5 = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
                                        relNode = DynamicSinkUtils.convertExternalToRel(this.getRelBuilder(), input5, externalModifyOperation);
                                        break block5;
                                    }
                                    if (!(modifyOperation2 instanceof OutputConversionModifyOperation)) break block10;
                                    outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation2;
                                    input = this.getRelBuilder().queryOperation(outputConversionModifyOperation.getChild()).build();
                                    updateMode = outputConversionModifyOperation.getUpdateMode();
                                    if (!OutputConversionModifyOperation.UpdateMode.RETRACT.equals(updateMode)) break block11;
                                    sp4 = new Tuple2.mcZZ.sp(true, true);
                                    break block12;
                                }
                                if (!OutputConversionModifyOperation.UpdateMode.APPEND.equals(updateMode)) break block13;
                                sp4 = new Tuple2.mcZZ.sp(false, false);
                                break block12;
                            }
                            if (!OutputConversionModifyOperation.UpdateMode.UPSERT.equals(updateMode)) break block14;
                            sp4 = new Tuple2.mcZZ.sp(false, true);
                        }
                        sp2 = sp4;
                        if (sp2 == null) break block15;
                        boolean needUpdateBefore = sp2._1$mcZ$sp();
                        boolean withChangeFlag = sp2._2$mcZ$sp();
                        Tuple2.mcZZ.sp sp5 = sp3 = new Tuple2.mcZZ.sp(needUpdateBefore, withChangeFlag);
                        boolean needUpdateBefore2 = sp5._1$mcZ$sp();
                        boolean withChangeFlag2 = sp5._2$mcZ$sp();
                        TypeInformation typeInfo = LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo((DataType)outputConversionModifyOperation.getType());
                        RowType inputLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
                        TableSchema sinkPhysicalSchema = TableSinkUtils$.MODULE$.inferSinkPhysicalSchema(outputConversionModifyOperation.getType(), inputLogicalType, withChangeFlag2);
                        RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, this.catalogManager().getSchemaResolver().resolve(sinkPhysicalSchema.toSchema()), null, dataTypeFactory, this.getTypeFactory());
                        DataStreamTableSink tableSink = new DataStreamTableSink(FlinkTypeFactory$.MODULE$.toTableSchema(query.getRowType()), typeInfo, needUpdateBefore2, withChangeFlag2);
                        relNode = LogicalLegacySink$.MODULE$.create(query, tableSink, "DataStreamTableSink", (CatalogTable)ConnectorCatalogTable.sink(tableSink, (!this.isStreamingMode ? 1 : 0) != 0), LogicalLegacySink$.MODULE$.create$default$5());
                    }
                    return relNode;
                }
                throw new MatchError((Object)sp2);
            }
            throw new MatchError((Object)updateMode);
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ModifyOperation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modifyOperation})));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public Seq<RelNode> optimize(Seq<RelNode> relNodes) {
        void var2_2;
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize(relNodes);
        Predef$.MODULE$.require(optimizedRelNodes.size() == relNodes.size());
        return var2_2;
    }

    @VisibleForTesting
    public RelNode optimize(RelNode relNode) {
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize((Seq<RelNode>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{relNode}))));
        Predef$.MODULE$.require(optimizedRelNodes.size() == 1);
        return (RelNode)optimizedRelNodes.head();
    }

    @VisibleForTesting
    public ExecNodeGraph translateToExecNodeGraph(Seq<RelNode> optimizedRelNodes) {
        Seq nonPhysicalRel = (Seq)optimizedRelNodes.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelNode x$2) {
                return x$2 instanceof FlinkPhysicalRel;
            }
        });
        if (nonPhysicalRel.nonEmpty()) {
            throw new TableException(new StringBuilder().append((Object)"The expected optimized plan is FlinkPhysicalRel plan, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"actual plan is ", " plan."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nonPhysicalRel.head().getClass().getSimpleName()}))).toString());
        }
        Predef$.MODULE$.require(optimizedRelNodes.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelNode x$3) {
                return x$3 instanceof FlinkPhysicalRel;
            }
        }));
        SameRelObjectShuttle shuttle = new SameRelObjectShuttle();
        Seq relsWithoutSameObj = (Seq)optimizedRelNodes.map((Function1)new Serializable(this, shuttle){
            public static final long serialVersionUID = 0L;
            private final SameRelObjectShuttle shuttle$1;

            public final RelNode apply(RelNode x$4) {
                return x$4.accept(this.shuttle$1);
            }
            {
                this.shuttle$1 = shuttle$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<RelNode> reusedPlan = SubplanReuser$.MODULE$.reuseDuplicatedSubplan((Seq<RelNode>)relsWithoutSameObj, this.config);
        ExecNodeGraphGenerator generator = new ExecNodeGraphGenerator();
        ExecNodeGraph execGraph = generator.generate(JavaConversions$.MODULE$.seqAsJavaList((Seq)reusedPlan.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FlinkPhysicalRel apply(RelNode x$5) {
                return (FlinkPhysicalRel)x$5;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        ProcessorContext context = new ProcessorContext(this);
        Seq<ExecNodeGraphProcessor> processors = this.getExecNodeGraphProcessors();
        return (ExecNodeGraph)processors.foldLeft((Object)execGraph, (Function2)new Serializable(this, context){
            public static final long serialVersionUID = 0L;
            private final ProcessorContext context$1;

            public final ExecNodeGraph apply(ExecNodeGraph graph, ExecNodeGraphProcessor processor) {
                return processor.process(graph, this.context$1);
            }
            {
                this.context$1 = context$1;
            }
        });
    }

    public abstract Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors();

    public abstract List<Transformation<?>> translateToPlan(ExecNodeGraph var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Tuple2<ResolvedCatalogTable, Object>> getTableSink(ObjectIdentifier objectIdentifier, java.util.Map<String, String> dynamicOptions) {
        Option option;
        Option optionalLookupResult = JavaScalaConversionUtil$.MODULE$.toScala(this.catalogManager().getTable(objectIdentifier));
        if (optionalLookupResult.isEmpty()) {
            return None$.MODULE$;
        }
        CatalogManager.TableLookupResult lookupResult = (CatalogManager.TableLookupResult)optionalLookupResult.get();
        CatalogBaseTable catalogBaseTable = lookupResult.getTable();
        if (catalogBaseTable instanceof ConnectorCatalogTable) {
            None$ none$;
            ConnectorCatalogTable connectorCatalogTable = (ConnectorCatalogTable)catalogBaseTable;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)lookupResult.getResolvedTable();
            Option option2 = JavaScalaConversionUtil$.MODULE$.toScala(connectorCatalogTable.getTableSink());
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                TableSink sink = (TableSink)some.x();
                none$ = new Some((Object)new Tuple2((Object)resolvedTable, (Object)sink));
                return none$;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                none$ = None$.MODULE$;
            }
            return none$;
        }
        if (!(catalogBaseTable instanceof CatalogTable)) return None$.MODULE$;
        ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)lookupResult.getResolvedTable();
        ResolvedCatalogTable tableToFind = JavaConversions$.MODULE$.mapAsScalaMap(dynamicOptions).nonEmpty() ? resolvedTable.copy(FlinkHints.mergeTableOptions(dynamicOptions, resolvedTable.getOptions())) : resolvedTable;
        Optional catalog = this.catalogManager().getCatalog(objectIdentifier.getCatalogName());
        boolean isTemporary = lookupResult.isTemporary();
        if (this.isLegacyConnectorOptions(objectIdentifier, resolvedTable.getOrigin(), isTemporary)) {
            TableSink tableSink = TableFactoryUtil.findAndCreateTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (CatalogTable)tableToFind.getOrigin(), (ReadableConfig)this.getTableConfig().getConfiguration(), (boolean)this.isStreamingMode, (boolean)isTemporary);
            option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
            return option;
        } else {
            DynamicTableSink tableSink = FactoryUtil.createTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (ResolvedCatalogTable)tableToFind, (ReadableConfig)this.getTableConfig().getConfiguration(), (ClassLoader)this.getClassLoader(), (boolean)isTemporary);
            option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
        }
        return option;
    }

    private boolean isLegacyConnectorOptions(ObjectIdentifier objectIdentifier, CatalogTable catalogTable, boolean isTemporary) {
        boolean bl;
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(catalogTable.getOptions());
        if (properties.containsKey("connector.type")) {
            bl = true;
        } else {
            Optional catalog = this.catalogManager().getCatalog(objectIdentifier.getCatalogName());
            try {
                TableFactoryUtil.findAndCreateTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (CatalogTable)catalogTable, (ReadableConfig)this.getTableConfig().getConfiguration(), (boolean)this.isStreamingMode, (boolean)isTemporary);
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        return bl;
    }

    public String getJsonPlan(List<ModifyOperation> modifyOperations) {
        if (this.isStreamingMode) {
            this.validateAndOverrideConfiguration();
            Buffer relNodes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(modifyOperations).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PlannerBase $outer;

                public final RelNode apply(ModifyOperation modifyOperation) {
                    return this.$outer.translateToRel(modifyOperation);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
            ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
            String jsonPlan = ExecNodeGraph.createJsonPlan(execGraph, this.createSerdeContext());
            this.cleanupInternalConfigurations();
            return jsonPlan;
        }
        throw new TableException("Only streaming mode is supported now.");
    }

    /*
     * WARNING - void declaration
     */
    public List<Transformation<?>> translateJsonPlan(String jsonPlan) {
        if (this.isStreamingMode) {
            void var3_3;
            this.validateAndOverrideConfiguration();
            ExecNodeGraph execGraph = ExecNodeGraph.createExecNodeGraph(jsonPlan, this.createSerdeContext());
            List<Transformation<?>> transformations = this.translateToPlan(execGraph);
            this.cleanupInternalConfigurations();
            return var3_3;
        }
        throw new TableException("Only streaming mode is supported now.");
    }

    public SerdeContext createSerdeContext() {
        FlinkPlannerImpl planner = this.createFlinkPlanner();
        return new SerdeContext((FlinkContext)planner.config().getContext(), this.getClassLoader(), this.plannerContext().getTypeFactory(), planner.operatorTable());
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void validateAndOverrideConfiguration() {
        Configuration configuration = this.config.getConfiguration();
        if (((Enum)configuration.get(TableConfigOptions.TABLE_PLANNER)).equals(PlannerType.BLINK)) {
            Long epochTime = Predef$.MODULE$.long2Long(System.currentTimeMillis());
            configuration.set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)epochTime);
            Long localTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(epochTime) + (long)TimeZone.getTimeZone(this.config.getLocalTimeZone()).getOffset(Predef$.MODULE$.Long2long(epochTime)));
            configuration.set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)localTime);
            this.getExecEnv().configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
            int defaultParallelism = this.getTableConfig().getConfiguration().getInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM);
            if (defaultParallelism > 0) {
                this.getExecEnv().getConfig().setParallelism(defaultParallelism);
            }
            return;
        }
        throw new IllegalArgumentException("Mismatch between configured planner and actual planner. Currently, the 'table.planner' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
    }

    public void cleanupInternalConfigurations() {
        Configuration configuration = this.config.getConfiguration();
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME);
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME);
    }

    public PlannerBase(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager, boolean isStreamingMode) {
        this.executor = executor;
        this.config = config;
        this.functionCatalog = functionCatalog;
        this.catalogManager = catalogManager;
        this.isStreamingMode = isStreamingMode;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.currentDialect = this.getTableConfig().getSqlDialect();
        this.plannerContext = new PlannerContext(config, functionCatalog, catalogManager, CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, isStreamingMode)), JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])this.getTraitDefs()).toList()));
        this.sqlExprToRexConverterFactory = this.plannerContext().getSqlExprToRexConverterFactory();
    }
}

