/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;

@Internal
public class StreamEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String edgeId;
    private final StreamNode sourceVertex;
    private final StreamNode targetVertex;
    private final int typeNumber;
    private final List<String> selectedNames;
    private final OutputTag outputTag;
    private StreamPartitioner<?> outputPartitioner;

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, List<String> selectedNames, StreamPartitioner<?> outputPartitioner, OutputTag outputTag) {
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        this.typeNumber = typeNumber;
        this.selectedNames = selectedNames;
        this.outputPartitioner = outputPartitioner;
        this.outputTag = outputTag;
        this.edgeId = sourceVertex + "_" + targetVertex + "_" + typeNumber + "_" + selectedNames + "_" + outputPartitioner;
    }

    public StreamNode getSourceVertex() {
        return this.sourceVertex;
    }

    public StreamNode getTargetVertex() {
        return this.targetVertex;
    }

    public int getSourceId() {
        return this.sourceVertex.getId();
    }

    public int getTargetId() {
        return this.targetVertex.getId();
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public List<String> getSelectedNames() {
        return this.selectedNames;
    }

    public OutputTag getOutputTag() {
        return this.outputTag;
    }

    public StreamPartitioner<?> getPartitioner() {
        return this.outputPartitioner;
    }

    public void setPartitioner(StreamPartitioner<?> partitioner) {
        this.outputPartitioner = partitioner;
    }

    public int hashCode() {
        return this.edgeId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamEdge that = (StreamEdge)o;
        return this.edgeId.equals(that.edgeId);
    }

    public String toString() {
        return "(" + this.sourceVertex + " -> " + this.targetVertex + ", typeNumber=" + this.typeNumber + ", selectedNames=" + this.selectedNames + ", outputPartitioner=" + this.outputPartitioner + ", outputTag=" + this.outputTag + ')';
    }
}

