/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.io.Serializable;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

public class TimestampedFileInputSplit
extends FileInputSplit
implements Comparable<TimestampedFileInputSplit> {
    private final long modificationTime;
    private Serializable splitState;

    public TimestampedFileInputSplit(long modificationTime, int num, Path file, long start, long length, String[] hosts) {
        super(num, file, start, length, hosts);
        Preconditions.checkArgument((modificationTime >= 0L || modificationTime == Long.MIN_VALUE ? 1 : 0) != 0, (Object)("Invalid File Split Modification Time: " + modificationTime + "."));
        this.modificationTime = modificationTime;
    }

    public void setSplitState(Serializable state) {
        this.splitState = state;
    }

    public void resetSplitState() {
        this.setSplitState(null);
    }

    public Serializable getSplitState() {
        return this.splitState;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public int compareTo(TimestampedFileInputSplit o) {
        int modTimeComp = Long.compare(this.modificationTime, o.modificationTime);
        if ((long)modTimeComp != 0L) {
            return modTimeComp;
        }
        if (this.getPath() == null && o.getPath() != null) {
            return 1;
        }
        if (this.getPath() != null && o.getPath() == null) {
            return -1;
        }
        int pathComp = this.getPath() == o.getPath() ? 0 : this.getPath().compareTo((Object)o.getPath());
        return pathComp != 0 ? pathComp : this.getSplitNumber() - o.getSplitNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof TimestampedFileInputSplit && super.equals(o)) {
            TimestampedFileInputSplit that = (TimestampedFileInputSplit)o;
            return this.modificationTime == that.modificationTime;
        }
        return false;
    }

    public int hashCode() {
        int res = 37 * (int)(this.modificationTime ^ this.modificationTime >>> 32);
        return 37 * res + super.hashCode();
    }

    public String toString() {
        return "[" + this.getSplitNumber() + "] " + this.getPath() + " mod@ " + this.modificationTime + " : " + this.getStart() + " + " + this.getLength();
    }
}

