/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;

class TtlUtils {
    TtlUtils() {
    }

    static <V> boolean expired(TtlValue<V> ttlValue, long ttl, TtlTimeProvider timeProvider) {
        return ttlValue != null && TtlUtils.expired(ttlValue.getLastAccessTimestamp(), ttl, timeProvider);
    }

    static boolean expired(long ts, long ttl, TtlTimeProvider timeProvider) {
        return TtlUtils.getExpirationTimestamp(ts, ttl) <= timeProvider.currentTimestamp();
    }

    private static long getExpirationTimestamp(long ts, long ttl) {
        long ttlWithoutOverflow = ts > 0L ? Math.min(Long.MAX_VALUE - ts, ttl) : ttl;
        return ts + ttlWithoutOverflow;
    }

    static <V> TtlValue<V> wrapWithTs(V value, long ts) {
        return value == null ? null : new TtlValue<V>(value, ts);
    }
}

