/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredBroadcastStateBackendMetaInfo<K, V>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final OperatorStateHandle.Mode assignmentMode;
    @Nonnull
    private final TypeSerializer<K> keySerializer;
    @Nonnull
    private final TypeSerializer<V> valueSerializer;

    public RegisteredBroadcastStateBackendMetaInfo(@Nonnull String name, @Nonnull OperatorStateHandle.Mode assignmentMode, @Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<V> valueSerializer) {
        super(name);
        Preconditions.checkArgument((assignmentMode == OperatorStateHandle.Mode.BROADCAST ? 1 : 0) != 0);
        this.assignmentMode = assignmentMode;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public RegisteredBroadcastStateBackendMetaInfo(@Nonnull RegisteredBroadcastStateBackendMetaInfo<K, V> copy) {
        this(((RegisteredBroadcastStateBackendMetaInfo)Preconditions.checkNotNull(copy)).name, copy.assignmentMode, copy.keySerializer.duplicate(), copy.valueSerializer.duplicate());
    }

    public RegisteredBroadcastStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), OperatorStateHandle.Mode.valueOf(snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.OPERATOR_STATE_DISTRIBUTION_MODE)), (TypeSerializer)Preconditions.checkNotNull(snapshot.getTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.KEY_SERIALIZER)), (TypeSerializer)Preconditions.checkNotNull(snapshot.getTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER)));
        Preconditions.checkState((StateMetaInfoSnapshot.BackendStateType.BROADCAST == snapshot.getBackendStateType() ? 1 : 0) != 0);
    }

    @Nonnull
    public RegisteredBroadcastStateBackendMetaInfo<K, V> deepCopy() {
        return new RegisteredBroadcastStateBackendMetaInfo<K, V>(this);
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Nonnull
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Nonnull
    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Nonnull
    public OperatorStateHandle.Mode getAssignmentMode() {
        return this.assignmentMode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegisteredBroadcastStateBackendMetaInfo)) {
            return false;
        }
        RegisteredBroadcastStateBackendMetaInfo other = (RegisteredBroadcastStateBackendMetaInfo)obj;
        return Objects.equals(this.name, other.getName()) && Objects.equals((Object)this.assignmentMode, (Object)other.getAssignmentMode()) && Objects.equals(this.keySerializer, other.getKeySerializer()) && Objects.equals(this.valueSerializer, other.getValueSerializer());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.assignmentMode.hashCode();
        result = 31 * result + this.keySerializer.hashCode();
        result = 31 * result + this.valueSerializer.hashCode();
        return result;
    }

    public String toString() {
        return "RegisteredBroadcastBackendStateMetaInfo{name='" + this.name + '\'' + ", keySerializer=" + this.keySerializer + ", valueSerializer=" + this.valueSerializer + ", assignmentMode=" + (Object)((Object)this.assignmentMode) + '}';
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.OPERATOR_STATE_DISTRIBUTION_MODE.toString(), this.assignmentMode.toString());
        HashMap serializerMap = new HashMap(2);
        HashMap<String, TypeSerializerConfigSnapshot> serializerConfigSnapshotsMap = new HashMap<String, TypeSerializerConfigSnapshot>(2);
        String keySerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.KEY_SERIALIZER.toString();
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        serializerMap.put(keySerializerKey, this.keySerializer.duplicate());
        serializerConfigSnapshotsMap.put(keySerializerKey, this.keySerializer.snapshotConfiguration());
        serializerMap.put(valueSerializerKey, this.valueSerializer.duplicate());
        serializerConfigSnapshotsMap.put(valueSerializerKey, this.valueSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.BROADCAST, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }
}

