/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import javax.annotation.Nullable;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.net.SSLEngineFactory;
import org.apache.flink.util.Preconditions;

public class SSLUtils {
    public static boolean isInternalSSLEnabled(Configuration sslConfig) {
        boolean fallbackFlag = sslConfig.getBoolean(SecurityOptions.SSL_ENABLED);
        return sslConfig.getBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, fallbackFlag);
    }

    public static boolean isRestSSLEnabled(Configuration sslConfig) {
        boolean fallbackFlag = sslConfig.getBoolean(SecurityOptions.SSL_ENABLED);
        return sslConfig.getBoolean(SecurityOptions.SSL_REST_ENABLED, fallbackFlag);
    }

    public static ServerSocketFactory createSSLServerSocketFactory(Configuration config) throws Exception {
        SSLContext sslContext = SSLUtils.createInternalSSLContext(config);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled");
        }
        String[] protocols = SSLUtils.getEnabledProtocols(config);
        String[] cipherSuites = SSLUtils.getEnabledCipherSuites(config);
        SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
        return new ConfiguringSSLServerSocketFactory(factory, protocols, cipherSuites);
    }

    public static SocketFactory createSSLClientSocketFactory(Configuration config) throws Exception {
        SSLContext sslContext = SSLUtils.createInternalSSLContext(config);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled");
        }
        return sslContext.getSocketFactory();
    }

    public static SSLEngineFactory createInternalServerSSLEngineFactory(Configuration config) throws Exception {
        SSLContext sslContext = SSLUtils.createInternalSSLContext(config);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled for internal communication.");
        }
        return new SSLEngineFactory(sslContext, SSLUtils.getEnabledProtocols(config), SSLUtils.getEnabledCipherSuites(config), false, true);
    }

    public static SSLEngineFactory createInternalClientSSLEngineFactory(Configuration config) throws Exception {
        SSLContext sslContext = SSLUtils.createInternalSSLContext(config);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled for internal communication.");
        }
        return new SSLEngineFactory(sslContext, SSLUtils.getEnabledProtocols(config), SSLUtils.getEnabledCipherSuites(config), true, true);
    }

    public static SSLEngineFactory createRestServerSSLEngineFactory(Configuration config) throws Exception {
        SSLContext sslContext = SSLUtils.createRestServerSSLContext(config);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled for REST endpoints.");
        }
        return new SSLEngineFactory(sslContext, SSLUtils.getEnabledProtocols(config), SSLUtils.getEnabledCipherSuites(config), false, false);
    }

    public static SSLEngineFactory createRestClientSSLEngineFactory(Configuration config) throws Exception {
        SSLContext sslContext = SSLUtils.createRestClientSSLContext(config);
        if (sslContext == null) {
            throw new IllegalConfigurationException("SSL is not enabled for REST endpoints.");
        }
        return new SSLEngineFactory(sslContext, SSLUtils.getEnabledProtocols(config), SSLUtils.getEnabledCipherSuites(config), true, false);
    }

    private static String[] getEnabledProtocols(Configuration config) {
        Preconditions.checkNotNull((Object)config, (String)"config must not be null");
        return config.getString(SecurityOptions.SSL_PROTOCOL).split(",");
    }

    private static String[] getEnabledCipherSuites(Configuration config) {
        Preconditions.checkNotNull((Object)config, (String)"config must not be null");
        return config.getString(SecurityOptions.SSL_ALGORITHMS).split(",");
    }

    @Nullable
    public static SSLContext createInternalSSLContext(Configuration config) throws Exception {
        Preconditions.checkNotNull((Object)config, (String)"config");
        if (!SSLUtils.isInternalSSLEnabled(config)) {
            return null;
        }
        String keystoreFilePath = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_INTERNAL_KEYSTORE, (ConfigOption<String>)SecurityOptions.SSL_KEYSTORE);
        String keystorePassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD, (ConfigOption<String>)SecurityOptions.SSL_KEYSTORE_PASSWORD);
        String certPassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_INTERNAL_KEY_PASSWORD, (ConfigOption<String>)SecurityOptions.SSL_KEY_PASSWORD);
        String trustStoreFilePath = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_INTERNAL_TRUSTSTORE, (ConfigOption<String>)SecurityOptions.SSL_TRUSTSTORE);
        String trustStorePassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_INTERNAL_TRUSTSTORE_PASSWORD, (ConfigOption<String>)SecurityOptions.SSL_TRUSTSTORE_PASSWORD);
        String sslProtocolVersion = config.getString(SecurityOptions.SSL_PROTOCOL);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream keyStoreFile = Files.newInputStream(new File(keystoreFilePath).toPath(), new OpenOption[0]);){
            keyStore.load(keyStoreFile, keystorePassword.toCharArray());
        }
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream trustStoreFile = Files.newInputStream(new File(trustStoreFilePath).toPath(), new OpenOption[0]);){
            trustStore.load(trustStoreFile, trustStorePassword.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, certPassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(sslProtocolVersion);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    @Nullable
    public static SSLContext createRestServerSSLContext(Configuration config) throws Exception {
        Preconditions.checkNotNull((Object)config, (String)"config");
        if (!SSLUtils.isRestSSLEnabled(config)) {
            return null;
        }
        String keystoreFilePath = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_REST_KEYSTORE, (ConfigOption<String>)SecurityOptions.SSL_KEYSTORE);
        String keystorePassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, (ConfigOption<String>)SecurityOptions.SSL_KEYSTORE_PASSWORD);
        String certPassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_REST_KEY_PASSWORD, (ConfigOption<String>)SecurityOptions.SSL_KEY_PASSWORD);
        String sslProtocolVersion = config.getString(SecurityOptions.SSL_PROTOCOL);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream keyStoreFile = Files.newInputStream(new File(keystoreFilePath).toPath(), new OpenOption[0]);){
            keyStore.load(keyStoreFile, keystorePassword.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, certPassword.toCharArray());
        SSLContext sslContext = SSLContext.getInstance(sslProtocolVersion);
        sslContext.init(kmf.getKeyManagers(), null, null);
        return sslContext;
    }

    @Nullable
    public static SSLContext createRestClientSSLContext(Configuration config) throws Exception {
        Preconditions.checkNotNull((Object)config, (String)"config");
        if (!SSLUtils.isRestSSLEnabled(config)) {
            return null;
        }
        String trustStoreFilePath = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_REST_TRUSTSTORE, (ConfigOption<String>)SecurityOptions.SSL_TRUSTSTORE);
        String trustStorePassword = SSLUtils.getAndCheckOption(config, (ConfigOption<String>)SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, (ConfigOption<String>)SecurityOptions.SSL_TRUSTSTORE_PASSWORD);
        String sslProtocolVersion = config.getString(SecurityOptions.SSL_PROTOCOL);
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream trustStoreFile = Files.newInputStream(new File(trustStoreFilePath).toPath(), new OpenOption[0]);){
            trustStore.load(trustStoreFile, trustStorePassword.toCharArray());
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(sslProtocolVersion);
        sslContext.init(null, tmf.getTrustManagers(), null);
        return sslContext;
    }

    private static String getAndCheckOption(Configuration config, ConfigOption<String> primaryOption, ConfigOption<String> fallbackOption) {
        String value = config.getString(primaryOption, config.getString(fallbackOption));
        if (value != null) {
            return value;
        }
        throw new IllegalConfigurationException("The config option " + primaryOption.key() + " or " + fallbackOption.key() + " is missing.");
    }

    private static class ConfiguringSSLServerSocketFactory
    extends ServerSocketFactory {
        private final SSLServerSocketFactory sslServerSocketFactory;
        private final String[] protocols;
        private final String[] cipherSuites;

        ConfiguringSSLServerSocketFactory(SSLServerSocketFactory sslServerSocketFactory, String[] protocols, String[] cipherSuites) {
            this.sslServerSocketFactory = sslServerSocketFactory;
            this.protocols = protocols;
            this.cipherSuites = cipherSuites;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            SSLServerSocket socket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port);
            this.configureServerSocket(socket);
            return socket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            SSLServerSocket socket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog);
            this.configureServerSocket(socket);
            return socket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            SSLServerSocket socket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog, ifAddress);
            this.configureServerSocket(socket);
            return socket;
        }

        private void configureServerSocket(SSLServerSocket socket) {
            socket.setEnabledProtocols(this.protocols);
            socket.setEnabledCipherSuites(this.cipherSuites);
            socket.setNeedClientAuth(true);
        }
    }
}

