/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.parser;

import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;

public class CommandLineParser<T> {
    @Nonnull
    private final ParserResultFactory<T> parserResultFactory;

    public CommandLineParser(@Nonnull ParserResultFactory<T> parserResultFactory) {
        this.parserResultFactory = parserResultFactory;
    }

    public T parse(@Nonnull String[] args) throws FlinkParseException {
        CommandLine commandLine;
        DefaultParser parser = new DefaultParser();
        Options options = this.parserResultFactory.getOptions();
        try {
            commandLine = parser.parse(options, args, true);
        }
        catch (ParseException e) {
            throw new FlinkParseException("Failed to parse the command line arguments.", e);
        }
        return this.parserResultFactory.createResult(commandLine);
    }

    public void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("", this.parserResultFactory.getOptions());
    }
}

