/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.AntlrACIItemParserTokenTypes;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.ItemFirstACIItem;
import org.apache.directory.shared.ldap.aci.ItemPermission;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.aci.UserFirstACIItem;
import org.apache.directory.shared.ldap.aci.UserPermission;
import org.apache.directory.shared.ldap.aci.protectedItem.AllAttributeValuesItem;
import org.apache.directory.shared.ldap.aci.protectedItem.AttributeTypeItem;
import org.apache.directory.shared.ldap.aci.protectedItem.AttributeValueItem;
import org.apache.directory.shared.ldap.aci.protectedItem.ClassesItem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxImmSubItem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxValueCountElem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxValueCountItem;
import org.apache.directory.shared.ldap.aci.protectedItem.RangeOfValuesItem;
import org.apache.directory.shared.ldap.aci.protectedItem.RestrictedByElem;
import org.apache.directory.shared.ldap.aci.protectedItem.RestrictedByItem;
import org.apache.directory.shared.ldap.aci.protectedItem.SelfValueItem;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.FilterParser;
import org.apache.directory.shared.ldap.model.filter.LeafNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.DnUtils;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.normalizers.NameComponentNormalizer;
import org.apache.directory.shared.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.model.subtree.SubtreeSpecificationModifier;
import org.apache.directory.shared.util.ComponentsMonitor;
import org.apache.directory.shared.util.MandatoryAndOptionalComponentsMonitor;
import org.apache.directory.shared.util.MandatoryComponentsMonitor;
import org.apache.directory.shared.util.NoDuplicateKeysMap;
import org.apache.directory.shared.util.OptionalComponentsMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrACIItemParser
extends LLkParser
implements AntlrACIItemParserTokenTypes {
    private static final Logger log = LoggerFactory.getLogger(AntlrACIItemParser.class);
    NameComponentNormalizer normalizer;
    private String identificationTag;
    private AuthenticationLevel authenticationLevel;
    private Integer aciPrecedence = null;
    private boolean isItemFirstACIItem;
    private Set<ProtectedItem> protectedItems;
    private Map<String, ProtectedItem> protectedItemsMap;
    private Set<UserClass> userClasses;
    private Map<String, UserClass> userClassesMap;
    private Set<ItemPermission> itemPermissions;
    private Integer precedence = null;
    private Set<GrantAndDenial> grantsAndDenials;
    private Set<UserPermission> userPermissions;
    private SchemaManager schemaManager;
    private Set<Dn> chopBeforeExclusions;
    private Set<Dn> chopAfterExclusions;
    private SubtreeSpecificationModifier ssModifier = null;
    private ComponentsMonitor mainACIItemComponentsMonitor;
    private ComponentsMonitor itemPermissionComponentsMonitor;
    private ComponentsMonitor userPermissionComponentsMonitor;
    private ComponentsMonitor subtreeSpecificationComponentsMonitor;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "ATTRIBUTE_VALUE_CANDIDATE", "RANGE_OF_VALUES_CANDIDATE", "SP", "OPEN_CURLY", "SEP", "CLOSE_CURLY", "\"identificationTag\"", "SAFEUTF8STRING", "\"precedence\"", "INTEGER", "\"authenticationLevel\"", "\"none\"", "\"simple\"", "\"strong\"", "\"itemOrUserFirst\"", "\"itemFirst\"", "COLON", "\"userFirst\"", "\"protectedItems\"", "\"entry\"", "\"allUserAttributeTypes\"", "\"attributeType\"", "\"allAttributeValues\"", "\"allUserAttributeTypesAndValues\"", "\"selfValue\"", "\"maxValueCount\"", "\"type\"", "\"maxCount\"", "\"maxImmSub\"", "\"restrictedBy\"", "\"valuesIn\"", "\"classes\"", "\"itemPermissions\"", "\"grantsAndDenials\"", "\"grantAdd\"", "\"denyAdd\"", "\"grantDiscloseOnError\"", "\"denyDiscloseOnError\"", "\"grantRead\"", "\"denyRead\"", "\"grantRemove\"", "\"denyRemove\"", "\"grantBrowse\"", "\"denyBrowse\"", "\"grantExport\"", "\"denyExport\"", "\"grantImport\"", "\"denyImport\"", "\"grantModify\"", "\"denyModify\"", "\"grantRename\"", "\"denyRename\"", "\"grantReturnDN\"", "\"denyReturnDN\"", "\"grantCompare\"", "\"denyCompare\"", "\"grantFilterMatch\"", "\"denyFilterMatch\"", "\"grantInvoke\"", "\"denyInvoke\"", "\"userClasses\"", "\"allUsers\"", "\"thisEntry\"", "\"parentOfEntry\"", "\"name\"", "\"userGroup\"", "\"subtree\"", "\"userPermissions\"", "\"base\"", "\"specificExclusions\"", "\"chopBefore\"", "\"chopAfter\"", "\"minimum\"", "\"maximum\"", "DESCR", "NUMERICOID", "\"item\"", "\"and\"", "\"or\"", "\"not\"", "\"FALSE\"", "\"TRUE\"", "\"level\"", "\"basicLevels\"", "\"localQualifier\"", "\"signed\"", "\"rangeOfValues\"", "\"specificationFilter\"", "SAFEUTF8CHAR", "DIGIT", "LDIGIT", "ALPHA", "HYPHEN", "DOT", "INTEGER_OR_NUMERICOID", "FILTER", "FILTER_VALUE"};

    public void init(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public void setNormalizer(NameComponentNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    private int token2Integer(Token token) throws RecognitionException {
        int i = 0;
        try {
            i = Integer.parseInt(token.getText());
        }
        catch (NumberFormatException e) {
            throw new RecognitionException("Value of INTEGER token " + token.getText() + " cannot be converted to an Integer");
        }
        return i;
    }

    protected AntlrACIItemParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrACIItemParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 1);
    }

    protected AntlrACIItemParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrACIItemParser(TokenStream lexer) {
        this(lexer, 1);
    }

    public AntlrACIItemParser(ParserSharedInputState state) {
        super(state, 1);
        this.tokenNames = _tokenNames;
    }

    public final ACIItem wrapperEntryPoint() throws RecognitionException, TokenStreamException {
        log.debug("entered wrapperEntryPoint()");
        ACIItem aciItem = null;
        while (this.LA(1) == 6) {
            this.match(6);
        }
        aciItem = this.theACIItem();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(1);
        return aciItem;
    }

    public final ACIItem theACIItem() throws RecognitionException, TokenStreamException {
        log.debug("entered theACIItem()");
        ACIItem aciItem = null;
        this.mainACIItemComponentsMonitor = new MandatoryComponentsMonitor(new String[]{"identificationTag", "precedence", "authenticationLevel", "itemOrUserFirst"});
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.mainACIItemComponent();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            this.mainACIItemComponent();
            while (this.LA(1) == 6) {
                this.match(6);
            }
        }
        this.match(9);
        if (!this.mainACIItemComponentsMonitor.finalStateValid()) {
            throw new RecognitionException("Missing mandatory ACIItem components: " + this.mainACIItemComponentsMonitor.getRemainingComponents());
        }
        aciItem = this.isItemFirstACIItem ? new ItemFirstACIItem(this.identificationTag, this.aciPrecedence, this.authenticationLevel, this.protectedItems, this.itemPermissions) : new UserFirstACIItem(this.identificationTag, this.aciPrecedence, this.authenticationLevel, this.userClasses, this.userPermissions);
        return aciItem;
    }

    public final void mainACIItemComponent() throws RecognitionException, TokenStreamException {
        log.debug("entered mainACIItemComponent()");
        try {
            switch (this.LA(1)) {
                case 10: {
                    this.aci_identificationTag();
                    this.mainACIItemComponentsMonitor.useComponent("identificationTag");
                    break;
                }
                case 12: {
                    this.aci_precedence();
                    this.mainACIItemComponentsMonitor.useComponent("precedence");
                    break;
                }
                case 14: {
                    this.aci_authenticationLevel();
                    this.mainACIItemComponentsMonitor.useComponent("authenticationLevel");
                    break;
                }
                case 18: {
                    this.aci_itemOrUserFirst();
                    this.mainACIItemComponentsMonitor.useComponent("itemOrUserFirst");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void aci_identificationTag() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered aci_identificationTag()");
        this.match(10);
        int _cnt20 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt20 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt20;
        }
        token = this.LT(1);
        this.match(11);
        this.identificationTag = token.getText();
    }

    public final void aci_precedence() throws RecognitionException, TokenStreamException {
        log.debug("entered aci_precedence()");
        this.precedence();
        this.aciPrecedence = (int)this.precedence;
        this.precedence = null;
    }

    public final void aci_authenticationLevel() throws RecognitionException, TokenStreamException {
        log.debug("entered aci_authenticationLevel()");
        this.match(14);
        int _cnt27 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt27 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt27;
        }
        this.authenticationLevel();
    }

    public final void aci_itemOrUserFirst() throws RecognitionException, TokenStreamException {
        log.debug("entered aci_itemOrUserFirst()");
        this.match(18);
        int _cnt31 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt31 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt31;
        }
        this.itemOrUserFirst();
    }

    public final void precedence() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered precedence()");
        this.match(12);
        int _cnt24 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt24 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt24;
        }
        token = this.LT(1);
        this.match(13);
        this.precedence = this.token2Integer(token);
        if (this.precedence < 0 || this.precedence > 255) {
            throw new RecognitionException("Expecting INTEGER token having an Integer value between 0 and 255, found " + this.precedence);
        }
    }

    public final void authenticationLevel() throws RecognitionException, TokenStreamException {
        log.debug("entered authenticationLevel()");
        switch (this.LA(1)) {
            case 15: {
                this.match(15);
                this.authenticationLevel = AuthenticationLevel.NONE;
                break;
            }
            case 16: {
                this.match(16);
                this.authenticationLevel = AuthenticationLevel.SIMPLE;
                break;
            }
            case 17: {
                this.match(17);
                this.authenticationLevel = AuthenticationLevel.STRONG;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void itemOrUserFirst() throws RecognitionException, TokenStreamException {
        log.debug("entered itemOrUserFirst()");
        switch (this.LA(1)) {
            case 19: {
                this.itemFirst();
                break;
            }
            case 21: {
                this.userFirst();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void itemFirst() throws RecognitionException, TokenStreamException {
        log.debug("entered itemFirst()");
        this.match(19);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.protectedItems();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(8);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.itemPermissions();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(9);
        this.isItemFirstACIItem = true;
    }

    public final void userFirst() throws RecognitionException, TokenStreamException {
        log.debug("entered userFirst()");
        this.match(21);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.userClasses();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(8);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.userPermissions();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(9);
        this.isItemFirstACIItem = false;
    }

    public final void protectedItems() throws RecognitionException, TokenStreamException {
        log.debug("entered protectedItems()");
        this.protectedItemsMap = new NoDuplicateKeysMap();
        try {
            this.match(22);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            this.match(7);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 32: 
                case 33: 
                case 35: {
                    this.protectedItem();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    while (this.LA(1) == 8) {
                        this.match(8);
                        while (this.LA(1) == 6) {
                            this.match(6);
                        }
                        this.protectedItem();
                        while (this.LA(1) == 6) {
                            this.match(6);
                        }
                    }
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
            this.protectedItems = new HashSet<ProtectedItem>(this.protectedItemsMap.values());
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException("Protected Items cannot be duplicated. " + e.getMessage());
        }
    }

    public final void itemPermissions() throws RecognitionException, TokenStreamException {
        log.debug("entered itemPermissions()");
        this.itemPermissions = new HashSet<ItemPermission>();
        ItemPermission itemPermission = null;
        this.match(36);
        int _cnt177 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt177 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt177;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 7: {
                itemPermission = this.itemPermission();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.itemPermissions.add(itemPermission);
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    itemPermission = this.itemPermission();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.itemPermissions.add(itemPermission);
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
    }

    public final void userClasses() throws RecognitionException, TokenStreamException {
        log.debug("entered userClasses()");
        this.userClassesMap = new NoDuplicateKeysMap();
        try {
            this.match(64);
            int _cnt218 = 0;
            while (true) {
                if (this.LA(1) != 6) {
                    if (_cnt218 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(6);
                ++_cnt218;
            }
            this.match(7);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            switch (this.LA(1)) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    this.userClass();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    while (this.LA(1) == 8) {
                        this.match(8);
                        while (this.LA(1) == 6) {
                            this.match(6);
                        }
                        this.userClass();
                        while (this.LA(1) == 6) {
                            this.match(6);
                        }
                    }
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(9);
            this.userClasses = new HashSet<UserClass>(this.userClassesMap.values());
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException("User Classes cannot be duplicated. " + e.getMessage());
        }
    }

    public final void userPermissions() throws RecognitionException, TokenStreamException {
        log.debug("entered userPermissions()");
        this.userPermissions = new HashSet<UserPermission>();
        UserPermission userPermission = null;
        this.match(71);
        int _cnt275 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt275 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt275;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 7: {
                userPermission = this.userPermission();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.userPermissions.add(userPermission);
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    userPermission = this.userPermission();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.userPermissions.add(userPermission);
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
    }

    public final void protectedItem() throws RecognitionException, TokenStreamException {
        log.debug("entered protectedItem()");
        switch (this.LA(1)) {
            case 23: {
                this.entry();
                break;
            }
            case 24: {
                this.allUserAttributeTypes();
                break;
            }
            case 25: {
                this.attributeType();
                break;
            }
            case 26: {
                this.allAttributeValues();
                break;
            }
            case 27: {
                this.allUserAttributeTypesAndValues();
                break;
            }
            case 4: {
                this.attributeValue();
                break;
            }
            case 28: {
                this.selfValue();
                break;
            }
            case 5: {
                this.rangeOfValues();
                break;
            }
            case 29: {
                this.maxValueCount();
                break;
            }
            case 32: {
                this.maxImmSub();
                break;
            }
            case 33: {
                this.restrictedBy();
                break;
            }
            case 35: {
                this.classes();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void entry() throws RecognitionException, TokenStreamException {
        log.debug("entered entry()");
        this.match(23);
        this.protectedItemsMap.put("entry", ProtectedItem.ENTRY);
    }

    public final void allUserAttributeTypes() throws RecognitionException, TokenStreamException {
        log.debug("entered allUserAttributeTypes()");
        this.match(24);
        this.protectedItemsMap.put("allUserAttributeTypes", ProtectedItem.ALL_USER_ATTRIBUTE_TYPES);
    }

    public final void attributeType() throws RecognitionException, TokenStreamException {
        log.debug("entered attributeType()");
        Set<AttributeType> attributeTypeSet = null;
        this.match(25);
        int _cnt78 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt78 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt78;
        }
        attributeTypeSet = this.attributeTypeSet();
        this.protectedItemsMap.put("attributeType", new AttributeTypeItem(attributeTypeSet));
    }

    public final void allAttributeValues() throws RecognitionException, TokenStreamException {
        log.debug("entered allAttributeValues()");
        Set<AttributeType> attributeTypeSet = null;
        this.match(26);
        int _cnt81 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt81 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt81;
        }
        attributeTypeSet = this.attributeTypeSet();
        this.protectedItemsMap.put("allAttributeValues", new AllAttributeValuesItem(attributeTypeSet));
    }

    public final void allUserAttributeTypesAndValues() throws RecognitionException, TokenStreamException {
        log.debug("entered allUserAttributeTypesAndValues()");
        this.match(27);
        this.protectedItemsMap.put("allUserAttributeTypesAndValues", ProtectedItem.ALL_USER_ATTRIBUTE_TYPES_AND_VALUES);
    }

    public final void attributeValue() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered attributeValue()");
        String attributeTypeAndValue = null;
        String attributeType = null;
        String attributeValue = null;
        HashSet<Attribute> attributeSet = new HashSet<Attribute>();
        try {
            token = this.LT(1);
            this.match(4);
            Dn attributeTypeAndValueSetAsDn = new Dn(new String[]{token.getText()});
            if (this.schemaManager != null) {
                attributeTypeAndValueSetAsDn.apply(this.schemaManager);
            }
            for (Rdn rdn : attributeTypeAndValueSetAsDn) {
                attributeTypeAndValue = rdn.getNormName();
                attributeType = DnUtils.getRdnAttributeType((String)attributeTypeAndValue);
                attributeValue = DnUtils.getRdnValue((String)attributeTypeAndValue);
                attributeSet.add((Attribute)new DefaultAttribute(attributeType, new String[]{attributeValue}));
                log.debug("An attributeTypeAndValue from the set: " + attributeType + "=" + attributeValue);
            }
            this.protectedItemsMap.put("attributeValue", new AttributeValueItem(attributeSet));
        }
        catch (Exception e) {
            throw new RecognitionException("dnParser failed for " + token.getText() + " , " + e.getMessage());
        }
    }

    public final void selfValue() throws RecognitionException, TokenStreamException {
        log.debug("entered selfValue()");
        Set<AttributeType> attributeTypeSet = null;
        this.match(28);
        int _cnt86 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt86 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt86;
        }
        attributeTypeSet = this.attributeTypeSet();
        this.protectedItemsMap.put("sefValue", new SelfValueItem(attributeTypeSet));
    }

    public final void rangeOfValues() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered rangeOfValues()");
        try {
            token = this.LT(1);
            this.match(5);
            this.protectedItemsMap.put("rangeOfValues", new RangeOfValuesItem(FilterParser.parse((String)token.getText())));
            log.debug("filterParser parsed " + token.getText());
        }
        catch (Exception e) {
            throw new RecognitionException("filterParser failed. " + e.getMessage());
        }
    }

    public final void maxValueCount() throws RecognitionException, TokenStreamException {
        log.debug("entered maxValueCount()");
        MaxValueCountElem maxValueCount = null;
        HashSet<MaxValueCountElem> maxValueCountSet = new HashSet<MaxValueCountElem>();
        this.match(29);
        int _cnt90 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt90 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt90;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        maxValueCount = this.aMaxValueCount();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        maxValueCountSet.add(maxValueCount);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            maxValueCount = this.aMaxValueCount();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            maxValueCountSet.add(maxValueCount);
        }
        this.match(9);
        this.protectedItemsMap.put("maxValueCount", new MaxValueCountItem(maxValueCountSet));
    }

    public final void maxImmSub() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered maxImmSub()");
        this.match(32);
        int _cnt125 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt125 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt125;
        }
        token = this.LT(1);
        this.match(13);
        this.protectedItemsMap.put("maxImmSub", new MaxImmSubItem(this.token2Integer(token)));
    }

    public final void restrictedBy() throws RecognitionException, TokenStreamException {
        log.debug("entered restrictedBy()");
        RestrictedByElem restrictedValue = null;
        HashSet<RestrictedByElem> restrictedBy = new HashSet<RestrictedByElem>();
        this.match(33);
        int _cnt128 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt128 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt128;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        restrictedValue = this.restrictedValue();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        restrictedBy.add(restrictedValue);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            restrictedValue = this.restrictedValue();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            restrictedBy.add(restrictedValue);
        }
        this.match(9);
        this.protectedItemsMap.put("restrictedBy", new RestrictedByItem(restrictedBy));
    }

    public final void classes() throws RecognitionException, TokenStreamException {
        log.debug("entered classes()");
        ExprNode classes = null;
        this.match(35);
        int _cnt174 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt174 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt174;
        }
        classes = this.refinement();
        this.protectedItemsMap.put("classes", new ClassesItem(classes));
    }

    public final Set<AttributeType> attributeTypeSet() throws RecognitionException, TokenStreamException {
        log.debug("entered attributeTypeSet()");
        String oid = null;
        HashSet<AttributeType> attributeTypeSet = new HashSet<AttributeType>();
        AttributeType attributeType = null;
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        oid = this.oid();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        try {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
            attributeTypeSet.add(attributeType);
        }
        catch (LdapException le) {
            // empty catch block
        }
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            oid = this.oid();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            try {
                attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
                attributeTypeSet.add(attributeType);
            }
            catch (LdapException le) {}
        }
        this.match(9);
        return attributeTypeSet;
    }

    public final MaxValueCountElem aMaxValueCount() throws RecognitionException, TokenStreamException {
        Token token1 = null;
        Token token2 = null;
        log.debug("entered aMaxValueCount()");
        MaxValueCountElem maxValueCount = null;
        String oid = null;
        Token token = null;
        AttributeType attributeType = null;
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 30: {
                this.match(30);
                int _cnt106 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt106 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt106;
                }
                oid = this.oid();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(31);
                int _cnt112 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt112 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt112;
                }
                token1 = this.LT(1);
                this.match(13);
                token = token1;
                break;
            }
            case 31: {
                this.match(31);
                int _cnt114 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt114 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt114;
                }
                token2 = this.LT(1);
                this.match(13);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(30);
                int _cnt120 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt120 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt120;
                }
                oid = this.oid();
                token = token2;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(9);
        try {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
            maxValueCount = new MaxValueCountElem(attributeType, this.token2Integer(token));
        }
        catch (LdapException le) {
            // empty catch block
        }
        return maxValueCount;
    }

    public final String oid() throws RecognitionException, TokenStreamException {
        log.debug("entered oid()");
        String result = null;
        Token token = null;
        token = this.LT(1);
        switch (this.LA(1)) {
            case 78: {
                this.match(78);
                break;
            }
            case 79: {
                this.match(79);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        result = token.getText();
        log.debug("recognized an oid: " + result);
        return result;
    }

    public final RestrictedByElem restrictedValue() throws RecognitionException, TokenStreamException {
        log.debug("entered restrictedValue()");
        String typeOid = null;
        String valuesInOid = null;
        RestrictedByElem restrictedValue = null;
        AttributeType attributeType = null;
        AttributeType valueInAttributeType = null;
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 30: {
                this.match(30);
                int _cnt144 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt144 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt144;
                }
                typeOid = this.oid();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(34);
                int _cnt150 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt150 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt150;
                }
                valuesInOid = this.oid();
                break;
            }
            case 34: {
                this.match(34);
                int _cnt152 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt152 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt152;
                }
                valuesInOid = this.oid();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(8);
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                this.match(30);
                int _cnt158 = 0;
                while (true) {
                    if (this.LA(1) != 6) {
                        if (_cnt158 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(6);
                    ++_cnt158;
                }
                typeOid = this.oid();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(9);
        try {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry(typeOid);
            valueInAttributeType = this.schemaManager.lookupAttributeTypeRegistry(valuesInOid);
            restrictedValue = new RestrictedByElem(attributeType, valueInAttributeType);
        }
        catch (LdapException le) {
            // empty catch block
        }
        return restrictedValue;
    }

    public final ExprNode refinement() throws RecognitionException, TokenStreamException {
        log.debug("entered refinement()");
        LeafNode node = null;
        switch (this.LA(1)) {
            case 80: {
                node = this.item();
                break;
            }
            case 81: {
                node = this.and();
                break;
            }
            case 82: {
                node = this.or();
                break;
            }
            case 83: {
                node = this.not();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return node;
    }

    public final ItemPermission itemPermission() throws RecognitionException, TokenStreamException {
        log.debug("entered itemPermission()");
        ItemPermission itemPermission = null;
        this.itemPermissionComponentsMonitor = new MandatoryAndOptionalComponentsMonitor(new String[]{"userClasses", "grantsAndDenials"}, new String[]{"precedence"});
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.anyItemPermission();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            this.anyItemPermission();
            while (this.LA(1) == 6) {
                this.match(6);
            }
        }
        this.match(9);
        if (!this.itemPermissionComponentsMonitor.finalStateValid()) {
            throw new RecognitionException("Missing mandatory itemPermission components: " + this.itemPermissionComponentsMonitor.getRemainingComponents());
        }
        itemPermission = new ItemPermission(this.precedence, this.grantsAndDenials, this.userClasses);
        this.precedence = null;
        return itemPermission;
    }

    public final void anyItemPermission() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 12: {
                    this.precedence();
                    this.itemPermissionComponentsMonitor.useComponent("precedence");
                    break;
                }
                case 64: {
                    this.userClasses();
                    this.itemPermissionComponentsMonitor.useComponent("userClasses");
                    break;
                }
                case 37: {
                    this.grantsAndDenials();
                    this.itemPermissionComponentsMonitor.useComponent("grantsAndDenials");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void grantsAndDenials() throws RecognitionException, TokenStreamException {
        log.debug("entered grantsAndDenials()");
        this.grantsAndDenials = new HashSet<GrantAndDenial>();
        GrantAndDenial grantAndDenial = null;
        this.match(37);
        int _cnt203 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt203 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt203;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                grantAndDenial = this.grantAndDenial();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                if (!this.grantsAndDenials.add(grantAndDenial)) {
                    throw new RecognitionException("Duplicated GrantAndDenial bit: " + (Object)((Object)grantAndDenial));
                }
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    grantAndDenial = this.grantAndDenial();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    if (this.grantsAndDenials.add(grantAndDenial)) continue;
                    throw new RecognitionException("Duplicated GrantAndDenial bit: " + (Object)((Object)grantAndDenial));
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
    }

    public final GrantAndDenial grantAndDenial() throws RecognitionException, TokenStreamException {
        log.debug("entered grantAndDenialsBit()");
        GrantAndDenial l_grantAndDenial = null;
        switch (this.LA(1)) {
            case 38: {
                this.match(38);
                l_grantAndDenial = GrantAndDenial.GRANT_ADD;
                break;
            }
            case 39: {
                this.match(39);
                l_grantAndDenial = GrantAndDenial.DENY_ADD;
                break;
            }
            case 40: {
                this.match(40);
                l_grantAndDenial = GrantAndDenial.GRANT_DISCLOSE_ON_ERROR;
                break;
            }
            case 41: {
                this.match(41);
                l_grantAndDenial = GrantAndDenial.DENY_DISCLOSE_ON_ERROR;
                break;
            }
            case 42: {
                this.match(42);
                l_grantAndDenial = GrantAndDenial.GRANT_READ;
                break;
            }
            case 43: {
                this.match(43);
                l_grantAndDenial = GrantAndDenial.DENY_READ;
                break;
            }
            case 44: {
                this.match(44);
                l_grantAndDenial = GrantAndDenial.GRANT_REMOVE;
                break;
            }
            case 45: {
                this.match(45);
                l_grantAndDenial = GrantAndDenial.DENY_REMOVE;
                break;
            }
            case 46: {
                this.match(46);
                l_grantAndDenial = GrantAndDenial.GRANT_BROWSE;
                break;
            }
            case 47: {
                this.match(47);
                l_grantAndDenial = GrantAndDenial.DENY_BROWSE;
                break;
            }
            case 48: {
                this.match(48);
                l_grantAndDenial = GrantAndDenial.GRANT_EXPORT;
                break;
            }
            case 49: {
                this.match(49);
                l_grantAndDenial = GrantAndDenial.DENY_EXPORT;
                break;
            }
            case 50: {
                this.match(50);
                l_grantAndDenial = GrantAndDenial.GRANT_IMPORT;
                break;
            }
            case 51: {
                this.match(51);
                l_grantAndDenial = GrantAndDenial.DENY_IMPORT;
                break;
            }
            case 52: {
                this.match(52);
                l_grantAndDenial = GrantAndDenial.GRANT_MODIFY;
                break;
            }
            case 53: {
                this.match(53);
                l_grantAndDenial = GrantAndDenial.DENY_MODIFY;
                break;
            }
            case 54: {
                this.match(54);
                l_grantAndDenial = GrantAndDenial.GRANT_RENAME;
                break;
            }
            case 55: {
                this.match(55);
                l_grantAndDenial = GrantAndDenial.DENY_RENAME;
                break;
            }
            case 56: {
                this.match(56);
                l_grantAndDenial = GrantAndDenial.GRANT_RETURN_DN;
                break;
            }
            case 57: {
                this.match(57);
                l_grantAndDenial = GrantAndDenial.DENY_RETURN_DN;
                break;
            }
            case 58: {
                this.match(58);
                l_grantAndDenial = GrantAndDenial.GRANT_COMPARE;
                break;
            }
            case 59: {
                this.match(59);
                l_grantAndDenial = GrantAndDenial.DENY_COMPARE;
                break;
            }
            case 60: {
                this.match(60);
                l_grantAndDenial = GrantAndDenial.GRANT_FILTER_MATCH;
                break;
            }
            case 61: {
                this.match(61);
                l_grantAndDenial = GrantAndDenial.DENY_FILTER_MATCH;
                break;
            }
            case 62: {
                this.match(62);
                l_grantAndDenial = GrantAndDenial.GRANT_INVOKE;
                break;
            }
            case 63: {
                this.match(63);
                l_grantAndDenial = GrantAndDenial.DENY_INVOKE;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return l_grantAndDenial;
    }

    public final void userClass() throws RecognitionException, TokenStreamException {
        log.debug("entered userClasses()");
        switch (this.LA(1)) {
            case 65: {
                this.allUsers();
                break;
            }
            case 66: {
                this.thisEntry();
                break;
            }
            case 67: {
                this.parentOfEntry();
                break;
            }
            case 68: {
                this.name();
                break;
            }
            case 69: {
                this.userGroup();
                break;
            }
            case 70: {
                this.subtree();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void allUsers() throws RecognitionException, TokenStreamException {
        log.debug("entered allUsers()");
        this.match(65);
        this.userClassesMap.put("allUsers", UserClass.ALL_USERS);
    }

    public final void thisEntry() throws RecognitionException, TokenStreamException {
        log.debug("entered thisEntry()");
        this.match(66);
        this.userClassesMap.put("thisEntry", UserClass.THIS_ENTRY);
    }

    public final void parentOfEntry() throws RecognitionException, TokenStreamException {
        log.debug("entered parentOfEntry()");
        this.match(67);
        this.userClassesMap.put("parentOfEntry", UserClass.PARENT_OF_ENTRY);
    }

    public final void name() throws RecognitionException, TokenStreamException {
        log.debug("entered name()");
        HashSet<Dn> names = new HashSet<Dn>();
        Dn distinguishedName = null;
        this.match(68);
        int _cnt236 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt236 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt236;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        distinguishedName = this.distinguishedName();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        names.add(distinguishedName);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            distinguishedName = this.distinguishedName();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            names.add(distinguishedName);
        }
        this.match(9);
        this.userClassesMap.put("name", new UserClass.Name(names));
    }

    public final void userGroup() throws RecognitionException, TokenStreamException {
        log.debug("entered userGroup()");
        HashSet<Dn> userGroup = new HashSet<Dn>();
        Dn distinguishedName = null;
        this.match(69);
        int _cnt249 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt249 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt249;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        distinguishedName = this.distinguishedName();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        userGroup.add(distinguishedName);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            distinguishedName = this.distinguishedName();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            userGroup.add(distinguishedName);
        }
        this.match(9);
        this.userClassesMap.put("userGroup", new UserClass.UserGroup(userGroup));
    }

    public final void subtree() throws RecognitionException, TokenStreamException {
        log.debug("entered subtree()");
        HashSet<SubtreeSpecification> subtrees = new HashSet<SubtreeSpecification>();
        SubtreeSpecification subtreeSpecification = null;
        this.match(70);
        int _cnt262 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt262 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt262;
        }
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        subtreeSpecification = this.subtreeSpecification();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        subtrees.add(subtreeSpecification);
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            subtreeSpecification = this.subtreeSpecification();
            while (this.LA(1) == 6) {
                this.match(6);
            }
            subtrees.add(subtreeSpecification);
        }
        this.match(9);
        this.userClassesMap.put("subtree", new UserClass.Subtree(subtrees));
    }

    public final Dn distinguishedName() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered distinguishedName()");
        Dn name = null;
        try {
            token = this.LT(1);
            this.match(11);
            name = new Dn(new String[]{token.getText()});
            if (this.schemaManager != null) {
                name.apply(this.schemaManager);
            }
            log.debug("recognized a DistinguishedName: " + token.getText());
        }
        catch (Exception e) {
            throw new RecognitionException("dnParser failed for " + token.getText() + " " + e.getMessage());
        }
        return name;
    }

    public final SubtreeSpecification subtreeSpecification() throws RecognitionException, TokenStreamException {
        log.debug("entered subtreeSpecification()");
        SubtreeSpecification ss = null;
        this.ssModifier = new SubtreeSpecificationModifier();
        this.chopBeforeExclusions = new HashSet<Dn>();
        this.chopAfterExclusions = new HashSet<Dn>();
        this.subtreeSpecificationComponentsMonitor = new OptionalComponentsMonitor(new String[]{"base", "specificExclusions", "minimum", "maximum"});
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 72: 
            case 73: 
            case 76: 
            case 77: {
                this.subtreeSpecificationComponent();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.subtreeSpecificationComponent();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
        ss = this.ssModifier.getSubtreeSpecification();
        return ss;
    }

    public final UserPermission userPermission() throws RecognitionException, TokenStreamException {
        log.debug("entered userPermission()");
        UserPermission userPermission = null;
        this.userPermissionComponentsMonitor = new MandatoryAndOptionalComponentsMonitor(new String[]{"protectedItems", "grantsAndDenials"}, new String[]{"precedence"});
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.anyUserPermission();
        while (this.LA(1) == 6) {
            this.match(6);
        }
        while (this.LA(1) == 8) {
            this.match(8);
            while (this.LA(1) == 6) {
                this.match(6);
            }
            this.anyUserPermission();
            while (this.LA(1) == 6) {
                this.match(6);
            }
        }
        this.match(9);
        if (!this.userPermissionComponentsMonitor.finalStateValid()) {
            throw new RecognitionException("Missing mandatory userPermission components: " + this.userPermissionComponentsMonitor.getRemainingComponents());
        }
        userPermission = new UserPermission(this.precedence, this.grantsAndDenials, this.protectedItems);
        this.precedence = null;
        return userPermission;
    }

    public final void anyUserPermission() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 12: {
                    this.precedence();
                    this.userPermissionComponentsMonitor.useComponent("precedence");
                    break;
                }
                case 22: {
                    this.protectedItems();
                    this.userPermissionComponentsMonitor.useComponent("protectedItems");
                    break;
                }
                case 37: {
                    this.grantsAndDenials();
                    this.userPermissionComponentsMonitor.useComponent("grantsAndDenials");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
        log.debug("entered subtreeSpecification()");
        try {
            switch (this.LA(1)) {
                case 72: {
                    this.ss_base();
                    this.subtreeSpecificationComponentsMonitor.useComponent("base");
                    break;
                }
                case 73: {
                    this.ss_specificExclusions();
                    this.subtreeSpecificationComponentsMonitor.useComponent("specificExclusions");
                    break;
                }
                case 76: {
                    this.ss_minimum();
                    this.subtreeSpecificationComponentsMonitor.useComponent("minimum");
                    break;
                }
                case 77: {
                    this.ss_maximum();
                    this.subtreeSpecificationComponentsMonitor.useComponent("maximum");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void ss_base() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_base()");
        Dn base = null;
        this.match(72);
        int _cnt314 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt314 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt314;
        }
        base = this.distinguishedName();
        this.ssModifier.setBase(base);
    }

    public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_specificExclusions()");
        this.match(73);
        int _cnt317 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt317 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt317;
        }
        this.specificExclusions();
        this.ssModifier.setChopBeforeExclusions(this.chopBeforeExclusions);
        this.ssModifier.setChopAfterExclusions(this.chopAfterExclusions);
    }

    public final void ss_minimum() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_minimum()");
        int minimum = 0;
        this.match(76);
        int _cnt343 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt343 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt343;
        }
        minimum = this.baseDistance();
        this.ssModifier.setMinBaseDistance(minimum);
    }

    public final void ss_maximum() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_maximum()");
        int maximum = 0;
        this.match(77);
        int _cnt346 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt346 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt346;
        }
        maximum = this.baseDistance();
        this.ssModifier.setMaxBaseDistance(maximum);
    }

    public final void specificExclusions() throws RecognitionException, TokenStreamException {
        log.debug("entered specificExclusions()");
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 74: 
            case 75: {
                this.specificExclusion();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.specificExclusion();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
    }

    public final void specificExclusion() throws RecognitionException, TokenStreamException {
        log.debug("entered specificExclusion()");
        switch (this.LA(1)) {
            case 74: {
                this.chopBefore();
                break;
            }
            case 75: {
                this.chopAfter();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void chopBefore() throws RecognitionException, TokenStreamException {
        log.debug("entered chopBefore()");
        Dn chopBeforeExclusion = null;
        this.match(74);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        chopBeforeExclusion = this.distinguishedName();
        this.chopBeforeExclusions.add(chopBeforeExclusion);
    }

    public final void chopAfter() throws RecognitionException, TokenStreamException {
        log.debug("entered chopAfter()");
        Dn chopAfterExclusion = null;
        this.match(75);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        chopAfterExclusion = this.distinguishedName();
        this.chopAfterExclusions.add(chopAfterExclusion);
    }

    public final int baseDistance() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered baseDistance()");
        int distance = 0;
        token = this.LT(1);
        this.match(13);
        distance = this.token2Integer(token);
        return distance;
    }

    public final LeafNode item() throws RecognitionException, TokenStreamException {
        log.debug("entered item()");
        EqualityNode node = null;
        String oid = null;
        this.match(80);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        oid = this.oid();
        node = new EqualityNode("objectClass", (Value)new StringValue(oid));
        return node;
    }

    public final BranchNode and() throws RecognitionException, TokenStreamException {
        log.debug("entered and()");
        AndNode node = null;
        List<ExprNode> children = null;
        this.match(81);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new AndNode(children);
        return node;
    }

    public final BranchNode or() throws RecognitionException, TokenStreamException {
        log.debug("entered or()");
        OrNode node = null;
        List<ExprNode> children = null;
        this.match(82);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new OrNode(children);
        return node;
    }

    public final BranchNode not() throws RecognitionException, TokenStreamException {
        log.debug("entered not()");
        NotNode node = null;
        List<ExprNode> children = null;
        this.match(83);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(20);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new NotNode(children);
        return node;
    }

    public final List<ExprNode> refinements() throws RecognitionException, TokenStreamException {
        log.debug("entered refinements()");
        ArrayList<ExprNode> children = null;
        ExprNode child = null;
        ArrayList<ExprNode> tempChildren = new ArrayList<ExprNode>();
        this.match(7);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                child = this.refinement();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                tempChildren.add(child);
                while (this.LA(1) == 8) {
                    this.match(8);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    child = this.refinement();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    tempChildren.add(child);
                }
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
        children = tempChildren;
        return children;
    }
}

