/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wsdl2java;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.AbstractCodegenMoho;
import org.apache.cxf.maven_plugin.GenericWsdlOption;
import org.apache.cxf.maven_plugin.wsdl2java.ForkOnceWSDL2Java;
import org.apache.cxf.maven_plugin.wsdl2java.Option;
import org.apache.cxf.maven_plugin.wsdl2java.WsdlOption;
import org.apache.cxf.maven_plugin.wsdl2java.WsdlOptionLoader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolErrorListener;
import org.apache.cxf.tools.util.OutputStreamCreator;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2JavaMojo
extends AbstractCodegenMoho {
    File testSourceRoot;
    File sourceRoot;
    WsdlOption[] wsdlOptions;
    Option defaultOptions = new Option();
    String encoding;

    protected void mergeOptions(List<GenericWsdlOption> effectiveWsdlOptions) {
        File outputDirFile = this.getGeneratedTestRoot() == null ? this.getGeneratedSourceRoot() : this.getGeneratedTestRoot();
        ArrayList<WsdlOption> newList = new ArrayList<WsdlOption>();
        for (GenericWsdlOption go : effectiveWsdlOptions) {
            File file;
            WsdlOption o = (WsdlOption)go;
            if (this.defaultOptions != null) {
                o.merge(this.defaultOptions);
            }
            if (o.getOutputDir() == null) {
                o.setOutputDir(outputDirFile);
            }
            if ((file = o.getWsdlFile(this.project.getBasedir())) != null && file.exists()) {
                file = file.getAbsoluteFile();
                boolean duplicate = false;
                for (GenericWsdlOption genericWsdlOption : newList) {
                    WsdlOption o2 = (WsdlOption)genericWsdlOption;
                    File file2 = o2.getWsdlFile(this.project.getBasedir());
                    if (file2 == null || !file2.exists() || !file2.getAbsoluteFile().equals(file)) continue;
                    o2.getExtraargs().addAll(0, o.getExtraargs());
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                newList.add(o);
                continue;
            }
            newList.add(o);
        }
        effectiveWsdlOptions.clear();
        effectiveWsdlOptions.addAll(newList);
    }

    @Override
    protected boolean shouldRun(GenericWsdlOption genericWsdlOption, File doneFile, URI wsdlURI) {
        WsdlOption wsdlOption = (WsdlOption)genericWsdlOption;
        long timestamp = 0L;
        if ("file".equals(wsdlURI.getScheme())) {
            timestamp = new File(wsdlURI).lastModified();
        } else {
            try {
                timestamp = wsdlURI.toURL().openConnection().getDate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean doWork = false;
        if (!doneFile.exists()) {
            doWork = true;
        } else if (timestamp > doneFile.lastModified()) {
            doWork = true;
        } else if (wsdlOption.isDefServiceName()) {
            doWork = true;
        } else {
            File[] files = wsdlOption.getDependencies();
            if (files != null) {
                for (int z = 0; z < files.length; ++z) {
                    if (files[z].lastModified() <= doneFile.lastModified()) continue;
                    doWork = true;
                }
            }
        }
        return doWork;
    }

    @Override
    protected List<String> generateCommandLine(GenericWsdlOption wsdlOption) throws MojoExecutionException {
        List<String> ret = super.generateCommandLine(wsdlOption);
        if (this.encoding != null) {
            ret.add(0, "-encoding");
            ret.add(1, this.encoding);
        }
        return ret;
    }

    @Override
    protected Bus generate(GenericWsdlOption genericWsdlOption, Bus bus, Set<URI> classPath) throws MojoExecutionException {
        WsdlOption wsdlOption = (WsdlOption)genericWsdlOption;
        File outputDirFile = wsdlOption.getOutputDir();
        outputDirFile.mkdirs();
        URI basedir = this.project.getBasedir().toURI();
        URI wsdlURI = wsdlOption.getWsdlURI(basedir);
        File doneFile = this.getDoneFile(basedir, wsdlURI, "java");
        if (!this.shouldRun(wsdlOption, doneFile, wsdlURI)) {
            return bus;
        }
        doneFile.delete();
        try {
            File file = new File(wsdlURI);
            if (file.exists()) {
                this.buildContext.removeMessages(file);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (wsdlOption.getDependencies() != null) {
            for (File f : wsdlOption.getDependencies()) {
                this.buildContext.removeMessages(f);
            }
        }
        List<String> list = wsdlOption.generateCommandLine(outputDirFile, basedir, wsdlURI, this.getLog().isDebugEnabled());
        if (this.encoding != null) {
            list.add(0, "-encoding");
            list.add(1, this.encoding);
        }
        Object[] args = list.toArray(new String[list.size()]);
        this.getLog().debug((CharSequence)("Calling wsdl2java with args: " + Arrays.toString(args)));
        if (!"false".equals(this.fork)) {
            LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
            for (Artifact a : this.pluginArtifacts) {
                File file = a.getFile();
                if (file == null) {
                    throw new MojoExecutionException("Unable to find " + file + " for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
                }
                artifactsPath.add(file.toURI());
            }
            this.addPluginArtifact(artifactsPath);
            artifactsPath.addAll(classPath);
            this.runForked(artifactsPath, WSDLToJava.class.getName(), (String[])args);
        } else {
            if (bus == null) {
                bus = BusFactory.newInstance().createBus();
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
            try {
                ToolContext ctx = new ToolContext();
                final ArrayList files = new ArrayList();
                final ArrayList errorfiles = new ArrayList();
                ctx.put(OutputStreamCreator.class, (Object)new OutputStreamCreator(){

                    public OutputStream createOutputStream(File file) throws IOException {
                        files.add(file);
                        return WSDL2JavaMojo.this.buildContext.newFileOutputStream(file);
                    }
                });
                ctx.setErrorListener(new ToolErrorListener(){

                    public void addError(File file, int line, int column, String message, Throwable t) {
                        super.addError(file, line, column, message, t);
                        if (!errorfiles.contains(file)) {
                            WSDL2JavaMojo.this.buildContext.removeMessages(file);
                            errorfiles.add(file);
                        }
                        WSDL2JavaMojo.this.buildContext.addMessage(file, line, column, message, 2, t);
                    }

                    public void addWarning(File file, int line, int column, String message, Throwable t) {
                        if (!errorfiles.contains(file)) {
                            WSDL2JavaMojo.this.buildContext.removeMessages(file);
                            errorfiles.add(file);
                        }
                        WSDL2JavaMojo.this.buildContext.addMessage(file, line, column, message, 1, t);
                    }
                });
                new WSDLToJava((String[])args).run(ctx);
                List oldFiles = CastUtils.cast((List)((List)this.buildContext.getValue("cxf.file.list." + doneFile.getName())));
                if (oldFiles != null) {
                    for (File f : oldFiles) {
                        if (files.contains(f)) continue;
                        f.delete();
                        this.buildContext.refresh(f);
                    }
                }
                this.buildContext.setValue("cxf.file.list." + doneFile.getName(), files);
            }
            catch (Throwable e) {
                this.buildContext.setValue("cxf.file.list." + doneFile.getName(), null);
                this.getLog().debug(e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        try {
            doneFile.createNewFile();
            this.buildContext.refresh(doneFile);
        }
        catch (Throwable e) {
            this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
            this.getLog().debug(e);
            throw new MojoExecutionException("Failed to create marker file " + doneFile.getAbsolutePath());
        }
        if (this.project != null && this.getGeneratedSourceRoot() != null && this.getGeneratedSourceRoot().exists()) {
            this.project.addCompileSourceRoot(this.getGeneratedSourceRoot().getAbsolutePath());
            this.buildContext.refresh(this.getGeneratedSourceRoot().getAbsoluteFile());
        }
        if (this.project != null && this.getGeneratedTestRoot() != null && this.getGeneratedTestRoot().exists()) {
            this.project.addTestCompileSourceRoot(this.getGeneratedTestRoot().getAbsolutePath());
            this.buildContext.refresh(this.getGeneratedTestRoot().getAbsoluteFile());
        }
        return bus;
    }

    @Override
    protected List<GenericWsdlOption> createWsdlOptionsFromScansAndExplicitWsdlOptions() throws MojoExecutionException {
        List<GenericWsdlOption> temp;
        ArrayList<GenericWsdlOption> effectiveWsdlOptions = new ArrayList<GenericWsdlOption>();
        if (this.wsdlOptions != null) {
            for (WsdlOption wo : this.wsdlOptions) {
                effectiveWsdlOptions.add(wo);
            }
        }
        if (this.wsdlRoot != null && this.wsdlRoot.exists() && !this.disableDirectoryScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromFiles(this.wsdlRoot, this.includes, this.excludes, this.getGeneratedSourceRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        if (this.testWsdlRoot != null && this.testWsdlRoot.exists() && !this.disableDirectoryScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromFiles(this.testWsdlRoot, this.includes, this.excludes, this.getGeneratedTestRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        if (!this.disableDependencyScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromDependencies(this.project, this.getGeneratedSourceRoot());
            effectiveWsdlOptions.addAll(temp);
        }
        this.mergeOptions(effectiveWsdlOptions);
        this.downloadRemoteWsdls(effectiveWsdlOptions);
        return effectiveWsdlOptions;
    }

    @Override
    protected File getGeneratedSourceRoot() {
        return this.sourceRoot;
    }

    @Override
    protected File getGeneratedTestRoot() {
        return this.testSourceRoot;
    }

    @Override
    protected Class<?> getForkClass() {
        return ForkOnceWSDL2Java.class;
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.defaultOptions.addDefaultBindingFileIfExists(this.project.getBasedir());
        super.execute();
    }

    @Override
    protected String getMarkerSuffix() {
        return "java";
    }
}

