/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.HasId;
import org.apache.camel.web.util.UriCharactersEncoder;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EndpointLink {
    @XmlAttribute
    private String uri;
    @XmlAttribute
    private String href;

    public EndpointLink() {
    }

    public EndpointLink(Endpoint endpoint) {
        this();
        this.load(endpoint);
    }

    public EndpointLink(String key, Endpoint endpoint) {
        this();
        this.load(key, endpoint);
    }

    public String toString() {
        return "EndpointLink{href='" + this.href + "' uri='" + this.uri + "'}";
    }

    public void load(Endpoint endpoint) {
        this.uri = endpoint.getEndpointUri();
        this.href = this.createHref(this.uri, endpoint);
    }

    public void load(String key, Endpoint endpoint) {
        this.uri = endpoint.getEndpointUri();
        this.href = this.createHref(key, endpoint);
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    protected String createHref(String uri, Endpoint endpoint) {
        if (endpoint instanceof HasId) {
            HasId hasId = (HasId)endpoint;
            String id = hasId.getId();
            return "/endpoints/" + id;
        }
        return "/endpoints/" + UriCharactersEncoder.encode((String)uri);
    }
}

