/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.mapreduce;

import com.hadoop.compression.lzo.LzoIndex;
import com.hadoop.compression.lzo.LzopCodec;
import com.hadoop.mapreduce.LzoLineRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LzoTextInputFormat
extends FileInputFormat<LongWritable, Text> {
    private final Map<Path, LzoIndex> indexes = new HashMap<Path, LzoIndex>();

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        List files = super.listStatus(job);
        String fileExtension = new LzopCodec().getDefaultExtension();
        Configuration conf = job.getConfiguration();
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            FileStatus fileStatus = (FileStatus)iterator.next();
            Path file = fileStatus.getPath();
            FileSystem fs = file.getFileSystem(conf);
            if (!file.toString().endsWith(fileExtension)) {
                iterator.remove();
                continue;
            }
            LzoIndex index = LzoIndex.readIndex(fs, file);
            this.indexes.put(file, index);
        }
        return files;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        LzoIndex index = this.indexes.get(filename);
        return !index.isEmpty();
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List splits = super.getSplits(job);
        Configuration conf = job.getConfiguration();
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        for (InputSplit genericSplit : splits) {
            FileSplit fileSplit = (FileSplit)genericSplit;
            Path file = fileSplit.getPath();
            FileSystem fs = file.getFileSystem(conf);
            LzoIndex index = this.indexes.get(file);
            if (index == null) {
                throw new IOException("Index not found for " + file);
            }
            if (index.isEmpty()) {
                result.add((InputSplit)fileSplit);
                continue;
            }
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            long lzoStart = index.alignSliceStartToIndex(start, end);
            long lzoEnd = index.alignSliceEndToIndex(end, fs.getFileStatus(file).getLen());
            if (lzoStart == -1L || lzoEnd == -1L) continue;
            result.add((InputSplit)new FileSplit(file, lzoStart, lzoEnd - lzoStart, fileSplit.getLocations()));
        }
        return result;
    }

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext taskAttempt) throws IOException, InterruptedException {
        return new LzoLineRecordReader();
    }
}

