/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.DefaultSitemeshBuffer;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.SitemeshBuffer;
import com.opensymphony.module.sitemesh.SitemeshBufferWriter;
import com.opensymphony.module.sitemesh.filter.SitemeshPrintWriter;
import com.opensymphony.module.sitemesh.filter.TextEncoder;
import com.opensymphony.module.sitemesh.util.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;

public class Buffer {
    private final PageParser pageParser;
    private final String encoding;
    private static final TextEncoder TEXT_ENCODER = new TextEncoder();
    private SitemeshBufferWriter bufferedWriter;
    private FastByteArrayOutputStream bufferedStream;
    private PrintWriter exposedWriter;
    private ServletOutputStream exposedStream;

    public Buffer(PageParser pageParser, String encoding) {
        this.pageParser = pageParser;
        this.encoding = encoding;
    }

    public SitemeshBuffer getContents() throws IOException {
        if (this.bufferedWriter != null) {
            return this.bufferedWriter.getSitemeshBuffer();
        }
        if (this.bufferedStream != null) {
            return new DefaultSitemeshBuffer(TEXT_ENCODER.encode(this.bufferedStream.toByteArray(), this.encoding));
        }
        return new DefaultSitemeshBuffer(new char[0]);
    }

    public Page parse() throws IOException {
        return this.pageParser.parse(this.getContents());
    }

    public PrintWriter getWriter() {
        if (this.bufferedWriter == null) {
            if (this.bufferedStream != null) {
                throw new IllegalStateException("response.getWriter() called after response.getOutputStream()");
            }
            this.bufferedWriter = new SitemeshBufferWriter(128);
            this.exposedWriter = new SitemeshPrintWriter(this.bufferedWriter);
        }
        return this.exposedWriter;
    }

    public ServletOutputStream getOutputStream() {
        if (this.bufferedStream == null) {
            if (this.bufferedWriter != null) {
                throw new IllegalStateException("response.getOutputStream() called after response.getWriter()");
            }
            this.bufferedStream = new FastByteArrayOutputStream();
            this.exposedStream = new ServletOutputStream(){

                public void write(int b) {
                    Buffer.this.bufferedStream.write(b);
                }
            };
        }
        return this.exposedStream;
    }

    public boolean isUsingStream() {
        return this.bufferedStream != null;
    }
}

