/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.ejb3;

import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.ejb3.EJBPropertySet;
import com.opensymphony.module.propertyset.ejb3.EntryPK;
import com.opensymphony.module.propertyset.ejb3.PropertyEntry;
import com.opensymphony.util.Data;
import com.opensymphony.util.XMLUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.w3c.dom.Document;

@Stateful(name="OSPropertySet")
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class EJBPropertySetImpl
extends AbstractPropertySet
implements EJBPropertySet {
    private EntityManager entityManager;
    private Long entityId;
    private PersistenceUnitTransactionType transactionType;
    private String entityName;
    private boolean inContainer;
    @PersistenceContext(unitName="propertyset")
    private EntityManager injectedEntityManager;

    public EJBPropertySetImpl() {
    }

    public EJBPropertySetImpl(EntityManager entityManager, PersistenceUnitTransactionType transactionType) {
        this.entityManager = entityManager;
        this.transactionType = transactionType;
    }

    public EJBPropertySetImpl(EntityManager entityManager, PersistenceUnitTransactionType transactionType, Long entityId, String entityName) {
        this.entityManager = entityManager;
        this.entityId = entityId;
        this.entityName = entityName;
        this.transactionType = transactionType;
    }

    @PostConstruct
    public void checkInjection() {
        this.entityManager = this.injectedEntityManager;
        this.inContainer = true;
    }

    @Remove
    public void destroy() {
        this.entityManager = null;
        this.injectedEntityManager = null;
        this.entityId = null;
        this.entityName = null;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void clear() {
        this.entityManager.clear();
    }

    @TransactionAttribute
    public Collection getKeys() throws PropertyException {
        return super.getKeys();
    }

    @TransactionAttribute
    public Collection getKeys(int type) throws PropertyException {
        return super.getKeys(type);
    }

    @TransactionAttribute
    public Collection getKeys(String prefix) throws PropertyException {
        return super.getKeys(prefix);
    }

    @TransactionAttribute
    public Collection getKeys(String prefix, int type) throws PropertyException {
        return this.getKeys(this.entityName, this.entityId, prefix, type);
    }

    @TransactionAttribute
    public Collection getKeys(String entityName, long entityId, String prefix, int type) throws PropertyException {
        Query q;
        if (type == 0 && prefix == null) {
            q = this.entityManager.createNamedQuery("keys");
        } else if (type == 0 && prefix != null) {
            q = this.entityManager.createNamedQuery("keys.prefix");
            q.setParameter("prefix", (Object)(prefix + '%'));
        } else if (prefix == null && type != 0) {
            q = this.entityManager.createNamedQuery("keys.type");
            q.setParameter("type", (Object)type);
        } else {
            q = this.entityManager.createNamedQuery("keys.prefixAndType");
            q.setParameter("prefix", (Object)(prefix + '%'));
            q.setParameter("type", (Object)type);
        }
        q.setParameter("entityId", (Object)entityId);
        q.setParameter("entityName", (Object)entityName);
        return q.getResultList();
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public int getType(String key) throws PropertyException {
        return this.getType(this.entityName, this.entityId, key);
    }

    @TransactionAttribute
    public int getType(String entityName, long entityId, String key) throws PropertyException {
        EntryPK pk = new EntryPK(entityName, entityId, key);
        PropertyEntry entry = (PropertyEntry)this.entityManager.find(PropertyEntry.class, (Object)pk);
        if (entry == null) {
            return 0;
        }
        return entry.getType();
    }

    public boolean exists(String key) throws PropertyException {
        return this.exists(this.entityName, this.entityId, key);
    }

    @TransactionAttribute
    public boolean exists(String entityName, long entityId, String key) throws PropertyException {
        EntryPK pk = new EntryPK(entityName, entityId, key);
        PropertyEntry entry = (PropertyEntry)this.entityManager.find(PropertyEntry.class, (Object)pk);
        return entry != null;
    }

    public void init(Map config, Map args) {
        Object obj = args.get("manager");
        if (obj == null) {
            throw new IllegalArgumentException("no manager argument specified");
        }
        if (!(obj instanceof EntityManager)) {
            throw new IllegalArgumentException("factory specifies is of type '" + obj.getClass() + "' which does not implement " + EntityManager.class.getName());
        }
        this.entityManager = (EntityManager)obj;
        this.entityId = ((Number)args.get("entityId")).longValue();
        this.entityName = (String)args.get("entityName");
        Object tx = args.get("transaction");
        this.transactionType = tx == null ? PersistenceUnitTransactionType.RESOURCE_LOCAL : PersistenceUnitTransactionType.valueOf((String)tx.toString());
    }

    @TransactionAttribute
    public void remove(String key) throws PropertyException {
        this.remove(this.entityName, this.entityId, key);
    }

    @TransactionAttribute
    public void remove() throws PropertyException {
        this.remove(this.entityName, this.entityId);
    }

    @TransactionAttribute
    public void remove(String entityName, long entityId, String key) throws PropertyException {
        EntryPK pk = new EntryPK(entityName, entityId, key);
        PropertyEntry entry = (PropertyEntry)this.entityManager.find(PropertyEntry.class, (Object)pk);
        if (entry != null) {
            this.entityManager.remove((Object)entry);
        }
    }

    @TransactionAttribute
    public void remove(String entityName, long entityId) throws PropertyException {
        boolean mustCommit = this.joinTransaction();
        Query q = this.entityManager.createNamedQuery("entries");
        q.setParameter("entityId", (Object)entityId);
        q.setParameter("entityName", (Object)entityName);
        List l = q.getResultList();
        for (Object o : l) {
            this.entityManager.remove(o);
        }
        if (mustCommit) {
            this.entityManager.getTransaction().commit();
        }
    }

    public boolean supportsType(int type) {
        return type != 11;
    }

    @TransactionAttribute
    protected void setImpl(int type, String key, Object value) throws PropertyException {
        this.setImpl(this.entityName, this.entityId, type, key, value);
    }

    @TransactionAttribute
    protected void setImpl(String entityName, long entityId, int type, String key, Object value) throws PropertyException {
        EntryPK pk = new EntryPK(entityName, entityId, key);
        boolean mustCommit = this.joinTransaction();
        PropertyEntry item = (PropertyEntry)this.entityManager.find(PropertyEntry.class, (Object)pk);
        if (item == null) {
            item = new PropertyEntry();
            item.setPrimaryKey(pk);
            item.setType(type);
        } else if (item.getType() != type) {
            throw new PropertyException("Existing key '" + key + "' does not have matching type of " + this.type(type));
        }
        switch (type) {
            case 1: {
                item.setBoolValue((Boolean)value);
                break;
            }
            case 2: {
                item.setIntValue(((Number)value).intValue());
                break;
            }
            case 3: {
                item.setLongValue(((Number)value).longValue());
                break;
            }
            case 4: {
                item.setDoubleValue(((Number)value).doubleValue());
                break;
            }
            case 5: {
                item.setStringValue((String)value);
                break;
            }
            case 6: {
                item.setTextValue((String)value);
                break;
            }
            case 7: {
                item.setDateValue((Date)value);
            }
            case 8: {
                item.setSerialized((Serializable)value);
                break;
            }
            case 10: {
                if (value instanceof Data) {
                    item.setData(((Data)value).getBytes());
                    break;
                }
                item.setData((byte[])value);
                break;
            }
            case 9: {
                String text = this.writeXML((Document)value);
                item.setTextValue(text);
                break;
            }
            default: {
                throw new PropertyException("type " + type + " not supported");
            }
        }
        this.entityManager.merge((Object)item);
        if (mustCommit) {
            this.entityManager.getTransaction().commit();
        }
    }

    @TransactionAttribute
    public void setAsActualType(String key, Object value) throws PropertyException {
        super.setAsActualType(key, value);
    }

    @TransactionAttribute
    public void setBoolean(String key, boolean value) {
        super.setBoolean(key, value);
    }

    @TransactionAttribute
    public void setDate(String key, Date value) {
        super.setDate(key, value);
    }

    @TransactionAttribute
    public void setData(String key, byte[] value) {
        super.setData(key, value);
    }

    @TransactionAttribute
    public void setDouble(String key, double value) {
        super.setDouble(key, value);
    }

    @TransactionAttribute
    public void setInt(String key, int value) {
        super.setInt(key, value);
    }

    @TransactionAttribute
    public void setLong(String key, long value) {
        super.setLong(key, value);
    }

    @TransactionAttribute
    public void setObject(String key, Object value) {
        super.setObject(key, value);
    }

    @TransactionAttribute
    public void setProperties(String key, Properties value) {
        super.setProperties(key, value);
    }

    @TransactionAttribute
    public void setText(String key, String value) {
        super.setText(key, value);
    }

    @TransactionAttribute
    public void setString(String key, String value) {
        super.setString(key, value);
    }

    @TransactionAttribute
    public void setXML(String key, Document value) {
        super.setXML(key, value);
    }

    protected Object get(int type, String key) throws PropertyException {
        return this.get(this.entityName, this.entityId, type, key);
    }

    @TransactionAttribute
    protected Object get(String entityName, long entityId, int type, String key) throws PropertyException {
        EntryPK pk = new EntryPK(entityName, entityId, key);
        PropertyEntry entry = (PropertyEntry)this.entityManager.find(PropertyEntry.class, (Object)pk);
        if (entry == null) {
            return null;
        }
        if (entry.getType() != type) {
            throw new PropertyException("key '" + key + "' does not have matching type of " + this.type(type) + ", but is of type " + this.type(entry.getType()));
        }
        switch (type) {
            case 1: {
                return entry.getBoolValue();
            }
            case 4: {
                return entry.getDoubleValue();
            }
            case 5: {
                return entry.getStringValue();
            }
            case 6: {
                return entry.getTextValue();
            }
            case 3: {
                return entry.getLongValue();
            }
            case 2: {
                return entry.getIntValue();
            }
            case 7: {
                return entry.getDateValue();
            }
            case 8: {
                return entry.getSerialized();
            }
            case 10: {
                return entry.getData();
            }
            case 9: {
                return this.readXML(entry.getTextValue());
            }
        }
        throw new PropertyException("type " + this.type(type) + " not supported");
    }

    private boolean joinTransaction() {
        if (this.inContainer) {
            return false;
        }
        boolean mustCommit = false;
        switch (this.transactionType) {
            case JTA: {
                this.entityManager.joinTransaction();
                break;
            }
            case RESOURCE_LOCAL: {
                EntityTransaction tx = this.entityManager.getTransaction();
                if (tx.isActive()) break;
                tx.begin();
                mustCommit = true;
            }
        }
        return mustCommit;
    }

    private Document readXML(String data) {
        try {
            return XMLUtils.parse((String)data);
        }
        catch (Exception e) {
            throw new PropertyImplementationException("Cannot parse XML data", e);
        }
    }

    private String writeXML(Document doc) {
        try {
            return XMLUtils.print((Document)doc);
        }
        catch (IOException e) {
            throw new PropertyImplementationException("Cannot serialize XML", e);
        }
    }

    public String toString() {
        return "EJBPropertySetImpl#" + this.hashCode() + "{entityManager=" + this.entityManager + ", entityId=" + this.entityId + ", entityName='" + this.entityName + '\'' + ", inContainer=" + this.inContainer + '}';
    }
}

