/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.database;

import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.InvalidPropertyTypeException;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.util.Data;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCPropertySet
extends AbstractPropertySet {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$module$propertyset$database$JDBCPropertySet == null ? (class$com$opensymphony$module$propertyset$database$JDBCPropertySet = JDBCPropertySet.class$("com.opensymphony.module.propertyset.database.JDBCPropertySet")) : class$com$opensymphony$module$propertyset$database$JDBCPropertySet));
    protected DataSource ds;
    protected String colData;
    protected String colDate;
    protected String colFloat;
    protected String colGlobalKey;
    protected String colItemKey;
    protected String colItemType;
    protected String colNumber;
    protected String colString;
    protected String globalKey;
    protected String tableName;
    protected boolean closeConnWhenDone = false;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$database$JDBCPropertySet;

    public Collection getKeys(String prefix, int type) throws PropertyException {
        if (prefix == null) {
            prefix = "";
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.colItemKey + " FROM " + this.tableName + " WHERE " + this.colItemKey + " LIKE ? AND " + this.colGlobalKey + " = ?";
            if (type == 0) {
                ps = conn.prepareStatement(sql);
                ps.setString(1, prefix + "%");
                ps.setString(2, this.globalKey);
            } else {
                sql = sql + " AND " + this.colItemType + " = ?";
                ps = conn.prepareStatement(sql);
                ps.setString(1, prefix + "%");
                ps.setString(2, this.globalKey);
                ps.setInt(3, type);
            }
            ArrayList<String> list = new ArrayList<String>();
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(this.colItemKey));
            }
            ArrayList<String> arrayList = list;
            this.cleanup(conn, ps, rs);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new PropertyException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn, ps, rs);
                throw throwable;
            }
        }
    }

    public int getType(String key) throws PropertyException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.colItemType + " FROM " + this.tableName + " WHERE " + this.colGlobalKey + " = ? AND " + this.colItemKey + " = ?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, this.globalKey);
            ps.setString(2, key);
            rs = ps.executeQuery();
            int type = 0;
            if (rs.next()) {
                type = rs.getInt(this.colItemType);
            }
            int n = type;
            this.cleanup(conn, ps, rs);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new PropertyException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn, ps, rs);
                throw throwable;
            }
        }
    }

    public boolean exists(String key) throws PropertyException {
        return this.getType(key) != 0;
    }

    public void init(Map config, Map args) {
        this.globalKey = (String)args.get("globalKey");
        String jndi = (String)config.get("datasource");
        if (jndi != null) {
            try {
                this.ds = (DataSource)this.lookup(jndi);
                if (this.ds == null) {
                    this.ds = (DataSource)new InitialContext().lookup(jndi);
                }
            }
            catch (Exception e) {
                log.fatal((Object)("Error looking up DataSource at " + jndi), (Throwable)e);
                return;
            }
        }
        this.tableName = (String)config.get("table.name");
        this.colGlobalKey = (String)config.get("col.globalKey");
        this.colItemKey = (String)config.get("col.itemKey");
        this.colItemType = (String)config.get("col.itemType");
        this.colString = (String)config.get("col.string");
        this.colDate = (String)config.get("col.date");
        this.colData = (String)config.get("col.data");
        this.colFloat = (String)config.get("col.float");
        this.colNumber = (String)config.get("col.number");
    }

    public void remove() throws PropertyException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            String sql = "DELETE FROM " + this.tableName + " WHERE " + this.colGlobalKey + " = ?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, this.globalKey);
            ps.executeUpdate();
            this.cleanup(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                throw new PropertyException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn, ps, null);
                throw throwable;
            }
        }
    }

    public void remove(String key) throws PropertyException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            String sql = "DELETE FROM " + this.tableName + " WHERE " + this.colGlobalKey + " = ? AND " + this.colItemKey + " = ?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, this.globalKey);
            ps.setString(2, key);
            ps.executeUpdate();
            this.cleanup(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                throw new PropertyException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn, ps, null);
                throw throwable;
            }
        }
    }

    public boolean supportsType(int type) {
        switch (type) {
            case 6: 
            case 9: 
            case 11: {
                return false;
            }
        }
        return true;
    }

    protected Connection getConnection() throws SQLException {
        this.closeConnWhenDone = true;
        return this.ds.getConnection();
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        if (value == null) {
            throw new PropertyException("JDBCPropertySet does not allow for null values to be stored");
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            String sql = "UPDATE " + this.tableName + " SET " + this.colString + " = ?, " + this.colDate + " = ?, " + this.colData + " = ?, " + this.colFloat + " = ?, " + this.colNumber + " = ?, " + this.colItemType + " = ? " + " WHERE " + this.colGlobalKey + " = ? AND " + this.colItemKey + " = ?";
            ps = conn.prepareStatement(sql);
            this.setValues(ps, type, key, value);
            int rows = ps.executeUpdate();
            if (rows != 1) {
                sql = "INSERT INTO " + this.tableName + " (" + this.colString + ", " + this.colDate + ", " + this.colData + ", " + this.colFloat + ", " + this.colNumber + ", " + this.colItemType + ", " + this.colGlobalKey + ", " + this.colItemKey + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                ps.close();
                ps = conn.prepareStatement(sql);
                this.setValues(ps, type, key, value);
                ps.executeUpdate();
            }
            this.cleanup(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                throw new PropertyException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn, ps, null);
                throw throwable;
            }
        }
    }

    protected void cleanup(Connection connection, Statement statement, ResultSet result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (SQLException ex) {
                log.error((Object)"Error closing resultset", (Throwable)ex);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                log.error((Object)"Error closing statement", (Throwable)ex);
            }
        }
        if (connection != null && this.closeConnWhenDone) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                log.error((Object)"Error closing connection", (Throwable)ex);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object get(int type, String key) throws PropertyException {
        sql = "SELECT " + this.colItemType + ", " + this.colString + ", " + this.colDate + ", " + this.colData + ", " + this.colFloat + ", " + this.colNumber + " FROM " + this.tableName + " WHERE " + this.colItemKey + " = ? AND " + this.colGlobalKey + " = ?";
        o /* !! */  = null;
        conn = null;
        ps = null;
        rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ps.setString(2, this.globalKey);
            rs = ps.executeQuery();
            if (rs.next()) {
                propertyType = rs.getInt(this.colItemType);
                if (propertyType != type) {
                    throw new InvalidPropertyTypeException();
                }
                switch (type) {
                    case 1: {
                        boolVal = rs.getInt(this.colNumber);
                        o /* !! */  = (byte[])new Boolean(boolVal == 1);
                        ** break;
                    }
                    case 10: {
                        o /* !! */  = rs.getBytes(this.colData);
                        ** break;
                    }
                    case 7: {
                        o /* !! */  = (byte[])rs.getTimestamp(this.colDate);
                        ** break;
                    }
                    case 8: {
                        bis = rs.getBinaryStream(this.colData);
                        try {
                            is = new ObjectInputStream(bis);
                            o /* !! */  = (byte[])is.readObject();
                            ** break;
                        }
                        catch (IOException e) {
                            throw new PropertyException("Error de-serializing object for key '" + key + "' from store:" + e);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                            ** break;
                        }
                    }
                    case 4: {
                        o /* !! */  = (byte[])new Double(rs.getDouble(this.colFloat));
                        ** break;
                    }
                    case 2: {
                        o /* !! */  = (byte[])new Integer(rs.getInt(this.colNumber));
                        ** break;
                    }
                    case 3: {
                        o /* !! */  = (byte[])new Long(rs.getLong(this.colNumber));
                        ** break;
                    }
                    case 5: {
                        o /* !! */  = (byte[])rs.getString(this.colString);
                        ** break;
                    }
                    case 6: {
                        o /* !! */  = (byte[])rs.getString(this.colString);
                        ** break;
                    }
                }
                throw new InvalidPropertyTypeException("JDBCPropertySet doesn't support this type yet.");
            }
lbl54:
            // 12 sources

        }
        catch (SQLException e) {
            try {
                throw new PropertyException(e.getMessage());
                catch (NumberFormatException e) {
                    throw new PropertyException(e.getMessage());
                }
            }
            catch (Throwable var12_16) {
                this.cleanup(conn, ps, rs);
                throw var12_16;
            }
        }
        this.cleanup(conn, ps, rs);
        return o /* !! */ ;
    }

    private void setValues(PreparedStatement ps, int type, String key, Object value) throws SQLException, PropertyException {
        ps.setNull(1, 12);
        ps.setNull(2, 93);
        ps.setNull(3, -3);
        ps.setNull(4, 6);
        ps.setNull(5, 2);
        ps.setInt(6, type);
        ps.setString(7, this.globalKey);
        ps.setString(8, key);
        switch (type) {
            case 1: {
                Boolean boolVal = (Boolean)value;
                ps.setInt(5, boolVal != false ? 1 : 0);
                break;
            }
            case 10: {
                if (value instanceof Data) {
                    Data data = (Data)value;
                    ps.setBytes(3, data.getBytes());
                }
                if (!(value instanceof byte[])) break;
                ps.setBytes(3, (byte[])value);
                break;
            }
            case 8: {
                if (!(value instanceof Serializable)) {
                    throw new PropertyException(value.getClass() + " does not implement java.io.Serializable");
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream os = new ObjectOutputStream(bos);
                    os.writeObject(value);
                    ps.setBytes(3, bos.toByteArray());
                    break;
                }
                catch (IOException e) {
                    throw new PropertyException("I/O Error when serializing object:" + e);
                }
            }
            case 7: {
                Date date = (Date)value;
                ps.setTimestamp(2, new Timestamp(date.getTime()));
                break;
            }
            case 4: {
                Double d = (Double)value;
                ps.setDouble(4, d);
                break;
            }
            case 2: {
                Integer i = (Integer)value;
                ps.setInt(5, i);
                break;
            }
            case 3: {
                Long l = (Long)value;
                ps.setLong(5, l);
                break;
            }
            case 5: {
                ps.setString(1, (String)value);
                break;
            }
            case 6: {
                ps.setString(1, (String)value);
                break;
            }
            default: {
                throw new PropertyException("This type isn't supported!");
            }
        }
    }

    private Object lookup(String location) throws NamingException {
        InitialContext context = new InitialContext();
        try {
            return context.lookup(location);
        }
        catch (NamingException e) {
            return context.lookup("java:comp/env/" + location);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

