/*
 * Decompiled with CFR 0.152.
 */
package com.formos.tapestry.xpath;

import com.formos.tapestry.xpath.TapestryNavigator;
import com.formos.tapestry.xpath.TapestryXPathException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.dom.Attribute;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.dom.Node;
import org.jaxen.BaseXPath;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.XPath;
import org.jaxen.function.StringFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapestryXPath
extends BaseXPath
implements XPath {
    private static final long serialVersionUID = 7040266295703699568L;
    private static final TapestryXPath TEXT_DESCENDANTS;

    public TapestryXPath(String xpath) throws JaxenException {
        super(xpath, (Navigator)TapestryNavigator.TAPESTRY_NAVIGATOR);
    }

    public static TapestryXPath xpath(String xpath) throws JaxenException {
        return new TapestryXPath(xpath);
    }

    public List<Node> selectNodes(Object node) throws JaxenException {
        return super.selectNodes(node);
    }

    public List<Element> selectElements(Object node) throws JaxenException {
        return super.selectNodes(node);
    }

    public List<Attribute> selectAttributes(Object node) throws JaxenException {
        return super.selectNodes(node);
    }

    public List<String> stringValuesOf(Object node) throws JaxenException {
        Context context = this.getContext(node);
        List resultNodes = this.selectNodesForContext(context);
        ArrayList<String> resultStrings = new ArrayList<String>(resultNodes.size());
        for (Object result : resultNodes) {
            resultStrings.add(StringFunction.evaluate(result, (Navigator)context.getNavigator()));
        }
        return resultStrings;
    }

    public List<String> selectElementsChildMarkup(Object node) throws JaxenException {
        List<Element> selectedNodes = this.selectElements(node);
        ArrayList<String> childMarkup = new ArrayList<String>(selectedNodes.size());
        for (Element element : selectedNodes) {
            childMarkup.add(element.getChildMarkup());
        }
        return childMarkup;
    }

    public List<String> selectElementsAttribute(Object node, String attributeName) throws JaxenException {
        List<Element> selectedNodes = this.selectElements(node);
        ArrayList<String> attributeValues = new ArrayList<String>(selectedNodes.size());
        for (Element element : selectedNodes) {
            attributeValues.add(element.getAttribute(attributeName));
        }
        return attributeValues;
    }

    public Element selectSingleElement(Object node) throws JaxenException {
        return (Element)this.selectSingleNode(node);
    }

    public String singleNormalizedDescendantText(Object node) throws JaxenException {
        Object foundNode = this.selectSingleNode(node);
        List<String> textNodeValues = TEXT_DESCENDANTS.stringValuesOf(foundNode);
        return TapestryXPath.normalizeText(TapestryXPath.concatenate(textNodeValues));
    }

    public List<String> normalizedDescendantText(Object node) throws JaxenException {
        List<Node> nodes = this.selectNodes(node);
        ArrayList<String> results = new ArrayList<String>(nodes.size());
        for (Node foundNode : nodes) {
            List<String> textNodeValues = TEXT_DESCENDANTS.stringValuesOf(foundNode);
            results.add(TapestryXPath.normalizeText(TapestryXPath.concatenate(textNodeValues)));
        }
        return results;
    }

    public static String normalizeText(String text) {
        StringBuilder result = new StringBuilder(text.length());
        boolean skippingSpaces = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c) || c == '\u00a0') {
                if (!skippingSpaces) {
                    result.append(' ');
                }
                skippingSpaces = true;
                continue;
            }
            result.append(c);
            skippingSpaces = false;
        }
        if (skippingSpaces && result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private static String concatenate(List<String> strings) {
        if (strings.isEmpty()) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        int maxLength = 0;
        for (String string : strings) {
            maxLength += string.length();
        }
        StringBuilder concatenated = new StringBuilder(maxLength);
        for (String string : strings) {
            concatenated.append(string);
        }
        return concatenated.toString();
    }

    static {
        try {
            TEXT_DESCENDANTS = TapestryXPath.xpath("descendant::text()");
        }
        catch (JaxenException e) {
            throw new TapestryXPathException(e);
        }
    }
}

