/*
 * Decompiled with CFR 0.152.
 */
package net.jsourcerer.webdriver.jserrorcollector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public class JavaScriptError {
    private final String errorCategory;
    private final String errorMessage;
    private final String url;
    private final String sourceName;
    private final Integer lineNumber;
    private final Integer columnNumber;
    private final String console;
    private final String stack;

    JavaScriptError(Map<String, ? extends Object> map) {
        this.errorCategory = this.fromFlag(map.get("errorCategory"));
        this.errorMessage = (String)map.get("errorMessage");
        this.url = (String)map.get("url");
        this.sourceName = (String)map.get("sourceName");
        this.lineNumber = map.containsKey("lineNumber") ? Integer.valueOf(((Number)map.get("lineNumber")).intValue()) : null;
        this.columnNumber = map.containsKey("columnNumber") ? Integer.valueOf(((Number)map.get("columnNumber")).intValue()) : null;
        this.console = (String)map.get("console");
        this.stack = (String)map.get("stack");
    }

    private String fromFlag(Object errorCategory) {
        try {
            byte flag = ((Number)errorCategory).byteValue();
            switch (flag) {
                case 0: {
                    return "Error";
                }
                case 1: {
                    return "Warning";
                }
                case 2: {
                    return "Exception";
                }
                case 4: {
                    return "Strict";
                }
                case 8: {
                    return "Info";
                }
            }
            return "Error";
        }
        catch (Exception e) {
            if (errorCategory != null) {
                return String.valueOf(errorCategory);
            }
            return null;
        }
    }

    public String getErrorCategory() {
        return this.errorCategory;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getStack() {
        return this.stack;
    }

    public String getConsole() {
        return this.console;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errorCategory == null ? 0 : this.errorCategory.hashCode());
        result = 31 * result + (this.console == null ? 0 : this.console.hashCode());
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.lineNumber == null ? 0 : this.lineNumber.hashCode());
        result = 31 * result + (this.columnNumber == null ? 0 : this.columnNumber.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
        result = 31 * result + (this.sourceName == null ? 0 : this.sourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaScriptError other = (JavaScriptError)obj;
        if (this.console == null ? other.console != null : !this.console.equals(other.console)) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.lineNumber == null ? other.lineNumber != null : !this.lineNumber.equals(other.lineNumber)) {
            return false;
        }
        if (this.columnNumber == null ? other.columnNumber != null : !this.columnNumber.equals(other.columnNumber)) {
            return false;
        }
        if (this.sourceName == null ? other.sourceName != null : !this.sourceName.equals(other.sourceName)) {
            return false;
        }
        if (this.errorCategory == null ? other.errorCategory != null : !this.errorCategory.equals(other.errorCategory)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !this.stack.equals(other.stack));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("[%s]: \"%s\"", this.errorCategory, this.errorMessage));
        if (this.sourceName != null && this.sourceName.length() > 0) {
            s.append(" @").append(this.sourceName);
            if (this.lineNumber != null) {
                s.append(":").append(this.lineNumber);
            }
            if (this.columnNumber != null) {
                s.append(":").append(this.columnNumber);
            }
        }
        if (this.url != null) {
            s.append(String.format(" (URL: %s)", this.url));
        }
        if (this.stack != null) {
            s.append("\n").append("Stack: ").append(this.stack.trim());
        }
        if (this.console != null) {
            s.append("\n").append("Console: ").append(this.console);
        }
        return s.toString();
    }

    public static List<JavaScriptError> readErrors(WebDriver driver) {
        String script = "return window.JSErrorCollector_errors ? window.JSErrorCollector_errors.pump() : []";
        List errors = (List)((JavascriptExecutor)driver).executeScript("return window.JSErrorCollector_errors ? window.JSErrorCollector_errors.pump() : []", new Object[0]);
        ArrayList<JavaScriptError> response = new ArrayList<JavaScriptError>();
        for (Object rawError : errors) {
            response.add(new JavaScriptError((Map)rawError));
        }
        return response;
    }

    public static void addExtension(FirefoxProfile ffProfile) throws IOException {
        ffProfile.addExtension(JavaScriptError.class, "JSErrorCollector.xpi");
    }
}

