/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.sql;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.MockObject;
import com.mockobjects.ReturnObjectBag;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

abstract class CommonMockStatement
extends MockObject
implements Statement {
    protected final ExpectationCounter myCloseCalls = new ExpectationCounter("CommonMockStatement.closeCalls");
    private final ReturnObjectBag executeQueryResults = new ReturnObjectBag("executeQuery");
    private final ReturnObjectBag executeUpdateResults = new ReturnObjectBag("executeUpdate");
    private final ReturnObjectBag executeResults = new ReturnObjectBag("execute");
    private int myUpdateCount = 0;
    private SQLException myExecuteException = null;
    private Connection myConnection = null;

    CommonMockStatement() {
    }

    public void addExpectedExecuteQuery(String queryString, ResultSet resultSet) {
        this.executeQueryResults.putObjectToReturn((Object)queryString, (Object)resultSet);
    }

    public void addExpectedExecuteUpdate(String queryString, int updateCount) {
        this.executeUpdateResults.putObjectToReturn((Object)queryString, updateCount);
    }

    public void addExpectedExecute(String queryString, boolean success) {
        this.executeResults.putObjectToReturn((Object)queryString, success);
    }

    public void setExpectedCloseCalls(int callCount) {
        this.myCloseCalls.setExpected(callCount);
    }

    public void setupConnection(Connection conn) {
        this.myConnection = conn;
    }

    public void setupThrowExceptionOnExecute(SQLException exception) {
        this.myExecuteException = exception;
    }

    public void setupUpdateCount(int updateCount) {
        this.myUpdateCount = updateCount;
    }

    protected void innerExecute() throws SQLException {
        if (null != this.myExecuteException) {
            throw this.myExecuteException;
        }
    }

    public void close() throws SQLException {
        this.myCloseCalls.inc();
    }

    public boolean execute(String sql) throws SQLException {
        this.innerExecute();
        return this.executeResults.getNextReturnBoolean((Object)sql);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.innerExecute();
        return (ResultSet)this.executeQueryResults.getNextReturnObject((Object)sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.innerExecute();
        return this.executeUpdateResults.getNextReturnInt((Object)sql);
    }

    public int getMaxFieldSize() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.notImplemented();
    }

    public int getMaxRows() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void setMaxRows(int max) throws SQLException {
        this.notImplemented();
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.notImplemented();
    }

    public int getQueryTimeout() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.notImplemented();
    }

    public void cancel() throws SQLException {
        this.notImplemented();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.notImplemented();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.notImplemented();
    }

    public void setCursorName(String name) throws SQLException {
        this.notImplemented();
    }

    public ResultSet getResultSet() throws SQLException {
        this.notImplemented();
        return null;
    }

    public int getUpdateCount() throws SQLException {
        return this.myUpdateCount;
    }

    public boolean getMoreResults() throws SQLException {
        this.notImplemented();
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.notImplemented();
    }

    public int getFetchDirection() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.notImplemented();
    }

    public int getFetchSize() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public int getResultSetType() throws SQLException {
        this.notImplemented();
        return 0;
    }

    public void addBatch(String sql) throws SQLException {
        this.notImplemented();
    }

    public void clearBatch() throws SQLException {
        this.notImplemented();
    }

    public int[] executeBatch() throws SQLException {
        this.notImplemented();
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.myConnection;
    }
}

