/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import brave.Tracing;
import brave.context.slf4j.MDCCurrentTraceContext;
import brave.http.HttpAdapter;
import brave.http.HttpSampler;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.sampler.BoundarySampler;
import brave.sampler.Sampler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import zipkin.Span;
import zipkin.collector.CollectorMetrics;
import zipkin.internal.CallbackCaptor;
import zipkin.internal.V2SpanConverter;
import zipkin.server.ConditionalOnSelfTracing;
import zipkin.server.brave.TracingHttpHandlerConfiguration;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;

@Configuration
@ConditionalOnSelfTracing
@Import(value={TracingHttpHandlerConfiguration.class})
public class TracingConfiguration {
    @Bean
    Sender sender(@Lazy StorageComponent storage) {
        return new LocalSender(storage);
    }

    @Bean
    Reporter<zipkin2.Span> reporter(Sender sender, @Value(value="${zipkin.self-tracing.message-timeout:1}") int messageTimeout, CollectorMetrics metrics) {
        return AsyncReporter.builder((Sender)sender).messageTimeout((long)messageTimeout, TimeUnit.SECONDS).metrics((ReporterMetrics)new ReporterMetricsAdapter(metrics.forTransport("local"))).build();
    }

    @Bean
    CurrentTraceContext currentTraceContext() {
        return MDCCurrentTraceContext.create();
    }

    @Bean
    Tracing tracing(@Lazy Reporter<zipkin2.Span> reporter, @Value(value="${zipkin.self-tracing.sample-rate:1.0}") float rate) {
        return Tracing.newBuilder().localServiceName("zipkin-server").sampler((double)rate < 0.01 ? BoundarySampler.create((float)rate) : Sampler.create((float)rate)).currentTraceContext(this.currentTraceContext()).spanReporter(reporter).build();
    }

    @Bean
    HttpTracing httpTracing(Tracing tracing) {
        return HttpTracing.newBuilder((Tracing)tracing).serverSampler(new HttpSampler(){

            public <Req> Boolean trySample(HttpAdapter<Req, ?> adapter, Req request) {
                return "GET".equals(adapter.method(request)) && adapter.path(request).startsWith("/api");
            }
        }).clientSampler(HttpSampler.NEVER_SAMPLE).build();
    }

    static final class ReporterMetricsAdapter
    implements ReporterMetrics {
        final CollectorMetrics delegate;

        ReporterMetricsAdapter(CollectorMetrics delegate) {
            this.delegate = delegate;
        }

        public void incrementMessages() {
            this.delegate.incrementMessages();
        }

        public void incrementMessagesDropped(Throwable throwable) {
            this.delegate.incrementMessagesDropped();
        }

        public void incrementSpans(int i) {
            this.delegate.incrementSpans(i);
        }

        public void incrementSpanBytes(int i) {
            this.delegate.incrementBytes(i);
        }

        public void incrementMessageBytes(int i) {
        }

        public void incrementSpansDropped(int i) {
            this.delegate.incrementMessagesDropped();
        }

        public void updateQueuedSpans(int i) {
        }

        public void updateQueuedBytes(int i) {
        }
    }

    static final class LocalSender
    extends Sender {
        private final StorageComponent delegate;

        LocalSender(StorageComponent delegate) {
            this.delegate = delegate;
        }

        public Encoding encoding() {
            return Encoding.JSON;
        }

        public int messageMaxBytes() {
            return 0x500000;
        }

        public int messageSizeInBytes(List<byte[]> list) {
            return Encoding.JSON.listSizeInBytes(list);
        }

        public Call<Void> sendSpans(List<byte[]> encodedSpans) {
            ArrayList<Span> spans = new ArrayList<Span>(encodedSpans.size());
            for (byte[] encodedSpan : encodedSpans) {
                zipkin2.Span v2Span = (zipkin2.Span)SpanBytesDecoder.JSON_V2.decodeOne(encodedSpan);
                spans.add(V2SpanConverter.toSpan((zipkin2.Span)v2Span));
            }
            CallbackCaptor callback = new CallbackCaptor();
            this.delegate.asyncSpanConsumer().accept(spans, (Callback)callback);
            callback.get();
            return Call.create(null);
        }

        public CheckResult check() {
            return CheckResult.OK;
        }

        public void close() {
        }
    }
}

