/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.timeandspace.smoothie.IntMath;
import java.util.ConcurrentModificationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

final class Utils {
    public static final int BYTE_SIZE_DIVISION_SHIFT = 3;

    @Contract(value="false -> fail")
    static void verifyThat(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    static void verifyEqual(int actual, int expected) {
        if (actual != expected) {
            throw new AssertionError((Object)("expected: " + expected + ", actual: " + actual));
        }
    }

    static void verifyEqual(long actual, long expected) {
        if (actual != expected) {
            throw new AssertionError((Object)("expected: " + expected + ", actual: " + actual));
        }
    }

    static void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    static void checkNonNegative(long value, String meaning) {
        if (value < 0L) {
            throw new IllegalArgumentException(meaning + " must be non-negative, " + value + " given");
        }
    }

    @Contract(value="null -> fail; !null -> param1", pure=true)
    static <T> T nonNullOrThrowCme(@Nullable T obj) {
        if (obj == null) {
            throw new ConcurrentModificationException();
        }
        return obj;
    }

    static void checkModCount(int expectedModCount, int actualModCount) {
        if (expectedModCount != actualModCount) {
            throw new ConcurrentModificationException("expectedModCount: " + expectedModCount + ", actualModCount: " + actualModCount);
        }
    }

    @CanIgnoreReturnValue
    @Contract(value="null -> fail; !null -> param1", pure=true)
    static <T> T verifyNonNull(@Nullable T obj) {
        if (obj == null) {
            throw new AssertionError();
        }
        return obj;
    }

    static void verifyIsPowerOfTwo(int n, String meaning) {
        if (!IntMath.isPowerOfTwo(n)) {
            throw new AssertionError((Object)(meaning + ": " + n));
        }
    }

    static <T extends Throwable> void rethrowUnchecked(Throwable t) throws T {
        throw t;
    }

    static void duplicateArray(Object array, int arrayLength, int filledLowPartLength) {
        while (filledLowPartLength < arrayLength) {
            System.arraycopy(array, 0, array, filledLowPartLength, filledLowPartLength);
            filledLowPartLength *= 2;
        }
    }

    private Utils() {
    }

    static {
        Utils.verifyEqual(3, Integer.numberOfTrailingZeros(8));
    }
}

