/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.ObjectSize;
import io.timeandspace.smoothie.SmoothieMap;
import io.timeandspace.smoothie.SmoothieMapBuilder;
import java.util.function.ToLongFunction;

class SmoothieMapWithCustomKeyHashFunction<K, V>
extends SmoothieMap<K, V> {
    private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(SmoothieMapWithCustomKeyHashFunction.class);
    private final ToLongFunction<K> keyHashFunction;

    SmoothieMapWithCustomKeyHashFunction(SmoothieMapBuilder<K, V> builder) {
        super(builder);
        this.keyHashFunction = builder.keyHashFunction();
    }

    @Override
    long keyHashCode(Object key) {
        return this.keyHashFunction.applyAsLong(key);
    }

    @Override
    ToLongFunction<K> getKeyHashFunction() {
        return this.keyHashFunction;
    }

    @Override
    long smoothieMapClassSizeInBytes() {
        return SIZE_IN_BYTES;
    }
}

