/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.BitSetAndState;
import io.timeandspace.smoothie.OrdinarySegmentStats;
import io.timeandspace.smoothie.SmoothieMap;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SmoothieMapStats {
    private int numAggregatedMaps = 0;
    private int numAggregatedSegments = 0;
    private int numInflatedSegments = 0;
    private final @Nullable OrdinarySegmentStats @Nullable [][] ordinarySegmentStatsPerOrderAndNumFullSlots = new OrdinarySegmentStats[31][];

    SmoothieMapStats() {
    }

    int getNumAggregatedSegments() {
        return this.numAggregatedSegments;
    }

    int getNumInflatedSegments() {
        return this.numInflatedSegments;
    }

    int computeNumAggregatedOrdinarySegmentsWithOrder(int segmentOrder) {
        @Nullable OrdinarySegmentStats @Nullable [] statsForSegmentOrder = this.ordinarySegmentStatsPerOrderAndNumFullSlots[segmentOrder];
        if (statsForSegmentOrder == null) {
            return 0;
        }
        return Arrays.stream(statsForSegmentOrder).filter(Objects::nonNull).mapToInt(OrdinarySegmentStats::getNumAggregatedSegments).sum();
    }

    private long computeNumAggregatedFullSlotsInSegmentsWithOrder(int segmentOrder) {
        @Nullable OrdinarySegmentStats @Nullable [] statsForSegmentOrder = this.ordinarySegmentStatsPerOrderAndNumFullSlots[segmentOrder];
        if (statsForSegmentOrder == null) {
            return 0L;
        }
        return Arrays.stream(statsForSegmentOrder).filter(Objects::nonNull).mapToLong(OrdinarySegmentStats::getNumAggregatedFullSlots).sum();
    }

    void incrementAggregatedMaps() {
        ++this.numAggregatedMaps;
    }

    private OrdinarySegmentStats acquireSegmentStats(int segmentOrder, int numFullSlots) {
        OrdinarySegmentStats ordinarySegmentStats;
        @Nullable OrdinarySegmentStats @Nullable [] ordinarySegmentStatsPerNumFullSlots = this.ordinarySegmentStatsPerOrderAndNumFullSlots[segmentOrder];
        if (ordinarySegmentStatsPerNumFullSlots == null) {
            ordinarySegmentStatsPerNumFullSlots = new OrdinarySegmentStats[49];
            this.ordinarySegmentStatsPerOrderAndNumFullSlots[segmentOrder] = ordinarySegmentStatsPerNumFullSlots;
        }
        if ((ordinarySegmentStats = ordinarySegmentStatsPerNumFullSlots[numFullSlots]) == null) {
            ordinarySegmentStatsPerNumFullSlots[numFullSlots] = ordinarySegmentStats = new OrdinarySegmentStats();
        }
        return ordinarySegmentStats;
    }

    <K, V> void aggregateSegment(SmoothieMap<K, V> map, SmoothieMap.Segment<K, V> segment) {
        ++this.numAggregatedSegments;
        long bitSetAndState = segment.bitSetAndState;
        if (BitSetAndState.isInflatedBitSetAndState(bitSetAndState)) {
            ++this.numInflatedSegments;
            return;
        }
        int segmentOrder = BitSetAndState.segmentOrder(bitSetAndState);
        int numFullSlots = BitSetAndState.segmentSize(bitSetAndState);
        OrdinarySegmentStats ordinarySegmentStats = this.acquireSegmentStats(segmentOrder, numFullSlots);
        segment.aggregateStats(map, ordinarySegmentStats);
    }

    OrdinarySegmentStats computeTotalOrdinarySegmentStats() {
        OrdinarySegmentStats totalStats = new OrdinarySegmentStats();
        for (OrdinarySegmentStats[] statsPerNumFullSlots : this.ordinarySegmentStatsPerOrderAndNumFullSlots) {
            if (statsPerNumFullSlots == null) continue;
            for (OrdinarySegmentStats stats : statsPerNumFullSlots) {
                if (stats == null) continue;
                totalStats.add(stats);
            }
        }
        return totalStats;
    }

    OrdinarySegmentStats computeOrdinarySegmentStatsPerNumFullSlots(int numFullSlots) {
        OrdinarySegmentStats totalStatsForNumFullSlots = new OrdinarySegmentStats();
        for (OrdinarySegmentStats[] statsPerNumFullSlots : this.ordinarySegmentStatsPerOrderAndNumFullSlots) {
            OrdinarySegmentStats stats;
            if (statsPerNumFullSlots == null || (stats = statsPerNumFullSlots[numFullSlots]) == null) continue;
            totalStatsForNumFullSlots.add(stats);
        }
        return totalStatsForNumFullSlots;
    }

    String segmentOrderAndLoadDistribution() {
        StringBuilder sb = new StringBuilder();
        sb.append("Num inflated segments: ").append(this.numInflatedSegments).append('\n');
        OrdinarySegmentStats.Count numSegmentsWithOrder_count = new OrdinarySegmentStats.Count("segments", segmentOrder -> this.computeNumAggregatedOrdinarySegmentsWithOrder(segmentOrder));
        OrdinarySegmentStats.Count numFullSlotsInSegmentsWithOrder_count = new OrdinarySegmentStats.Count("full slots", this::computeNumAggregatedFullSlotsInSegmentsWithOrder);
        OrdinarySegmentStats.appendNonZeroOrderedCountsWithPercentiles(sb, "order", this.ordinarySegmentStatsPerOrderAndNumFullSlots.length, Arrays.asList(numSegmentsWithOrder_count, numFullSlotsInSegmentsWithOrder_count), segmentOrder -> {
            @Nullable OrdinarySegmentStats @Nullable [] statsForSegmentOrder = this.ordinarySegmentStatsPerOrderAndNumFullSlots[segmentOrder];
            if (statsForSegmentOrder == null) {
                return;
            }
            OrdinarySegmentStats.Count numSegmentsWithFullSlots_count = new OrdinarySegmentStats.Count("segments", numFullSlots -> {
                @Nullable OrdinarySegmentStats stats = statsForSegmentOrder[numFullSlots];
                return stats == null ? 0L : (long)stats.getNumAggregatedSegments();
            });
            OrdinarySegmentStats.Count numFullSlotsInSegmentsWithFullSlots_count = new OrdinarySegmentStats.Count("full slots", numFullSlots -> {
                @Nullable OrdinarySegmentStats stats = statsForSegmentOrder[numFullSlots];
                return stats == null ? 0L : stats.getNumAggregatedFullSlots();
            });
            OrdinarySegmentStats.appendNonZeroOrderedCountsWithPercentiles(sb, "# full slots =", statsForSegmentOrder.length, Arrays.asList(numSegmentsWithFullSlots_count, numFullSlotsInSegmentsWithFullSlots_count), numFullSlots -> {});
        });
        return sb.toString();
    }

    public String toString() {
        return this.segmentOrderAndLoadDistribution();
    }
}

