/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.HashTable;
import io.timeandspace.smoothie.InterleavedSegment_BitSetAndStateArea;
import io.timeandspace.smoothie.InterleavedSegments;
import io.timeandspace.smoothie.LongMath;
import io.timeandspace.smoothie.SmoothieMap;

final class OutboundOverflowCounts {
    private static final long MOST_SIGNIFICANT_BYTE_BITS = -9187201950435737472L;
    private static final long LEAST_SIGNIFICANT_BYTE_BITS = 0x101010101010101L;

    static long outboundOverflowCount_markGroupForChange(long outboundOverflowCount_perGroupChanges, long groupIndex) {
        return outboundOverflowCount_perGroupChanges | OutboundOverflowCounts.outboundOverflowCount_groupForChange(groupIndex);
    }

    static long outboundOverflowCount_groupForChange(long groupIndex) {
        return 1L << (int)(groupIndex * 8L);
    }

    static long computeOutboundOverflowCount_perGroupChanges(long baseGroupIndex, long finalGroupIndex) {
        if (baseGroupIndex == finalGroupIndex) {
            return 0L;
        }
        return OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges0(baseGroupIndex, finalGroupIndex);
    }

    private static long computeOutboundOverflowCount_perGroupChanges0(long baseGroupIndex, long finalGroupIndex) {
        long outboundOverflowCount_perGroupChanges = 0L;
        long groupIndex = baseGroupIndex;
        long groupIndexStep = 0L;
        do {
            outboundOverflowCount_perGroupChanges = OutboundOverflowCounts.outboundOverflowCount_markGroupForChange(outboundOverflowCount_perGroupChanges, groupIndex);
        } while ((groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep)) != finalGroupIndex);
        return outboundOverflowCount_perGroupChanges;
    }

    static void incrementOutboundOverflowCountsPerGroup(Object segment, int isFullCapacitySegment, long outboundOverflowCount_perGroupIncrements) {
        long matchIncrements = outboundOverflowCount_perGroupIncrements << 7;
        OutboundOverflowCounts.addOutboundOverflowCountsPerGroup(segment, isFullCapacitySegment, outboundOverflowCount_perGroupIncrements, matchIncrements);
    }

    static void addOutboundOverflowCountsPerGroup(SmoothieMap.Segment<?, ?> segment, long outboundOverflowCount_perGroupAdditions) {
        OutboundOverflowCounts.addOutboundOverflowCountsPerGroup(segment, segment instanceof InterleavedSegments.FullCapacitySegment ? 1 : 0, outboundOverflowCount_perGroupAdditions, OutboundOverflowCounts.matchChanges(outboundOverflowCount_perGroupAdditions));
    }

    private static void addOutboundOverflowCountsPerGroup(Object segment, int isFullCapacitySegment, long outboundOverflowCount_perGroupAdditions, long matchAdditions) {
        long oldOutboundOverflowCountsPerGroup = InterleavedSegment_BitSetAndStateArea.getOutboundOverflowCountsPerGroup(segment);
        long newOutboundOverflowCountsPerGroup = oldOutboundOverflowCountsPerGroup + outboundOverflowCount_perGroupAdditions;
        InterleavedSegment_BitSetAndStateArea.setOutboundOverflowCountsPerGroup(segment, newOutboundOverflowCountsPerGroup);
        long bitMask = oldOutboundOverflowCountsPerGroup - 0x101010101010101L & matchAdditions & (oldOutboundOverflowCountsPerGroup << 7 ^ 0xFFFFFFFFFFFFFFFFL);
        while (bitMask != 0L) {
            long groupIndex = (long)Long.numberOfTrailingZeros(bitMask) >>> 3;
            long dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, isFullCapacitySegment);
            long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
            InterleavedSegments.writeDataGroupAtOffset(segment, dataGroupOffset, dataGroup |= 0x4040404040404040L);
            bitMask = LongMath.clearLowestSetBit(bitMask);
        }
    }

    static void decrementOutboundOverflowCountsPerGroup(Object segment, int isFullCapacitySegment, long outboundOverflowCount_perGroupDecrements) {
        long matchDecrements = outboundOverflowCount_perGroupDecrements << 7;
        OutboundOverflowCounts.subtractOutboundOverflowCountsPerGroup(segment, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, matchDecrements);
    }

    static void subtractOutboundOverflowCountsPerGroupAndUpdateAllGroups(SmoothieMap.Segment<?, ?> segment, int isFullCapacitySegment, long outboundOverflowCount_perGroupDeductions) {
        long outboundOverflowCountsPerGroup = segment.outboundOverflowCountsPerGroup;
        segment.outboundOverflowCountsPerGroup = outboundOverflowCountsPerGroup -= outboundOverflowCount_perGroupDeductions;
        for (int groupIndex = 0; groupIndex < 8; ++groupIndex) {
            long outboundOverflowCount = outboundOverflowCountsPerGroup & 0xFFL;
            outboundOverflowCountsPerGroup >>>= 8;
            long outboundOverflowCountIsZero = outboundOverflowCount - 1L >>> 63;
            long dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, isFullCapacitySegment);
            long outboundOverflowCountIsPositive = 1L - outboundOverflowCountIsZero;
            long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
            dataGroup &= 0x4040404040404040L * outboundOverflowCountIsZero ^ 0xFFFFFFFFFFFFFFFFL;
            InterleavedSegments.writeDataGroupAtOffset(segment, dataGroupOffset, dataGroup |= 0x4040404040404040L * outboundOverflowCountIsPositive);
        }
    }

    private static void subtractOutboundOverflowCountsPerGroup(Object segment, int isFullCapacitySegment, long outboundOverflowCount_perGroupDeductions, long matchDeductions) {
        long outboundOverflowCountsPerGroup = InterleavedSegment_BitSetAndStateArea.getOutboundOverflowCountsPerGroup(segment);
        InterleavedSegment_BitSetAndStateArea.setOutboundOverflowCountsPerGroup(segment, outboundOverflowCountsPerGroup -= outboundOverflowCount_perGroupDeductions);
        long bitMask = outboundOverflowCountsPerGroup - 0x101010101010101L & matchDeductions & (outboundOverflowCountsPerGroup << 7 ^ 0xFFFFFFFFFFFFFFFFL);
        while (bitMask != 0L) {
            long groupIndex = (long)Long.numberOfTrailingZeros(bitMask) >>> 3;
            long dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, isFullCapacitySegment);
            long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
            InterleavedSegments.writeDataGroupAtOffset(segment, dataGroupOffset, dataGroup &= 0xBFBFBFBFBFBFBFBFL);
            bitMask = LongMath.clearLowestSetBit(bitMask);
        }
    }

    private static long matchChanges(long outboundOverflowCount_perGroupChanges) {
        return outboundOverflowCount_perGroupChanges + 0x7F7F7F7F7F7F7F7FL & 0x8080808080808080L;
    }

    private static void checkOutboundOverflowCounts(Object segment, int isFullCapacitySegment) {
        long outboundOverflowCountsPerGroup = InterleavedSegment_BitSetAndStateArea.getOutboundOverflowCountsPerGroup(segment);
        for (long groupIndex = 0L; groupIndex < 8L; ++groupIndex) {
            boolean dataGroupHasOutboundOverflowMask;
            byte outboundOverflowCount = (byte)outboundOverflowCountsPerGroup;
            boolean outboundOverflowCountIsPositive = outboundOverflowCount != 0;
            long dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, isFullCapacitySegment);
            long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
            boolean bl = dataGroupHasOutboundOverflowMask = !HashTable.shouldStopProbing(dataGroup);
            if (outboundOverflowCountIsPositive ^ dataGroupHasOutboundOverflowMask) {
                throw new IllegalStateException();
            }
            outboundOverflowCountsPerGroup >>>= 8;
        }
    }

    private OutboundOverflowCounts() {
    }
}

