/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.UnsafeUtils;
import io.timeandspace.smoothie.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ObjectSize {
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private static final long OBJECT_HEADER_SIZE;
    private static final @Nullable Field HASH_MAP_TABLE_FIELD;
    private static final ClassValue<Long> CLASS_SIZES;

    static long objectSizeInBytes(@Nullable Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> objClass = obj.getClass();
        if (objClass.isArray()) {
            return ObjectSize.arraySizeInBytes(objClass, Array.getLength(obj));
        }
        return ObjectSize.classSizeInBytes(objClass);
    }

    static long classSizeInBytes(Class<?> objClass) {
        return CLASS_SIZES.get(objClass);
    }

    private static long internalClassSizeInBytes(Class<?> objClass) {
        Utils.verifyThat(!objClass.isArray());
        Field[] lastSetOfDeclaredFields = ObjectSize.lastSetOfDeclaredFields(objClass);
        @Nullable Field lastField = Stream.of(lastSetOfDeclaredFields).max(Comparator.comparingLong(f -> UnsafeUtils.U.objectFieldOffset((Field)f))).orElse(null);
        if (lastField == null) {
            return OBJECT_HEADER_SIZE;
        }
        long lastFieldOffset = UnsafeUtils.U.objectFieldOffset(lastField);
        Class<?> lastFieldType = lastField.getType();
        int lastFieldSize = UnsafeUtils.U.arrayIndexScale(ObjectSize.arrayClassByElementClass(lastFieldType));
        return lastFieldOffset + (long)lastFieldSize;
    }

    static long arraySizeInBytes(Class<?> arrayClass, int length) {
        long baseOffset = UnsafeUtils.U.arrayBaseOffset(arrayClass);
        long scale = UnsafeUtils.U.arrayIndexScale(arrayClass);
        return baseOffset + scale * (long)length;
    }

    public static long hashMapSizeInBytes(HashMap<?, ?> map) {
        if (HASH_MAP_TABLE_FIELD == null) {
            throw new RuntimeException("Not found a table field in HashMap class");
        }
        try {
            Object table = HASH_MAP_TABLE_FIELD.get(map);
            long entrySizeInBytes = 0L;
            if (map.size() > 0) {
                entrySizeInBytes = ObjectSize.objectSizeInBytes(map.entrySet().iterator().next());
            }
            return ObjectSize.objectSizeInBytes(map) + ObjectSize.objectSizeInBytes(table) + entrySizeInBytes * (long)map.size();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field[] lastSetOfDeclaredFields(Class<?> objClass) {
        while (objClass != Object.class) {
            Field[] lastSetOfDeclaredFields = (Field[])Stream.of(objClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
            if (lastSetOfDeclaredFields.length > 0) {
                return lastSetOfDeclaredFields;
            }
            objClass = objClass.getSuperclass();
        }
        return EMPTY_FIELDS;
    }

    private static Class<?> arrayClassByElementClass(Class<?> elementClass) {
        return Array.newInstance(elementClass, 0).getClass();
    }

    private ObjectSize() {
    }

    static {
        CLASS_SIZES = new ClassValue<Long>(){

            @Override
            protected Long computeValue(Class<?> type) {
                return ObjectSize.internalClassSizeInBytes(type);
            }
        };
        OBJECT_HEADER_SIZE = UnsafeUtils.minInstanceFieldOffset(ClassWithOneByteField.class);
        HASH_MAP_TABLE_FIELD = Stream.of(HashMap.class.getDeclaredFields()).filter(f -> f.getType().isArray()).findFirst().orElse(null);
        if (HASH_MAP_TABLE_FIELD != null) {
            HASH_MAP_TABLE_FIELD.setAccessible(true);
        }
    }

    private static class ClassWithOneByteField {
        byte field;

        private ClassWithOneByteField() {
        }
    }
}

