/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.OrdinarySegmentStats;

final class KeySearchStats {
    private final long[] numSearchesPerCollisionChainGroupLength = new long[8];
    private final long[] numSearchesPerNumCollisionKeyComparisons = new long[48];

    KeySearchStats() {
    }

    void aggregate(int collisionChainGroupLength, int numCollisionKeyComparisons) {
        int n = collisionChainGroupLength;
        this.numSearchesPerCollisionChainGroupLength[n] = this.numSearchesPerCollisionChainGroupLength[n] + 1L;
        int n2 = numCollisionKeyComparisons;
        this.numSearchesPerNumCollisionKeyComparisons[n2] = this.numSearchesPerNumCollisionKeyComparisons[n2] + 1L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        OrdinarySegmentStats.appendMetricStats(sb, "searches", this.numSearchesPerCollisionChainGroupLength, "collision chain group length");
        OrdinarySegmentStats.appendMetricStats(sb, "searches", this.numSearchesPerNumCollisionKeyComparisons, "num collision key comparisons");
        return sb.toString();
    }
}

