/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.collect.Equivalence;
import io.timeandspace.collect.map.KeyValue;
import io.timeandspace.smoothie.ComparableClassValue;
import io.timeandspace.smoothie.ObjectSize;
import io.timeandspace.smoothie.SmoothieMap;
import io.timeandspace.smoothie.Utils;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InflatedSegmentQueryContext<K, V> {
    private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(InflatedSegmentQueryContext.class);
    static final Object COMPUTE_IF_PRESENT_ENTRY_REMOVED = new Object();
    private final SmoothieMap<K, V> map;
    private final Equivalence<K> keyEquivalence;
    private final boolean useDefaultKeyEquivalence;
    private @MonotonicNonNull Class<?> primaryKeyClass;
    private boolean isPrimaryKeyClassComparable;
    private @Nullable Node<K, V> cachedNode;
    private @Nullable ComparableNode cachedComparableNode;
    private @Nullable NodeWithCustomKeyEquivalence<K, V> cachedNodeWithCustomKeyEquivalence;
    private final ComputeIfPresentLambda<K, V> computeIfPresentLambda;
    private final RemoveOrReplaceLambda<K, V> removeOrReplaceLambda;
    private final ComputeIfAbsentLambda<K, V> computeIfAbsentLambda;
    private final ComputeLambda<K, V> computeLambda;
    private final MergeLambda<K, V> mergeLambda;

    InflatedSegmentQueryContext(SmoothieMap<K, V> map) {
        this.map = map;
        this.keyEquivalence = map.keyEquivalence();
        this.useDefaultKeyEquivalence = this.keyEquivalence.equals(Equivalence.defaultEquality());
        this.computeIfPresentLambda = new ComputeIfPresentLambda(map);
        this.removeOrReplaceLambda = new RemoveOrReplaceLambda(map);
        this.computeIfAbsentLambda = new ComputeIfAbsentLambda(this);
        this.computeLambda = new ComputeLambda(this);
        this.mergeLambda = new MergeLambda(this);
    }

    long sizeInBytes() {
        return SIZE_IN_BYTES + (this.cachedNode != null ? Node.SIZE_IN_BYTES : 0L) + (this.cachedComparableNode != null ? ComparableNode.SIZE_IN_BYTES : 0L) + (this.cachedNodeWithCustomKeyEquivalence != null ? NodeWithCustomKeyEquivalence.SIZE_IN_BYTES : 0L) + ComputeIfPresentLambda.SIZE_IN_BYTES + RemoveOrReplaceLambda.SIZE_IN_BYTES + ComputeIfAbsentLambda.SIZE_IN_BYTES + ComputeLambda.SIZE_IN_BYTES + MergeLambda.SIZE_IN_BYTES;
    }

    @EnsuresNonNull(value={"primaryKeyClass"})
    private void initPrimaryKeyClass(Object key) {
        this.primaryKeyClass = key.getClass();
        boolean primaryKeyClassIsString = this.primaryKeyClass == String.class;
        this.isPrimaryKeyClassComparable = primaryKeyClassIsString ? true : (Boolean)ComparableClassValue.INSTANCE.get(this.primaryKeyClass);
    }

    Node<K, V> getNodeForKey(Object key, long hash) {
        Node node;
        if (this.useDefaultKeyEquivalence) {
            boolean keyIsOfPrimaryKeyClass;
            if (this.primaryKeyClass == null) {
                this.initPrimaryKeyClass(key);
            }
            boolean bl = keyIsOfPrimaryKeyClass = this.primaryKeyClass == key.getClass();
            if (keyIsOfPrimaryKeyClass && this.isPrimaryKeyClassComparable) {
                node = this.cachedComparableNode;
                if (node == null) {
                    ComparableNode comparableNode = new ComparableNode();
                    node = comparableNode;
                    this.cachedComparableNode = comparableNode;
                }
            } else {
                node = this.cachedNode;
                if (node == null) {
                    node = new Node();
                    this.cachedNode = node;
                }
            }
        } else {
            node = this.cachedNodeWithCustomKeyEquivalence;
            if (node == null) {
                NodeWithCustomKeyEquivalence nodeWithCustomKeyEquivalence = new NodeWithCustomKeyEquivalence(this.keyEquivalence);
                node = nodeWithCustomKeyEquivalence;
                this.cachedNodeWithCustomKeyEquivalence = nodeWithCustomKeyEquivalence;
            }
        }
        node.key = key;
        node.hash = hash;
        return node;
    }

    private void dropInternedNodeFromCache(Node<K, V> node) {
        if (this.cachedNode == node) {
            this.cachedNode = null;
        } else if (this.cachedComparableNode == node) {
            this.cachedComparableNode = null;
        } else {
            this.cachedNodeWithCustomKeyEquivalence = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable V get(HashMap<Node<K, V>, Node<K, V>> delegate, Object key, long hash) {
        Node<K, V> node = this.getNodeForKey(key, hash);
        try {
            Node<K, V> internalNode = delegate.get(node);
            Object object = internalNode != null ? Utils.nonNullOrThrowCme(((Node)internalNode).value) : null;
            return (V)object;
        }
        finally {
            ((Node)node).key = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable K getInternalKey(HashMap<Node<K, V>, Node<K, V>> delegate, Object key, long hash) {
        Node<K, V> node = this.getNodeForKey(key, hash);
        try {
            Node<K, V> internalNode = delegate.get(node);
            Object object = internalNode != null ? Utils.nonNullOrThrowCme(((Node)internalNode).key) : null;
            return (K)object;
        }
        finally {
            ((Node)node).key = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable Object computeIfPresent(HashMap<Node<K, V>, Node<K, V>> delegate, K key, long hash, BiFunction<? super K, ? super V, ? extends @Nullable V> remappingFunction) {
        Node<K, V> node = this.getNodeForKey(key, hash);
        ComputeIfPresentLambda<K, V> computeIfPresentLambda = this.computeIfPresentLambda;
        ((ComputeIfPresentLambda)computeIfPresentLambda).key = key;
        ((ComputeIfPresentLambda)computeIfPresentLambda).remappingFunction = remappingFunction;
        if (((ComputeIfPresentLambda)computeIfPresentLambda).newValueOrEntryRemoved != null) {
            throw new ConcurrentModificationException();
        }
        try {
            delegate.computeIfPresent(node, computeIfPresentLambda);
            Object object = ((ComputeIfPresentLambda)computeIfPresentLambda).newValueOrEntryRemoved;
            return object;
        }
        finally {
            computeIfPresentLambda.clear();
            ((Node)node).key = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable V remove(HashMap<Node<K, V>, Node<K, V>> delegate, K key, long hash) {
        Node<K, V> node = this.getNodeForKey(key, hash);
        try {
            Node<K, V> internalNode = delegate.remove(node);
            if (internalNode != null) {
                this.map.decrementSize();
                Object object = Utils.nonNullOrThrowCme(((Node)internalNode).value);
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            ((Node)node).key = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable V replace(HashMap<Node<K, V>, Node<K, V>> delegate, K key, long hash, V value) {
        Node<K, V> node = this.getNodeForKey(key, hash);
        try {
            Node<K, V> internalNode = delegate.get(node);
            if (internalNode != null) {
                Object internalVal = Utils.nonNullOrThrowCme(((Node)internalNode).value);
                ((Node)internalNode).value = value;
                Object object = internalVal;
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            ((Node)node).key = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeOrReplaceEntry(HashMap<Node<K, V>, Node<K, V>> delegate, K key, long hash, Object matchValue, @Nullable V replacementValue) {
        Node<K, V> node = this.getNodeForKey(key, hash);
        RemoveOrReplaceLambda<K, V> removeOrReplaceLambda = this.removeOrReplaceLambda;
        removeOrReplaceLambda.matchValue = matchValue;
        removeOrReplaceLambda.replacementValue = replacementValue;
        try {
            delegate.computeIfPresent(node, removeOrReplaceLambda);
            boolean bl = removeOrReplaceLambda.removedOrReplaced;
            return bl;
        }
        finally {
            ((RemoveOrReplaceLambda)removeOrReplaceLambda).clear();
            ((Node)node).key = null;
        }
    }

    @Nullable V put(HashMap<Node<K, V>, Node<K, V>> delegate, K key, long hash, V value, boolean onlyIfAbsent) {
        Node<K, V> internalNode;
        Node<K, V> node = this.getNodeForKey(key, hash);
        try {
            internalNode = delegate.putIfAbsent(node, node);
        }
        catch (Throwable t) {
            ((Node)node).key = null;
            throw t;
        }
        if (internalNode != null) {
            ((Node)node).key = null;
            Object internalVal = Utils.nonNullOrThrowCme(((Node)internalNode).value);
            if (!onlyIfAbsent) {
                ((Node)internalNode).value = value;
            }
            return (V)internalVal;
        }
        this.map.incrementSize();
        ((Node)node).value = value;
        this.dropInternedNodeFromCache(node);
        return null;
    }

    void putDuringInflation(HashMap<Node<K, V>, Node<K, V>> delegate, K key, long hash, V value) {
        Node<K, V> internalNode;
        Node<K, V> node = this.getNodeForKey(key, hash);
        try {
            internalNode = delegate.putIfAbsent(node, node);
        }
        catch (Throwable t) {
            ((Node)node).key = null;
            throw t;
        }
        if (internalNode != null) {
            ((Node)node).key = null;
            throw new ConcurrentModificationException();
        }
        ((Node)node).value = value;
        this.dropInternedNodeFromCache(node);
    }

    @Nullable Node<K, V> computeIfAbsent(HashMap<Node<K, V>, Node<K, V>> delegate, Node<K, V> nodeWithKeyAndHash, Function<? super K, ? extends @Nullable V> mappingFunction) {
        ComputeIfAbsentLambda<K, V> computeIfAbsentLambda = this.computeIfAbsentLambda;
        computeIfAbsentLambda.mappingFunction = mappingFunction;
        try {
            Node<K, V> internalNode;
            Node<K, V> node = internalNode = delegate.computeIfAbsent(nodeWithKeyAndHash, computeIfAbsentLambda);
            return node;
        }
        catch (Throwable t) {
            ((Node)nodeWithKeyAndHash).value = null;
            ((Node)nodeWithKeyAndHash).key = null;
            throw t;
        }
        finally {
            computeIfAbsentLambda.mappingFunction = null;
        }
    }

    @Nullable Node<K, V> compute(HashMap<Node<K, V>, Node<K, V>> delegate, Node<K, V> nodeWithKeyAndHash, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
        ComputeLambda<K, V> computeLambda = this.computeLambda;
        computeLambda.remappingFunction = remappingFunction;
        try {
            Node<K, V> internalNode;
            Node<K, V> node = internalNode = delegate.compute(nodeWithKeyAndHash, computeLambda);
            return node;
        }
        catch (Throwable t) {
            ((Node)nodeWithKeyAndHash).value = null;
            ((Node)nodeWithKeyAndHash).key = null;
            throw t;
        }
        finally {
            computeLambda.remappingFunction = null;
        }
    }

    @Nullable Node<K, V> merge(HashMap<Node<K, V>, Node<K, V>> delegate, Node<K, V> nodeWithKeyAndHash, V value, BiFunction<? super V, ? super V, ? extends @Nullable V> remappingFunction) {
        ((Node)nodeWithKeyAndHash).value = value;
        MergeLambda<K, V> mergeLambda = this.mergeLambda;
        mergeLambda.remappingFunction = remappingFunction;
        try {
            Node<K, V> internalNode;
            Node<K, V> node = internalNode = delegate.compute(nodeWithKeyAndHash, mergeLambda);
            return node;
        }
        catch (Throwable t) {
            ((Node)nodeWithKeyAndHash).value = null;
            ((Node)nodeWithKeyAndHash).key = null;
            throw t;
        }
        finally {
            mergeLambda.remappingFunction = null;
        }
    }

    private static class NodeWithCustomKeyEquivalence<K, V>
    extends Node<K, V> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(NodeWithCustomKeyEquivalence.class);
        private final Equivalence<K> equivalence;

        NodeWithCustomKeyEquivalence(Equivalence<K> equivalence) {
            this.equivalence = equivalence;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof NodeWithCustomKeyEquivalence)) {
                throw new AssertionError();
            }
            Object thisKey = this.getKey();
            Object otherKey = ((NodeWithCustomKeyEquivalence)obj).getKey();
            return this.equivalence.equivalent(thisKey, otherKey);
        }
    }

    private static class ComparableNode
    extends Node
    implements Comparable<ComparableNode> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(ComparableNode.class);

        private ComparableNode() {
        }

        @Override
        public int compareTo(ComparableNode other) {
            Comparable thisKey = (Comparable)this.getKey();
            Comparable otherKey = (Comparable)other.getKey();
            return thisKey.compareTo(otherKey);
        }
    }

    static class Node<K, V>
    implements KeyValue<K, V> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(Node.class);
        long hash;
        private @Nullable K key;
        private @Nullable V value;

        Node() {
        }

        final boolean clearKeyIfNonNull() {
            if (this.key != null) {
                this.key = null;
                return true;
            }
            return false;
        }

        @Override
        public final K getKey() {
            return Utils.nonNullOrThrowCme(this.key);
        }

        @Override
        public final V getValue() {
            return Utils.nonNullOrThrowCme(this.value);
        }

        void setValue(V newValue) {
            Utils.checkNonNull(newValue);
            this.value = newValue;
        }

        public boolean equals(@Nullable Object obj) {
            Utils.verifyNonNull(obj);
            Class<?> objClass = obj.getClass();
            Utils.verifyThat(objClass == Node.class || objClass == ComparableNode.class);
            K thisKey = Utils.nonNullOrThrowCme(this.key);
            K otherKey = Utils.nonNullOrThrowCme(((Node)obj).key);
            return thisKey.equals(otherKey);
        }

        public final int hashCode() {
            return Long.hashCode(this.hash);
        }
    }

    private static class MergeLambda<K, V>
    implements BiFunction<Node<K, V>, Node<K, V>, Node<K, V>> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(MergeLambda.class);
        private final InflatedSegmentQueryContext<K, V> context;
        @Nullable BiFunction<? super V, ? super V, ? extends @Nullable V> remappingFunction;

        private MergeLambda(InflatedSegmentQueryContext<K, V> context) {
            this.context = context;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @Nullable Node<K, V> apply(Node<K, V> node, @Nullable Node<K, V> internalNode) {
            InflatedSegmentQueryContext<K, V> context = this.context;
            SmoothieMap map = ((InflatedSegmentQueryContext)context).map;
            if (internalNode != null) {
                BiFunction<V, V, @Nullable V> remappingFunction = Utils.nonNullOrThrowCme(this.remappingFunction);
                Object internalVal = Utils.nonNullOrThrowCme(((Node)internalNode).value);
                Object value = Utils.nonNullOrThrowCme(((Node)node).value);
                ((Node)node).key = null;
                ((Node)node).value = null;
                int modCount = map.getModCountOpaque();
                @Nullable V newValue = remappingFunction.apply(internalVal, value);
                map.checkModCountOrThrowCme(modCount);
                if (newValue != null) {
                    ((Node)internalNode).value = newValue;
                    return internalNode;
                }
                map.decrementSize();
                return null;
            }
            map.incrementSize();
            ((InflatedSegmentQueryContext)context).dropInternedNodeFromCache(node);
            return node;
        }
    }

    private static class ComputeLambda<K, V>
    implements BiFunction<Node<K, V>, Node<K, V>, Node<K, V>> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(ComputeLambda.class);
        private final InflatedSegmentQueryContext<K, V> context;
        @Nullable BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> remappingFunction;

        private ComputeLambda(InflatedSegmentQueryContext<K, V> context) {
            this.context = context;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @Nullable Node<K, V> apply(Node<K, V> node, @Nullable Node<K, V> internalNode) {
            InflatedSegmentQueryContext<K, V> context = this.context;
            SmoothieMap map = ((InflatedSegmentQueryContext)context).map;
            BiFunction<K, @Nullable V, @Nullable V> remappingFunction = Utils.nonNullOrThrowCme(this.remappingFunction);
            Object key = Utils.nonNullOrThrowCme(((Node)node).key);
            if (internalNode != null) {
                Object internalVal = Utils.nonNullOrThrowCme(((Node)internalNode).value);
                int modCount = map.getModCountOpaque();
                @Nullable V newValue = remappingFunction.apply(key, internalVal);
                map.checkModCountOrThrowCme(modCount);
                if (newValue != null) {
                    ((Node)node).key = null;
                    ((Node)internalNode).value = newValue;
                    return internalNode;
                }
                map.decrementSize();
                return null;
            }
            int modCount = map.getModCountOpaque();
            @Nullable V value = remappingFunction.apply(key, null);
            map.checkModCountOrThrowCme(modCount);
            if (value != null) {
                map.incrementSize();
                ((Node)node).value = value;
                ((InflatedSegmentQueryContext)context).dropInternedNodeFromCache(node);
                return node;
            }
            ((Node)node).key = null;
            return null;
        }
    }

    private static class ComputeIfAbsentLambda<K, V>
    implements Function<Node<K, V>, Node<K, V>> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(ComputeIfAbsentLambda.class);
        private final InflatedSegmentQueryContext<K, V> context;
        @Nullable Function<? super K, ? extends @Nullable V> mappingFunction;

        private ComputeIfAbsentLambda(InflatedSegmentQueryContext<K, V> context) {
            this.context = context;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @Nullable Node<K, V> apply(Node<K, V> node) {
            InflatedSegmentQueryContext<K, V> context = this.context;
            SmoothieMap map = ((InflatedSegmentQueryContext)context).map;
            Function<K, @Nullable V> mappingFunction = Utils.nonNullOrThrowCme(this.mappingFunction);
            Object key = Utils.nonNullOrThrowCme(((Node)node).key);
            int modCount = map.getModCountOpaque();
            @Nullable V value = mappingFunction.apply(key);
            map.checkModCountOrThrowCme(modCount);
            if (value != null) {
                map.incrementSize();
                ((Node)node).value = value;
                ((InflatedSegmentQueryContext)context).dropInternedNodeFromCache(node);
                return node;
            }
            ((Node)node).key = null;
            return null;
        }
    }

    private static class RemoveOrReplaceLambda<K, V>
    implements BiFunction<Node<K, V>, Node<K, V>, Node<K, V>> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(RemoveOrReplaceLambda.class);
        private final SmoothieMap<K, V> map;
        @Nullable Object matchValue;
        @Nullable V replacementValue;
        boolean removedOrReplaced;

        private RemoveOrReplaceLambda(SmoothieMap<K, V> map) {
            this.map = map;
        }

        @Override
        public @Nullable Node<K, V> apply(Node<K, V> ignored, Node<K, V> internalNode) {
            boolean valuesIdentical;
            Object matchValue = Utils.nonNullOrThrowCme(this.matchValue);
            Object internalVal = Utils.nonNullOrThrowCme(((Node)internalNode).value);
            boolean bl = valuesIdentical = internalVal == matchValue;
            if (valuesIdentical || this.map.valuesEqual(matchValue, internalVal)) {
                this.removedOrReplaced = true;
                if (this.replacementValue == null) {
                    this.map.decrementSize();
                    return null;
                }
                ((Node)internalNode).value = this.replacementValue;
                return internalNode;
            }
            this.removedOrReplaced = false;
            return internalNode;
        }

        private void clear() {
            this.matchValue = null;
            this.replacementValue = null;
        }
    }

    private static class ComputeIfPresentLambda<K, V>
    implements BiFunction<Node<K, V>, Node<K, V>, Node<K, V>> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(ComputeIfPresentLambda.class);
        private final SmoothieMap<K, V> map;
        private @Nullable K key;
        private @Nullable BiFunction<? super K, ? super V, ? extends @Nullable V> remappingFunction;
        private @Nullable Object newValueOrEntryRemoved;

        private ComputeIfPresentLambda(SmoothieMap<K, V> map) {
            this.map = map;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @Nullable Node<K, V> apply(Node<K, V> ignored, Node<K, V> internalNode) {
            SmoothieMap<K, V> map = this.map;
            BiFunction<K, V, @Nullable V> remappingFunction = Utils.nonNullOrThrowCme(this.remappingFunction);
            K key = Utils.nonNullOrThrowCme(this.key);
            Object internalVal = Utils.nonNullOrThrowCme(((Node)internalNode).value);
            int modCount = map.getModCountOpaque();
            @Nullable V newValue = remappingFunction.apply(key, internalVal);
            map.checkModCountOrThrowCme(modCount);
            if (newValue != null) {
                ((Node)internalNode).value = newValue;
                this.newValueOrEntryRemoved = newValue;
                return internalNode;
            }
            map.decrementSize();
            this.newValueOrEntryRemoved = COMPUTE_IF_PRESENT_ENTRY_REMOVED;
            return null;
        }

        void clear() {
            this.key = null;
            this.remappingFunction = null;
            this.newValueOrEntryRemoved = null;
        }
    }
}

