/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser;

import io.seata.common.util.StringUtils;
import io.seata.sqlparser.EscapeSymbol;
import io.seata.sqlparser.struct.TableMeta;

public interface EscapeHandler {
    public static final String DOT = ".";
    public static final EscapeSymbol DEFAULT_ESCAPE_SYMBOL = new EscapeSymbol('\"');

    public boolean checkIfKeyWords(String var1);

    public boolean checkIfNeedEscape(String var1, TableMeta var2);

    default public EscapeSymbol getEscapeSymbol() {
        return DEFAULT_ESCAPE_SYMBOL;
    }

    default public boolean containsEscape(String fieldOrTableName) {
        fieldOrTableName = fieldOrTableName.trim();
        EscapeSymbol escapeSymbol = this.getEscapeSymbol();
        return fieldOrTableName.charAt(0) == escapeSymbol.getLeftSymbol() && fieldOrTableName.charAt(fieldOrTableName.length() - 1) == escapeSymbol.getRightSymbol();
    }

    default public String addColNameEscape(String colName) {
        return this.addColNameEscape(colName, null);
    }

    default public String addColNameEscape(String colName, TableMeta tableMeta) {
        boolean needEscape = this.checkIfNeedEscape(colName, tableMeta);
        if (!needEscape) {
            return colName;
        }
        EscapeSymbol escapeChar = this.getEscapeSymbol();
        if (colName.contains(DOT)) {
            String str = escapeChar.getRightSymbol() + DOT;
            int dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return colName.substring(0, dotIndex + str.length()) + escapeChar.getLeftSymbol() + colName.substring(dotIndex + str.length()) + escapeChar.getRightSymbol();
            }
            str = DOT + escapeChar.getLeftSymbol();
            dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return escapeChar.getLeftSymbol() + colName.substring(0, dotIndex) + escapeChar.getRightSymbol() + colName.substring(dotIndex);
            }
            str = DOT;
            dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return escapeChar.getLeftSymbol() + colName.substring(0, dotIndex) + escapeChar.getRightSymbol() + DOT + escapeChar.getLeftSymbol() + colName.substring(dotIndex + str.length()) + escapeChar.getRightSymbol();
            }
        }
        char[] buf = new char[colName.length() + 2];
        buf[0] = escapeChar.getLeftSymbol();
        buf[buf.length - 1] = escapeChar.getRightSymbol();
        colName.getChars(0, colName.length(), buf, 1);
        return new String(buf).intern();
    }

    default public String delColNameEscape(String colName) {
        if (StringUtils.isBlank(colName)) {
            return colName;
        }
        EscapeSymbol escapeChar = this.getEscapeSymbol();
        if (colName.charAt(0) == escapeChar.getLeftSymbol() && colName.charAt(colName.length() - 1) == escapeChar.getRightSymbol()) {
            String str = escapeChar.getRightSymbol() + DOT + escapeChar.getLeftSymbol();
            int index = colName.indexOf(str);
            if (index > -1) {
                return colName.substring(1, index) + DOT + colName.substring(index + str.length(), colName.length() - 1);
            }
            return colName.substring(1, colName.length() - 1);
        }
        String str = escapeChar.getRightSymbol() + DOT;
        int index = colName.indexOf(str);
        if (index > -1 && colName.charAt(0) == escapeChar.getLeftSymbol()) {
            return colName.substring(1, index) + DOT + colName.substring(index + str.length());
        }
        str = DOT + escapeChar.getLeftSymbol();
        index = colName.indexOf(str);
        if (index > -1 && colName.charAt(colName.length() - 1) == escapeChar.getRightSymbol()) {
            return colName.substring(0, index) + DOT + colName.substring(index + str.length(), colName.length() - 1);
        }
        return colName;
    }
}

