/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.NetUtil;
import io.seata.common.util.StringUtils;
import io.seata.core.protocol.RegisterRMRequest;
import io.seata.core.protocol.RegisterTMRequest;
import io.seata.core.rpc.netty.NettyClientConfig;
import io.seata.core.rpc.netty.NettyPoolKey;
import io.seata.core.rpc.netty.NettyPoolableFactory;
import io.seata.discovery.registry.FileRegistryServiceImpl;
import io.seata.discovery.registry.RegistryFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyClientChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClientChannelManager.class);
    private final ConcurrentMap<String, Object> channelLocks = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, NettyPoolKey> poolKeyMap = new ConcurrentHashMap<String, NettyPoolKey>();
    private final ConcurrentMap<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final GenericKeyedObjectPool<NettyPoolKey, Channel> nettyClientKeyPool;
    private Function<String, NettyPoolKey> poolKeyFunction;

    NettyClientChannelManager(NettyPoolableFactory keyPoolableFactory, Function<String, NettyPoolKey> poolKeyFunction, NettyClientConfig clientConfig) {
        this.nettyClientKeyPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)keyPoolableFactory);
        this.nettyClientKeyPool.setConfig(this.getNettyPoolConfig(clientConfig));
        this.poolKeyFunction = poolKeyFunction;
    }

    private GenericKeyedObjectPool.Config getNettyPoolConfig(NettyClientConfig clientConfig) {
        GenericKeyedObjectPool.Config poolConfig = new GenericKeyedObjectPool.Config();
        poolConfig.maxActive = clientConfig.getMaxPoolActive();
        poolConfig.minIdle = clientConfig.getMinPoolIdle();
        poolConfig.maxWait = clientConfig.getMaxAcquireConnMills();
        poolConfig.testOnBorrow = clientConfig.isPoolTestBorrow();
        poolConfig.testOnReturn = clientConfig.isPoolTestReturn();
        poolConfig.lifo = clientConfig.isPoolLifo();
        return poolConfig;
    }

    ConcurrentMap<String, Channel> getChannels() {
        return this.channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel acquireChannel(String serverAddress) {
        Object lockObj;
        Channel channelToServer = (Channel)this.channels.get(serverAddress);
        if (channelToServer != null && (channelToServer = this.getExistAliveChannel(channelToServer, serverAddress)) != null) {
            return channelToServer;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("will connect to {}", (Object)serverAddress);
        }
        Object object = lockObj = CollectionUtils.computeIfAbsent(this.channelLocks, serverAddress, key -> new Object());
        synchronized (object) {
            return this.doConnect(serverAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseChannel(Channel channel, String serverAddress) {
        if (channel == null || serverAddress == null) {
            return;
        }
        try {
            Object v = this.channelLocks.get(serverAddress);
            synchronized (v) {
                Channel ch = (Channel)this.channels.get(serverAddress);
                if (ch == null) {
                    this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
                    return;
                }
                if (ch.compareTo((Object)channel) == 0) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("return to pool, rm channel:{}", (Object)channel);
                    }
                    this.destroyChannel(serverAddress, channel);
                } else {
                    this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
                }
            }
        }
        catch (Exception exx) {
            LOGGER.error(exx.getMessage());
        }
    }

    void destroyChannel(String serverAddress, Channel channel) {
        if (channel == null) {
            return;
        }
        try {
            if (channel.equals(this.channels.get(serverAddress))) {
                this.channels.remove(serverAddress);
            }
            this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
        }
        catch (Exception exx) {
            LOGGER.error("return channel to rmPool error:{}", (Object)exx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect(List<String> availList, String transactionServiceGroup) {
        HashSet<String> channelAddress = new HashSet<String>(availList.size());
        HashMap<String, Exception> failedMap = new HashMap<String, Exception>();
        try {
            for (String serverAddress : availList) {
                try {
                    this.acquireChannel(serverAddress);
                    channelAddress.add(serverAddress);
                }
                catch (Exception e) {
                    failedMap.put(serverAddress, e);
                }
            }
            if (failedMap.size() > 0) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.error("{} can not connect to {} cause:{}", new Object[]{FrameworkErrorCode.NetConnect.getErrCode(), failedMap.keySet(), failedMap.values().stream().map(Throwable::getMessage).collect(Collectors.toSet())});
                } else if (LOGGER.isDebugEnabled()) {
                    failedMap.forEach((key, value) -> LOGGER.error("{} can not connect to {} cause:{} trace information:{}", new Object[]{FrameworkErrorCode.NetConnect.getErrCode(), key, value.getMessage(), value}));
                }
            }
        }
        finally {
            if (CollectionUtils.isNotEmpty(channelAddress)) {
                ArrayList<InetSocketAddress> aliveAddress = new ArrayList<InetSocketAddress>(channelAddress.size());
                for (String address : channelAddress) {
                    String[] array = NetUtil.splitIPPortStr(address);
                    aliveAddress.add(new InetSocketAddress(array[0], Integer.parseInt(array[1])));
                }
                RegistryFactory.getInstance().refreshAliveLookup(transactionServiceGroup, aliveAddress);
            } else {
                RegistryFactory.getInstance().refreshAliveLookup(transactionServiceGroup, Collections.emptyList());
            }
        }
    }

    void reconnect(String transactionServiceGroup) {
        List<String> availList;
        try {
            availList = this.getAvailServerList(transactionServiceGroup);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get available servers: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        if (CollectionUtils.isEmpty(availList)) {
            RegistryService registryService = RegistryFactory.getInstance();
            String clusterName = registryService.getServiceGroup(transactionServiceGroup);
            if (StringUtils.isBlank(clusterName)) {
                LOGGER.error("can not get cluster name in registry config '{}{}', please make sure registry config correct", (Object)"service.vgroupMapping.", (Object)transactionServiceGroup);
                return;
            }
            if (!(registryService instanceof FileRegistryServiceImpl)) {
                LOGGER.error("no available service found in cluster '{}', please make sure registry config correct and keep your seata server running", (Object)clusterName);
            }
            return;
        }
        this.reconnect(availList, transactionServiceGroup);
    }

    void invalidateObject(String serverAddress, Channel channel) throws Exception {
        this.nettyClientKeyPool.invalidateObject(this.poolKeyMap.get(serverAddress), (Object)channel);
    }

    void registerChannel(String serverAddress, Channel channel) {
        Channel channelToServer = (Channel)this.channels.get(serverAddress);
        if (channelToServer != null && channelToServer.isActive()) {
            return;
        }
        this.channels.put(serverAddress, channel);
    }

    private Channel doConnect(String serverAddress) {
        Channel channelFromPool;
        Channel channelToServer = (Channel)this.channels.get(serverAddress);
        if (channelToServer != null && channelToServer.isActive()) {
            return channelToServer;
        }
        try {
            NettyPoolKey currentPoolKey = this.poolKeyFunction.apply(serverAddress);
            if (currentPoolKey.getMessage() instanceof RegisterTMRequest) {
                this.poolKeyMap.put(serverAddress, currentPoolKey);
            } else {
                NettyPoolKey previousPoolKey = this.poolKeyMap.putIfAbsent(serverAddress, currentPoolKey);
                if (previousPoolKey != null && previousPoolKey.getMessage() instanceof RegisterRMRequest) {
                    RegisterRMRequest registerRMRequest = (RegisterRMRequest)currentPoolKey.getMessage();
                    ((RegisterRMRequest)previousPoolKey.getMessage()).setResourceIds(registerRMRequest.getResourceIds());
                }
            }
            channelFromPool = (Channel)this.nettyClientKeyPool.borrowObject(this.poolKeyMap.get(serverAddress));
            this.channels.put(serverAddress, channelFromPool);
        }
        catch (Exception exx) {
            LOGGER.error("{} register RM failed.", (Object)FrameworkErrorCode.RegisterRM.getErrCode(), (Object)exx);
            throw new FrameworkException("can not register RM,err:" + exx.getMessage());
        }
        return channelFromPool;
    }

    private List<String> getAvailServerList(String transactionServiceGroup) throws Exception {
        List<InetSocketAddress> availInetSocketAddressList = RegistryFactory.getInstance().lookup(transactionServiceGroup);
        if (CollectionUtils.isEmpty(availInetSocketAddressList)) {
            return Collections.emptyList();
        }
        return availInetSocketAddressList.stream().map(NetUtil::toStringAddress).collect(Collectors.toList());
    }

    private Channel getExistAliveChannel(Channel rmChannel, String serverAddress) {
        int i;
        if (rmChannel.isActive()) {
            return rmChannel;
        }
        for (i = 0; i < NettyClientConfig.getMaxCheckAliveRetry(); ++i) {
            try {
                Thread.sleep(NettyClientConfig.getCheckAliveInterval());
            }
            catch (InterruptedException exx) {
                LOGGER.error(exx.getMessage());
            }
            rmChannel = (Channel)this.channels.get(serverAddress);
            if (rmChannel == null || !rmChannel.isActive()) continue;
            return rmChannel;
        }
        if (i == NettyClientConfig.getMaxCheckAliveRetry()) {
            LOGGER.warn("channel {} is not active after long wait, close it.", (Object)rmChannel);
            this.releaseChannel(rmChannel, serverAddress);
            return null;
        }
        return null;
    }
}

