/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZRemExecutor
extends SortedSetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZREM command is \"ZREM key member [member ...]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        int numDeletedMembers = 0;
        for (int i = 2; i < commandElems.size(); ++i) {
            byte[] memberArray = commandElems.get(i);
            ByteArrayWrapper member = new ByteArrayWrapper(memberArray);
            DoubleWrapper oldVal = keyRegion.remove(member);
            if (oldVal == null) continue;
            ++numDeletedMembers;
        }
        if (keyRegion.isEmpty()) {
            context.getRegionProvider().removeKey(key);
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numDeletedMembers));
    }
}

