/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hll;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.hll.CardinalityMergeException;
import org.apache.geode.internal.hll.HyperLogLogPlus;
import org.apache.geode.internal.hll.ICardinality;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hll.HllExecutor;

public class PFMergeExecutor
extends HllExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PFMERGE command is \"PFMERGE destkey sourcekey [sourcekey ...]\""));
            return;
        }
        ByteArrayWrapper destKey = command.getKey();
        this.checkAndSetDataType(destKey, context);
        Region<ByteArrayWrapper, HyperLogLogPlus> keyRegion = context.getRegionProvider().gethLLRegion();
        HyperLogLogPlus mergedHLL = keyRegion.get(destKey);
        if (mergedHLL == null) {
            mergedHLL = new HyperLogLogPlus(DEFAULT_HLL_DENSE);
        }
        ArrayList<HyperLogLogPlus> hlls = new ArrayList<HyperLogLogPlus>();
        for (int i = 2; i < commandElems.size(); ++i) {
            ByteArrayWrapper k = new ByteArrayWrapper(commandElems.get(i));
            this.checkDataType(k, RedisDataType.REDIS_HLL, context);
            HyperLogLogPlus h = keyRegion.get(k);
            if (h == null) continue;
            hlls.add(h);
        }
        if (hlls.isEmpty()) {
            context.getRegionProvider().removeKey(destKey);
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
            return;
        }
        ICardinality[] estimators = hlls.toArray(new HyperLogLogPlus[hlls.size()]);
        try {
            mergedHLL = (HyperLogLogPlus)mergedHLL.merge(estimators);
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException(e);
        }
        keyRegion.put(destKey, mergedHLL);
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
    }
}

