/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.HashMap;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HMSetExecutor
extends HashExecutor {
    private final String SUCCESS = "OK";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3 || commandElems.size() % 2 == 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HMSET command is \"HMSET key field value [field value ...]\", or not every field is associated with a value"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_HASH);
        HashMap<ByteArrayWrapper, ByteArrayWrapper> map = new HashMap<ByteArrayWrapper, ByteArrayWrapper>();
        for (int i = 2; i < commandElems.size(); i += 2) {
            byte[] fieldArray = commandElems.get(i);
            ByteArrayWrapper field = new ByteArrayWrapper(fieldArray);
            byte[] value = commandElems.get(i + 1);
            map.put(field, new ByteArrayWrapper(value));
        }
        keyRegion.putAll(map);
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
    }
}

