/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.redis.internal.Coder;

public class DoubleWrapper
implements DataSerializable,
Comparable<Object> {
    private static final long serialVersionUID = 6946858357297398633L;
    public Double score;
    private String toString;

    public DoubleWrapper() {
    }

    public DoubleWrapper(Double dubs) {
        this.score = dubs;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeDouble(this.score, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.score = DataSerializer.readDouble(in);
    }

    @Override
    public int compareTo(Object arg0) {
        Double other;
        if (arg0 instanceof DoubleWrapper) {
            other = ((DoubleWrapper)arg0).score;
        } else if (arg0 instanceof Double) {
            other = (Double)arg0;
        } else {
            return 0;
        }
        Double diff = this.score - other;
        if (diff > 0.0) {
            return 1;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = Coder.doubleToString(this.score);
        }
        return this.toString;
    }
}

