/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.utils;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.geode.internal.cache.xmlcache.CacheXmlParser;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.configuration.domain.CacheElement;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Document createDocumentFromReader(Reader reader) throws SAXException, ParserConfigurationException, IOException {
        Document doc = null;
        InputSource inputSource = new InputSource(reader);
        doc = XmlUtils.getDocumentBuilder().parse(inputSource);
        return doc;
    }

    public static NodeList query(Node node, String searchString) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (NodeList)xpath.evaluate(searchString, node, XPathConstants.NODESET);
    }

    public static NodeList query(Node node, String searchString, XPathContext xpathcontext) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(xpathcontext);
        return (NodeList)xpath.evaluate(searchString, node, XPathConstants.NODESET);
    }

    public static Element querySingleElement(Node node, String searchString, XPathContext xPathContext) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(xPathContext);
        Object result = xpath.evaluate(searchString, node, XPathConstants.NODE);
        try {
            return (Element)result;
        }
        catch (ClassCastException e) {
            throw new XPathExpressionException("Not an org.w3c.dom.Element: " + result);
        }
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new CacheXmlParser());
        return builder;
    }

    public static void addNewNode(Document doc, XmlEntity xmlEntity) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        LinkedHashMap<String, CacheElement> elementOrderMap = CacheElement.buildElementMap(doc);
        Node newNode = XmlUtils.createNode(doc, xmlEntity.getXmlDefinition());
        Element root = doc.getDocumentElement();
        int incomingElementOrder = XmlUtils.getElementOrder(elementOrderMap, xmlEntity.getNamespace(), xmlEntity.getType());
        boolean nodeAdded = false;
        NodeList nodes = root.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String type = childElement.getLocalName();
            String namespace = childElement.getNamespaceURI();
            if (namespace.equals(xmlEntity.getNamespace()) && type.equals(xmlEntity.getType())) {
                String nameOrId = XmlUtils.getAttribute(childElement, "name");
                if (nameOrId == null) {
                    nameOrId = XmlUtils.getAttribute(childElement, "id");
                }
                if (nameOrId != null) {
                    if (!nameOrId.equals(xmlEntity.getNameOrId())) continue;
                    root.replaceChild(newNode, node);
                    nodeAdded = true;
                    break;
                }
                if (XmlUtils.isMultiple(elementOrderMap, namespace, type)) continue;
                root.replaceChild(newNode, node);
                nodeAdded = true;
                break;
            }
            if (incomingElementOrder >= XmlUtils.getElementOrder(elementOrderMap, namespace, type)) continue;
            root.insertBefore(newNode, node);
            nodeAdded = true;
            break;
        }
        if (!nodeAdded) {
            root.appendChild(newNode);
        }
    }

    private static boolean isMultiple(LinkedHashMap<String, CacheElement> elementOrderMap, String namespace, String type) {
        CacheElement cacheElement;
        if ("http://geode.apache.org/schema/cache".equals(namespace) && null != (cacheElement = elementOrderMap.get(type))) {
            return cacheElement.isMultiple();
        }
        return false;
    }

    private static int getElementOrder(LinkedHashMap<String, CacheElement> elementOrderMap, String namespace, String type) {
        CacheElement cacheElement;
        if ("http://geode.apache.org/schema/cache".equals(namespace) && null != (cacheElement = elementOrderMap.get(type))) {
            return cacheElement.getOrder();
        }
        return Integer.MAX_VALUE;
    }

    private static Node createNode(Document owner, String xmlDefintion) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = new InputSource(new StringReader(xmlDefintion));
        Document document = XmlUtils.getDocumentBuilder().parse(inputSource);
        Element newNode = document.getDocumentElement();
        return owner.importNode(newNode, true);
    }

    public static String getAttribute(Node node, String name) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node attributeNode = node.getAttributes().getNamedItem(name);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getTextContent();
    }

    public static String getAttribute(Node node, String localName, String namespaceURI) {
        Node attributeNode = node.getAttributes().getNamedItemNS(namespaceURI, localName);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getTextContent();
    }

    public static final Map<String, List<String>> buildSchemaLocationMap(String schemaLocation) {
        return XmlUtils.buildSchemaLocationMap(new HashMap<String, List<String>>(), schemaLocation);
    }

    static final Map<String, List<String>> buildSchemaLocationMap(Map<String, List<String>> schemaLocationMap, String schemaLocation) {
        if (null == schemaLocation) {
            return schemaLocationMap;
        }
        if (null == schemaLocation || schemaLocation.isEmpty()) {
            return schemaLocationMap;
        }
        StringTokenizer st = new StringTokenizer(schemaLocation, " \n\t\r");
        while (st.hasMoreElements()) {
            String ns = st.nextToken();
            String loc = st.nextToken();
            List<String> locs = schemaLocationMap.get(ns);
            if (null == locs) {
                locs = new ArrayList<String>();
                schemaLocationMap.put(ns, locs);
            }
            if (locs.contains(loc)) continue;
            locs.add(loc);
        }
        return schemaLocationMap;
    }

    public static void deleteNode(Document doc, XmlEntity xmlEntity) throws Exception {
        NodeList nodes = XmlUtils.getNodes(doc, xmlEntity);
        if (nodes != null) {
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                node.getParentNode().removeChild(node);
            }
        }
    }

    public static NodeList getNodes(Document doc, XmlEntity xmlEntity) throws XPathExpressionException {
        return XmlUtils.query(doc, xmlEntity.getSearchString(), new XPathContext(xmlEntity.getPrefix(), xmlEntity.getNamespace()));
    }

    public static String prettyXml(Node doc) throws IOException, TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        return XmlUtils.transform(transformer, doc);
    }

    public static final String elementToString(Node element) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        return XmlUtils.transform(transformer, element);
    }

    private static final String transform(Transformer transformer, Node element) throws TransformerException {
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(element);
        transformer.transform(source, result);
        String xmlString = result.getWriter().toString();
        return xmlString;
    }

    public static String prettyXml(String xmlContent) throws IOException, TransformerFactoryConfigurationError, TransformerException, SAXException, ParserConfigurationException {
        Document doc = XmlUtils.createDocumentFromXml(xmlContent);
        return XmlUtils.prettyXml(doc);
    }

    public static Document createDocumentFromXml(String xmlContent) throws SAXException, ParserConfigurationException, IOException {
        return XmlUtils.createDocumentFromReader(new StringReader(xmlContent));
    }

    public static Document upgradeSchema(Document document, String namespaceUri, String schemaLocation, String schemaVersion) throws XPathExpressionException, ParserConfigurationException {
        String schemaLocationAttribute;
        Map<String, List<String>> schemaLocationMap;
        List<String> schemaLocations;
        String xsiPrefix;
        Map<String, String> namespacePrefixMap;
        String cachePrefix;
        Element root;
        if (StringUtils.isBlank(namespaceUri)) {
            throw new IllegalArgumentException("namespaceUri");
        }
        if (StringUtils.isBlank(schemaLocation)) {
            throw new IllegalArgumentException("schemaLocation");
        }
        if (StringUtils.isBlank(schemaVersion)) {
            throw new IllegalArgumentException("schemaVersion");
        }
        if (null != document.getDoctype()) {
            root = document.getDocumentElement();
            Document copiedDocument = XmlUtils.getDocumentBuilder().newDocument();
            Node copiedRoot = copiedDocument.importNode(root, true);
            copiedDocument.appendChild(copiedRoot);
            document = copiedDocument;
        }
        if (null == (cachePrefix = (namespacePrefixMap = XmlUtils.buildNamespacePrefixMap(root = document.getDocumentElement())).get(namespaceUri))) {
            cachePrefix = "";
            XmlUtils.changeNamespace(root, "", namespaceUri);
            namespacePrefixMap.put(namespaceUri, cachePrefix);
        }
        if (null == (xsiPrefix = namespacePrefixMap.get("http://www.w3.org/2001/XMLSchema-instance"))) {
            xsiPrefix = "xsi";
            root.setAttribute("xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            namespacePrefixMap.put("http://www.w3.org/2001/XMLSchema-instance", xsiPrefix);
        }
        if (null == (schemaLocations = (schemaLocationMap = XmlUtils.buildSchemaLocationMap(schemaLocationAttribute = XmlUtils.getAttribute(root, "schemaLocation", "http://www.w3.org/2001/XMLSchema-instance"))).get(namespaceUri))) {
            schemaLocations = new ArrayList<String>();
            schemaLocationMap.put(namespaceUri, schemaLocations);
        }
        schemaLocations.clear();
        schemaLocations.add(schemaLocation);
        String schemaLocationValue = XmlUtils.getSchemaLocationValue(schemaLocationMap);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", xsiPrefix + ":" + "schemaLocation", schemaLocationValue);
        if (cachePrefix == null || cachePrefix.isEmpty()) {
            root.setAttribute("version", schemaVersion);
        } else {
            root.setAttributeNS(namespaceUri, cachePrefix + ":version", schemaVersion);
        }
        return document;
    }

    private static final String getSchemaLocationValue(Map<String, List<String>> schemaLocationMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : schemaLocationMap.entrySet()) {
            for (String schemaLocation : entry.getValue()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(entry.getKey()).append(' ').append(schemaLocation);
            }
        }
        return sb.toString();
    }

    private static final Map<String, String> buildNamespacePrefixMap(Element root) {
        HashMap<String, String> namespacePrefixMap = new HashMap<String, String>();
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (!item.getNodeName().startsWith("xmlns")) continue;
            String[] splitName = item.getNodeName().split(":");
            String prefix = splitName.length > 1 ? splitName[1] : "";
            String uri = item.getTextContent();
            namespacePrefixMap.put(uri, prefix);
        }
        return namespacePrefixMap;
    }

    static final Node changeNamespace(Node node, String oldNamespaceUri, String newNamespaceUri) throws XPathExpressionException {
        Node result = null;
        NodeList nodes = XmlUtils.query(node, "//*");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node element = nodes.item(i);
            if (element.getNamespaceURI() != null && !element.getNamespaceURI().equals(oldNamespaceUri)) continue;
            Node renamed = node.getOwnerDocument().renameNode(element, newNamespaceUri, element.getNodeName());
            if (element != node) continue;
            result = renamed;
        }
        return result;
    }

    public static void modifyRootAttributes(Document doc, XmlEntity xmlEntity) throws IOException {
        if (xmlEntity == null || xmlEntity.getAttributes() == null) {
            return;
        }
        String type = xmlEntity.getType();
        Map<String, String> attributes = xmlEntity.getAttributes();
        Element root = doc.getDocumentElement();
        if (root.getLocalName().equals(type)) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attributeName = entry.getKey();
                String attributeValue = entry.getValue();
                String rootAttribute = XmlUtils.getAttribute(root, attributeName);
                if (null != rootAttribute) {
                    root.removeAttribute(rootAttribute);
                }
                root.setAttribute(attributeName, attributeValue);
            }
        }
    }

    public static String readXmlAsStringFromFile(String xmlFilePath) throws IOException, SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        File file = new File(xmlFilePath);
        if (file.length() == 0L) {
            return "";
        }
        Document doc = XmlUtils.getDocumentBuilder().parse(file);
        return XmlUtils.elementToString(doc);
    }

    public static class XPathContext
    implements NamespaceContext {
        private HashMap<String, String> prefixToUri = new HashMap();
        private HashMap<String, String> uriToPrefix = new HashMap();

        public XPathContext() {
        }

        public XPathContext(String prefix, String uri) {
            this.addNamespace(prefix, uri);
        }

        public void addNamespace(String prefix, String uri) {
            this.prefixToUri.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.prefixToUri.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.uriToPrefix.get(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return Collections.singleton(this.getPrefix(namespaceURI)).iterator();
        }
    }
}

