/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.functions;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.SharedConfiguration;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.configuration.domain.Configuration;

public class GetAllJarsFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        SharedConfiguration sharedConfig;
        InternalLocator locator = (InternalLocator)Locator.getLocator();
        if (locator != null && (sharedConfig = locator.getSharedConfiguration()) != null) {
            try {
                Map<String, Configuration> entireConfig = sharedConfig.getEntireConfiguration();
                Set<String> configNames = entireConfig.keySet();
                context.getResultSender().lastResult(sharedConfig.getAllJars(configNames));
            }
            catch (IOException e) {
                context.getResultSender().sendException(e);
            }
            catch (Exception e) {
                context.getResultSender().sendException(e);
            }
        }
        context.getResultSender().lastResult(null);
    }

    @Override
    public String getId() {
        return GetAllJarsFunction.class.getName();
    }
}

