/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.domain;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlEntity
implements DataSerializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    private String type;
    private String parentType;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String xmlDefinition;
    private String searchString;
    private String prefix = "cache";
    private String namespace = "http://geode.apache.org/schema/cache";

    @Deprecated
    public XmlEntity() {
    }

    public XmlEntity(String type, String key, String value) {
        this.type = type;
        this.attributes.put(key, value);
        this.init();
    }

    public XmlEntity(String parentType, String parentKey, String parentValue, String childType, String childKey, String childValue) {
        this.parentType = parentType;
        this.type = childType;
        StringBuffer sb = new StringBuffer();
        sb.append("//").append(this.prefix).append(':').append(parentType);
        if (!StringUtils.isBlank(parentKey) && !StringUtils.isBlank(parentValue)) {
            sb.append("[@").append(parentKey).append("='").append(parentValue).append("']");
        }
        sb.append("/").append(this.prefix).append(':').append(childType);
        if (!StringUtils.isBlank(childKey) && !StringUtils.isBlank(childValue)) {
            sb.append("[@").append(childKey).append("='").append(childValue).append("']");
        }
        this.searchString = sb.toString();
    }

    private final void init() {
        Assert.assertTrue(!StringUtils.isBlank(this.type));
        Assert.assertTrue(!StringUtils.isBlank(this.prefix));
        Assert.assertTrue(!StringUtils.isBlank(this.namespace));
        Assert.assertTrue(this.attributes != null);
        if (null == this.xmlDefinition) {
            this.xmlDefinition = this.loadXmlDefinition();
        }
    }

    private final String loadXmlDefinition() {
        Cache cache = CacheFactory.getAnyInstance();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        CacheXmlGenerator.generate(cache, printWriter, true, false, false);
        printWriter.close();
        return this.loadXmlDefinition(stringWriter.toString());
    }

    private final String loadXmlDefinition(String xmlDocument) {
        Cache cache = CacheFactory.getAnyInstance();
        try {
            InputSource inputSource = new InputSource(new StringReader(xmlDocument));
            return this.loadXmlDefinition(XmlUtils.getDocumentBuilder().parse(inputSource));
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | XPathExpressionException | SAXException e) {
            throw new InternalGemFireError("Could not parse XML when creating XMLEntity", e);
        }
    }

    private final String loadXmlDefinition(Document document) throws XPathExpressionException, TransformerFactoryConfigurationError, TransformerException {
        Cache cache = CacheFactory.getAnyInstance();
        this.searchString = this.createQueryString(this.prefix, this.type, this.attributes);
        logger.info("XmlEntity:searchString: {}", (Object)this.searchString);
        if (document != null) {
            XmlUtils.XPathContext xpathContext = new XmlUtils.XPathContext();
            xpathContext.addNamespace(this.prefix, this.namespace);
            Element element = XmlUtils.querySingleElement(document, this.searchString, xpathContext);
            if (null != element) {
                return XmlUtils.elementToString(element);
            }
        }
        logger.warn("No XML definition could be found with name={} and attributes={}", (Object)this.type, this.attributes);
        return null;
    }

    private String createQueryString(String prefix, String element, Map<String, String> attributes) {
        StringBuilder queryStringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> attributeIter = attributes.entrySet().iterator();
        queryStringBuilder.append("//").append(prefix).append(':').append(element);
        if (attributes.size() > 0) {
            queryStringBuilder.append("[");
            Map.Entry<String, String> attrEntry = attributeIter.next();
            queryStringBuilder.append("@").append(attrEntry.getKey()).append("='").append(attrEntry.getValue()).append("'");
            while (attributeIter.hasNext()) {
                attrEntry = attributeIter.next();
                queryStringBuilder.append(" and @").append(attrEntry.getKey()).append("='").append(attrEntry.getValue()).append("'");
            }
            queryStringBuilder.append("]");
        }
        return queryStringBuilder.toString();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String getNameOrId() {
        if (this.attributes.containsKey("name")) {
            return this.attributes.get("name");
        }
        return this.attributes.get("id");
    }

    public String getXmlDefinition() {
        return this.xmlDefinition;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return "XmlEntity [namespace=" + this.namespace + ", type=" + this.type + ", attributes=" + this.attributes + ", xmlDefinition=" + this.xmlDefinition + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmlEntity other = (XmlEntity)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.type, out);
        DataSerializer.writeObject(this.attributes, out);
        DataSerializer.writeString(this.xmlDefinition, out);
        DataSerializer.writeString(this.searchString, out);
        DataSerializer.writeString(this.prefix, out);
        DataSerializer.writeString(this.namespace, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.type = DataSerializer.readString(in);
        this.attributes = (Map)DataSerializer.readObject(in);
        this.xmlDefinition = DataSerializer.readString(in);
        this.searchString = DataSerializer.readString(in);
        this.prefix = DataSerializer.readString(in);
        this.namespace = DataSerializer.readString(in);
    }

    public static final XmlEntityBuilder builder() {
        return new XmlEntityBuilder();
    }

    public static final class XmlEntityBuilder {
        private XmlEntity xmlEntity = new XmlEntity();

        private XmlEntityBuilder() {
        }

        public XmlEntity build() {
            this.xmlEntity.init();
            XmlEntity built = this.xmlEntity;
            this.xmlEntity = new XmlEntity();
            return built;
        }

        public XmlEntityBuilder withType(String type) {
            this.xmlEntity.type = type;
            return this;
        }

        public XmlEntityBuilder withNamespace(String prefix, String namespace) {
            this.xmlEntity.prefix = prefix;
            this.xmlEntity.namespace = namespace;
            return this;
        }

        public XmlEntityBuilder withAttribute(String name, String value) {
            this.xmlEntity.attributes.put(name, value);
            return this;
        }

        public XmlEntityBuilder withAttributes(Map<String, String> attributes) {
            this.xmlEntity.attributes = attributes;
            return this;
        }

        public XmlEntityBuilder withConfig(String xmlDocument) {
            this.xmlEntity.xmlDefinition = this.xmlEntity.loadXmlDefinition(xmlDocument);
            return this;
        }

        public XmlEntityBuilder withConfig(Document document) throws XPathExpressionException, TransformerFactoryConfigurationError, TransformerException {
            this.xmlEntity.xmlDefinition = this.xmlEntity.loadXmlDefinition(document);
            return this;
        }
    }
}

