/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;

public class LogLevelExtractor {
    private static Pattern LOG_PATTERN = Pattern.compile("^\\[(\\S*)\\s+([\\d\\/]+)\\s+([\\d:\\.]+)\\s+(\\S+)");
    private static DateTimeFormatter LOG_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS zzz");
    private static final String SPACE = " ";
    private static Map<String, Level> LEVELS = new HashMap<String, Level>();

    public static Result extract(String logLine) {
        Matcher m = LOG_PATTERN.matcher(logLine);
        if (!m.find()) {
            return null;
        }
        String logLevel = m.group(1);
        String logTimestamp = m.group(2) + SPACE + m.group(3) + SPACE + m.group(4);
        LocalDateTime timestamp = LocalDateTime.parse(logTimestamp, LOG_TIMESTAMP_FORMATTER);
        return new Result(logLevel, timestamp);
    }

    public static Level getLevel(String level) {
        Level log4jLevel = LEVELS.get(level.toUpperCase());
        return log4jLevel == null ? Level.OFF : log4jLevel;
    }

    static {
        Arrays.stream(Level.values()).forEach(level -> LEVELS.put(level.name(), (Level)level));
        LEVELS.put("SEVERE", Level.FATAL);
        LEVELS.put("WARNING", Level.WARN);
        LEVELS.put("CONFIG", Level.DEBUG);
        LEVELS.put("FINE", Level.DEBUG);
        LEVELS.put("FINER", Level.TRACE);
        LEVELS.put("FINEST", Level.TRACE);
    }

    public static class Result {
        private Level logLevel;
        private LocalDateTime logTimestamp;

        public Result(String logLevel, LocalDateTime logTimestamp) {
            this.logLevel = LogLevelExtractor.getLevel(logLevel);
            this.logTimestamp = logTimestamp;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }

        public LocalDateTime getLogTimestamp() {
            return this.logTimestamp;
        }
    }
}

