/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.util.LogLevelExtractor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LogFilter {
    private static final Logger LOGGER = LogService.getLogger();
    private final Level thisLogLevel;
    private final boolean thisLevelOnly;
    private final LocalDateTime startDate;
    private final LocalDateTime endDate;
    private LineFilterResult resultOfPreviousLine = LineFilterResult.LINE_ACCEPTED;

    public LogFilter(Level logLevel, LocalDateTime startDate, LocalDateTime endDate) {
        this(logLevel, false, startDate, endDate);
    }

    public LogFilter(Level logLevel, boolean thisLevelOnly, LocalDateTime startDate, LocalDateTime endDate) {
        assert (logLevel != null);
        this.thisLogLevel = logLevel;
        this.thisLevelOnly = thisLevelOnly;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public void startNewFile() {
        this.resultOfPreviousLine = LineFilterResult.LINE_ACCEPTED;
    }

    public LineFilterResult acceptsLine(String logLine) {
        LogLevelExtractor.Result result = LogLevelExtractor.extract(logLine);
        return this.acceptsLogEntry(result);
    }

    protected LineFilterResult acceptsLogEntry(LogLevelExtractor.Result result) {
        if (result == null) {
            return this.resultOfPreviousLine;
        }
        return this.acceptsLogEntry(result.getLogLevel(), result.getLogTimestamp());
    }

    protected LineFilterResult acceptsLogEntry(Level logLevel, LocalDateTime logTimestamp) {
        if (logTimestamp == null || logLevel == null) {
            throw new IllegalArgumentException();
        }
        LineFilterResult result = this.endDate != null && logTimestamp.isAfter(this.endDate) ? LineFilterResult.REMAINDER_OF_FILE_REJECTED : (this.startDate != null && logTimestamp.isBefore(this.startDate) ? LineFilterResult.LINE_REJECTED : (this.thisLevelOnly ? (logLevel.intLevel() == this.thisLogLevel.intLevel() ? LineFilterResult.LINE_ACCEPTED : LineFilterResult.LINE_REJECTED) : (logLevel.isMoreSpecificThan(this.thisLogLevel) ? LineFilterResult.LINE_ACCEPTED : LineFilterResult.LINE_REJECTED)));
        this.resultOfPreviousLine = result;
        return result;
    }

    public boolean acceptsFile(Path file) {
        if (this.startDate == null && this.endDate == null) {
            return true;
        }
        if (this.endDate == null) {
            return LogFilter.getEndTimeOf(file).isAfter(this.startDate);
        }
        if (this.startDate == null) {
            return LogFilter.getStartTimeOf(file).isBefore(this.endDate);
        }
        return LogFilter.getEndTimeOf(file).isAfter(this.startDate) && LogFilter.getStartTimeOf(file).isBefore(this.endDate);
    }

    private static LocalDateTime getEndTimeOf(Path file) {
        try {
            long lastModifiedMillis = file.toFile().lastModified();
            return Instant.ofEpochMilli(lastModifiedMillis).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (Exception e) {
            LOGGER.error("Unable to determine lastModified time", (Throwable)e);
            return LocalDateTime.MAX;
        }
    }

    private static LocalDateTime getStartTimeOf(Path file) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            long lastModifiedMillis = attributes.creationTime().toMillis();
            return Instant.ofEpochMilli(lastModifiedMillis).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (Exception e) {
            LOGGER.error("Unable to determine creation time", (Throwable)e);
            return LocalDateTime.MIN;
        }
    }

    public static enum LineFilterResult {
        LINE_ACCEPTED,
        LINE_REJECTED,
        REMAINDER_OF_FILE_REJECTED;

    }
}

