/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.AbstractResultData;
import org.apache.geode.management.internal.cli.result.CliJsonSerializable;
import org.apache.geode.management.internal.cli.result.CliJsonSerializableFactory;
import org.apache.geode.management.internal.cli.result.ResultDataException;

public class ObjectResultData<T extends CliJsonSerializable>
extends AbstractResultData {
    public static final String OBJECTS_ACCESSOR = "__objects__";

    ObjectResultData() {
    }

    ObjectResultData(GfJsonObject gfJsonObject) {
        super(gfJsonObject);
    }

    @Override
    public String getType() {
        return "object";
    }

    public ObjectResultData<T> addObject(T infoBean) {
        try {
            this.contentObject.accumulateAsJSONObject(OBJECTS_ACCESSOR, infoBean);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    public ObjectResultData<T> addCollection(Collection<T> infoBeans) {
        for (CliJsonSerializable infoBean : infoBeans) {
            try {
                this.contentObject.accumulateAsJSONObject(OBJECTS_ACCESSOR, infoBean);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
        }
        return this;
    }

    public List<CliJsonSerializable> getAllObjects() {
        ArrayList<CliJsonSerializable> list = new ArrayList<CliJsonSerializable>();
        try {
            GfJsonArray rootJsonArray = this.contentObject.getJSONArray(OBJECTS_ACCESSOR);
            int size = rootJsonArray.size();
            GfJsonObject jsonObject = null;
            CliJsonSerializable cliJsonSerializable = null;
            for (int i = 0; i < size; ++i) {
                jsonObject = rootJsonArray.getJSONObject(i);
                cliJsonSerializable = CliJsonSerializableFactory.getCliJsonSerializable(jsonObject.getInt("JSId"));
                cliJsonSerializable.fromJson(jsonObject);
                list.add(cliJsonSerializable);
            }
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return list;
    }
}

