/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.parser.preprocessor;

import java.util.ArrayList;
import org.apache.geode.management.internal.cli.parser.preprocessor.PreprocessorUtils;

public class Preprocessor {
    private static final String VALUE_SPECIFIER = "=";
    private static final String ARGUMENT_SEPARATOR = "?";
    private static final String OPTION_SEPARATOR = " ";
    private static final String LONG_OPTION_SPECIFIER = "--";
    private static final String OPTION_DELIMITER = " --";

    public static String[] split(String input) {
        if (input == null) {
            return null;
        }
        String trimInput = PreprocessorUtils.trim(input).getString();
        int length = trimInput.length();
        ArrayList<String> returnStrings = new ArrayList<String>();
        int index = 0;
        int startOfString = 0;
        if (!trimInput.regionMatches(index, LONG_OPTION_SPECIFIER, 0, LONG_OPTION_SPECIFIER.length())) {
            while (index < length && !trimInput.regionMatches(index, OPTION_DELIMITER, 0, OPTION_DELIMITER.length())) {
                if (trimInput.charAt(index) == '\'' || trimInput.charAt(index) == '\"') {
                    char charToLookFor = trimInput.charAt(index++);
                    while (index < length && (trimInput.charAt(index) != charToLookFor || trimInput.charAt(index - 1) == '\\')) {
                        ++index;
                    }
                }
                if (++index < length && !trimInput.regionMatches(index, OPTION_DELIMITER, 0, OPTION_DELIMITER.length()) && !trimInput.regionMatches(index, ARGUMENT_SEPARATOR, 0, ARGUMENT_SEPARATOR.length())) continue;
                String stringToAdd = trimInput.substring(startOfString, index > length ? length : index).trim();
                returnStrings.add(stringToAdd);
                if (trimInput.regionMatches(index, ARGUMENT_SEPARATOR, 0, ARGUMENT_SEPARATOR.length())) {
                    index += ARGUMENT_SEPARATOR.length();
                }
                startOfString = index;
            }
            index += OPTION_SEPARATOR.length();
        }
        startOfString = index;
        while (index < length) {
            while (index < length && !trimInput.regionMatches(index, OPTION_SEPARATOR, 0, OPTION_SEPARATOR.length()) && !trimInput.regionMatches(index, VALUE_SPECIFIER, 0, VALUE_SPECIFIER.length())) {
                ++index;
            }
            if (startOfString != index) {
                returnStrings.add(trimInput.substring(startOfString, index));
                startOfString = index + 1;
            }
            if (!trimInput.regionMatches(index++, VALUE_SPECIFIER, 0, VALUE_SPECIFIER.length())) continue;
            startOfString = index;
            while (index < length && !trimInput.regionMatches(index, OPTION_SEPARATOR, 0, OPTION_SEPARATOR.length())) {
                if (index < length && (trimInput.charAt(index) == '\'' || trimInput.charAt(index) == '\"')) {
                    char charToLookFor = trimInput.charAt(index++);
                    while (index < length && (trimInput.charAt(index) != charToLookFor || trimInput.charAt(index - 1) == '\\')) {
                        ++index;
                    }
                }
                ++index;
            }
            if (index >= length || trimInput.regionMatches(index, OPTION_SEPARATOR, 0, OPTION_SEPARATOR.length())) {
                if (startOfString == index) {
                    returnStrings.add("__NULL__");
                } else {
                    String stringToAdd = trimInput.substring(startOfString, index > length ? length : index);
                    returnStrings.add(stringToAdd);
                }
                startOfString = index + 1;
            }
            ++index;
        }
        return returnStrings.toArray(new String[0]);
    }
}

