/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.parser;

import java.lang.reflect.InvocationTargetException;
import org.apache.geode.management.internal.cli.parser.AvailabilityTarget;
import org.apache.geode.management.internal.cli.parser.GfshMethodTarget;
import org.apache.geode.management.internal.cli.parser.GfshOptionParser;

public class CommandTarget {
    private final String commandName;
    private final String[] synonyms;
    private final String commandHelp;
    private final GfshMethodTarget gfshMethodTarget;
    private final GfshOptionParser optionParser;
    private AvailabilityTarget availabilityIndicator;

    public CommandTarget(String commandName, String[] synonyms, GfshMethodTarget methodTarget, GfshOptionParser optionParser, AvailabilityTarget availabilityIndicator, String commandHelp) {
        this.commandName = commandName;
        this.synonyms = synonyms;
        this.gfshMethodTarget = methodTarget;
        this.optionParser = optionParser;
        this.availabilityIndicator = availabilityIndicator;
        this.commandHelp = commandHelp;
    }

    public GfshMethodTarget getGfshMethodTarget() {
        return this.gfshMethodTarget;
    }

    public GfshOptionParser getOptionParser() {
        return this.optionParser;
    }

    public boolean isAvailable() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.availabilityIndicator != null) {
            return (Boolean)this.availabilityIndicator.getMethod().invoke(this.availabilityIndicator.getTarget(), new Object[0]);
        }
        return true;
    }

    public AvailabilityTarget getAvailabilityIndicator() {
        return this.availabilityIndicator;
    }

    public void setAvailabilityIndicator(AvailabilityTarget availabilityIndicator) {
        this.availabilityIndicator = availabilityIndicator;
    }

    public String getCommandHelp() {
        return this.commandHelp;
    }

    public CommandTarget duplicate(String key) {
        return this.duplicate(key, null);
    }

    public CommandTarget duplicate(String key, String remainingBuffer) {
        return new CommandTarget(this.commandName, this.synonyms, new GfshMethodTarget(this.gfshMethodTarget.getMethod(), this.gfshMethodTarget.getTarget(), remainingBuffer, key), this.optionParser, this.availabilityIndicator, this.commandHelp);
    }

    public int hashCode() {
        int prime = 47;
        int result = 3;
        result = 47 * result + (this.commandName == null ? 0 : this.commandName.hashCode());
        result = 47 * result + (this.commandHelp == null ? 0 : this.commandHelp.hashCode());
        result = 47 * result + (this.gfshMethodTarget == null ? 0 : this.gfshMethodTarget.hashCode());
        result = 47 * result + (this.optionParser == null ? 0 : this.optionParser.hashCode());
        result = 47 * result + (this.availabilityIndicator == null ? 0 : this.availabilityIndicator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandTarget commandTarget = (CommandTarget)obj;
        if (this.commandName == null ? commandTarget.getCommandName() != null : !this.commandName.equals(commandTarget.getCommandName())) {
            return false;
        }
        if (this.commandHelp == null ? commandTarget.getCommandHelp() != null : !this.commandHelp.equals(commandTarget.getCommandHelp())) {
            return false;
        }
        if (this.gfshMethodTarget == null ? commandTarget.getGfshMethodTarget() != null : !this.gfshMethodTarget.equals(commandTarget.getGfshMethodTarget())) {
            return false;
        }
        if (this.optionParser == null ? commandTarget.getOptionParser() != null : !this.optionParser.equals(commandTarget.getOptionParser())) {
            return false;
        }
        return !(this.availabilityIndicator == null ? commandTarget.getAvailabilityIndicator() != null : !this.availabilityIndicator.equals(commandTarget.getAvailabilityIndicator()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(CommandTarget.class.getSimpleName()).append("[commandName=" + this.commandName).append(",commandHelp=" + this.commandHelp);
        builder.append(",synonyms=");
        if (this.synonyms != null) {
            for (String string : this.synonyms) {
                builder.append(string + " ");
            }
        }
        builder.append(",gfshMethodTarget=" + this.gfshMethodTarget);
        builder.append(",optionParser=" + this.optionParser);
        builder.append(",availabilityIndicator=" + this.availabilityIndicator);
        builder.append("]");
        return builder.toString();
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String[] getSynonyms() {
        return this.synonyms;
    }
}

