/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.SharedConfiguration;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

public class LoadSharedConfigurationFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        String memberName = locator.getDistributedSystem().getName();
        try {
            if (locator.isSharedConfigurationRunning()) {
                SharedConfiguration sc = locator.getSharedConfiguration();
                sc.loadSharedConfigurationFromDisk();
                CliFunctionResult cliFunctionResult = new CliFunctionResult(memberName, true, "Cluster configuration successfully imported");
                context.getResultSender().lastResult(cliFunctionResult);
            } else {
                CliFunctionResult cliFunctionResult = new CliFunctionResult(memberName, false, "Cluster configuration service is enabled but has not started yet.");
                context.getResultSender().lastResult(cliFunctionResult);
            }
        }
        catch (Exception e) {
            context.getResultSender().lastResult(new CliFunctionResult(memberName, e, CliUtil.stackTraceAsString(e)));
        }
    }

    @Override
    public String getId() {
        return LoadSharedConfigurationFunction.class.getName();
    }
}

